/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.item.tools;

import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketTitle;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.data.radio.IRadioDevice;
import pl.pabilo8.immersiveintelligence.api.utils.ItemTooltipHandler;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.network.IIMessage;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageIITileSync;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;
import pl.pabilo8.immersiveintelligence.common.util.item.IIItemEnum;
import pl.pabilo8.immersiveintelligence.common.util.item.ItemIISubItemsBase;

public class ItemIIRadioTuner
extends ItemIISubItemsBase<RadioTuners>
implements ItemTooltipHandler.IItemScrollable {
    public static final String TAG_PREV_FREQUENCY = "prev_frequency";
    public static final String TAG_FREQUENCY = "frequency";

    public ItemIIRadioTuner() {
        super("radio_configurator", 1, (Enum[])RadioTuners.values());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<String> list, @Nonnull ITooltipFlag flag) {
        RadioTuners tuner = (RadioTuners)this.stackToSub(stack);
        list.add(IIUtils.getItalicString(I18n.func_135052_a((String)("desc.immersiveintelligence.radio_configurator_" + tuner.func_176610_l()), (Object[])new Object[0])));
        list.add(I18n.func_135052_a((String)"desc.immersiveintelligence.radio_configurator_max_frequency", (Object[])new Object[]{TextFormatting.GOLD.toString() + tuner.maxFrequency + TextFormatting.RESET}));
        list.add(I18n.func_135052_a((String)"desc.immersiveintelligence.radio_configurator_frequency", (Object[])new Object[]{TextFormatting.GOLD.toString() + ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_FREQUENCY) + TextFormatting.RESET}));
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        EasyNBT nbt = EasyNBT.wrapNBT(stack);
        int frequency = nbt.getInt(TAG_FREQUENCY);
        if (nbt.getInt(TAG_PREV_FREQUENCY) != frequency) {
            nbt.withInt(TAG_PREV_FREQUENCY, frequency);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer player, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return EnumActionResult.FAIL;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof IRadioDevice) {
            int maxFrequency;
            ItemStack stack = player.func_184586_b(hand);
            int frequency = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_FREQUENCY);
            IRadioDevice device = (IRadioDevice)tile;
            int n = maxFrequency = device.isBasicRadio() ? IIConfigHandler.IIConfig.radioBasicMaxFrequency : IIConfigHandler.IIConfig.radioAdvancedMaxFrequency;
            if (!player.func_70093_af()) {
                if (frequency > maxFrequency) {
                    IIPacketHandler.sendChatTranslation(player, "info.immersiveintelligence.frequency_invalid", maxFrequency);
                } else {
                    device.setFrequency(frequency);
                    IIPacketHandler.sendChatTranslation(player, "info.immersiveintelligence.frequency_set", device.getFrequency());
                }
            } else {
                ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_FREQUENCY, (int)frequency);
                ItemIIRadioTuner.sendSetFrequencyPacket((EntityPlayerMP)player, frequency);
            }
            IIPacketHandler.sendToClient(tile, (IIMessage)new MessageIITileSync((TileEntityIEBase)tile));
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    @Override
    public void onScroll(ItemStack stack, boolean forward, EntityPlayerMP player) {
        RadioTuners tuner = (RadioTuners)this.stackToSub(stack);
        int frequency = IIUtils.cycleInt(forward, ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_FREQUENCY), 0, tuner.maxFrequency);
        ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_FREQUENCY, (int)frequency);
        ItemIIRadioTuner.sendSetFrequencyPacket(player, frequency);
    }

    private static void sendSetFrequencyPacket(EntityPlayerMP player, int frequency) {
        player.field_71135_a.func_147359_a((Packet)new SPacketTitle(SPacketTitle.Type.ACTIONBAR, (ITextComponent)new TextComponentTranslation("desc.immersiveintelligence.radio_configurator_frequency", new Object[]{frequency}), 0, 20, 0));
    }

    public static enum RadioTuners implements IIItemEnum
    {
        BASIC(IIConfigHandler.IIConfig.radioBasicMaxFrequency),
        ADVANCED(IIConfigHandler.IIConfig.radioAdvancedMaxFrequency);

        final int maxFrequency;

        private RadioTuners(int maxFrequency) {
            this.maxFrequency = maxFrequency;
        }
    }
}

