/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.item.weapons;

import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.utils.ItemTooltipHandler;
import pl.pabilo8.immersiveintelligence.api.utils.tools.IAdvancedZoomTool;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IISounds;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ItemIIGunBase;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ItemIIWeaponUpgrade;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ammohandler.AmmoHandler;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ammohandler.AmmoHandlerMagazine;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ammohandler.AmmoHandlerSingle;
import pl.pabilo8.immersiveintelligence.common.util.AdvancedSounds;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;
import pl.pabilo8.immersiveintelligence.common.util.item.IIItemEnum;

public class ItemIIAssaultRifle
extends ItemIIGunBase
implements ItemTooltipHandler.IItemScrollable,
IAdvancedZoomTool,
EnergyHelper.IIEEnergyItem {
    public static final String FIRE_MODE = "fire_mode";
    public static final String LAST_FIRE_MODE = "last_mode";
    public static final String FIRE_MODE_TIMER = "mode_switch";
    public static final String LOADED_GRENADE = "grenade";
    public static final String ENERGY_UPGRADED = "energy";
    public static final ResourceLocation OVERLAY_SCOPE = new ResourceLocation("immersiveintelligence", "textures/gui/item/machinegun/scope.png");
    public static final ResourceLocation OVERLAY_SCOPE_IR = new ResourceLocation("immersiveintelligence", "textures/gui/item/machinegun/scope_infrared.png");
    private final AmmoHandlerMagazine stgAmmoHandler = new AmmoHandlerMagazine(this, "magazine", IIContent.itemAmmoAssaultRifle){

        @Override
        @Nullable
        protected SoundEvent getUnloadSound(ItemStack weapon, EasyNBT nbt) {
            return IISounds.assaultRifleUnload;
        }

        @Override
        @Nullable
        protected SoundEvent getReloadSound(ItemStack weapon, EasyNBT nbt) {
            return IISounds.assaultRifleReload;
        }
    };
    private final AmmoHandlerSingle railgunAmmoHandler = new AmmoHandlerSingle(this, "grenade", IIContent.itemRailgunGrenade){

        @Override
        @Nullable
        protected SoundEvent getUnloadSound(ItemStack weapon, EasyNBT nbt) {
            return null;
        }

        @Override
        @Nullable
        protected SoundEvent getReloadSound(ItemStack weapon, EasyNBT nbt) {
            return IISounds.assaultRifleLoadGrenade;
        }
    };

    public ItemIIAssaultRifle() {
        super("assault_rifle");
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
        if (isSelected) {
            EasyNBT nbt = EasyNBT.wrapNBT(ItemNBTHelper.getTag((ItemStack)stack));
            nbt.checkSetInt(FIRE_MODE_TIMER, i -> nbt.withInt(FIRE_MODE_TIMER, Math.max(i - 1, 0)));
            if (this.hasIIUpgrade(stack, (IIItemEnum)ItemIIWeaponUpgrade.WeaponUpgrades.GYROSCOPIC_STABILIZER) && this.getEnergyStored(stack) >= IIConfigHandler.IIConfig.Weapons.AssaultRifle.upgradeStabilizerEnergy && (ItemNBTHelper.getFloat((ItemStack)stack, (String)"recoilH") > 0.0f || ItemNBTHelper.getFloat((ItemStack)stack, (String)"recoilV") > 0.0f)) {
                this.extractEnergy(stack, IIConfigHandler.IIConfig.Weapons.AssaultRifle.upgradeStabilizerEnergy, false);
            }
            if (entity instanceof EntityLivingBase && this.isAimed(stack) && this.hasIIUpgrade(stack, (IIItemEnum)ItemIIWeaponUpgrade.WeaponUpgrades.INFRARED_SCOPE) && this.extractEnergy(stack, IIConfigHandler.IIConfig.Weapons.AssaultRifle.upgradeIRScopeEnergy, false) > 0) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76439_r, 4, 1, true, false));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<String> list, @Nonnull ITooltipFlag flag) {
        if (this.isEnergyUpgraded(stack)) {
            list.add(IIUtils.getItalicString(I18n.func_135052_a((String)"info.immersiveintelligence.charge_with_if", (Object[])new Object[0])));
            list.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.energyStored", (Object[])new Object[]{TextFormatting.GOLD + String.valueOf(this.getEnergyStored(stack)) + TextFormatting.RESET}));
            list.add("");
        }
        super.func_77624_a(stack, world, list, flag);
    }

    @Override
    public AmmoHandler getAmmoHandler(ItemStack weapon) {
        return ItemNBTHelper.getInt((ItemStack)weapon, (String)FIRE_MODE) < 2 ? this.stgAmmoHandler : this.railgunAmmoHandler;
    }

    @Override
    protected ItemIIGunBase.FireModeType getFireMode(ItemStack weapon) {
        switch (ItemNBTHelper.getInt((ItemStack)weapon, (String)FIRE_MODE)) {
            case 2: {
                return ItemIIGunBase.FireModeType.SINGULAR_CHARGED;
            }
            case 1: {
                return ItemIIGunBase.FireModeType.SINGULAR;
            }
        }
        return ItemIIGunBase.FireModeType.AUTOMATIC;
    }

    public int getSlotCount(ItemStack stack) {
        return 3;
    }

    @Override
    protected double getEquipSpeed(ItemStack weapon, EasyNBT nbt) {
        return 0.75;
    }

    @Override
    protected void createProjectile(EntityLivingBase user, World world, Vec3d dir, Vec3d pos, ItemStack weapon, EasyNBT nbt, ItemStack ammo) {
        int stored = this.getEnergyStored(weapon);
        if (this.hasIIUpgrade(weapon, (IIItemEnum)ItemIIWeaponUpgrade.WeaponUpgrades.ELECTRIC_FIRING_MOTOR) && stored >= IIConfigHandler.IIConfig.Weapons.AssaultRifle.upgradeFiringMotorEnergy) {
            world.func_184148_a(null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, IESounds.spark, SoundCategory.PLAYERS, 0.5f, 1.5f);
            this.extractEnergy(weapon, IIConfigHandler.IIConfig.Weapons.AssaultRifle.upgradeFiringMotorEnergy, false);
        }
        if (this.hasIIUpgrade(weapon, (IIItemEnum)ItemIIWeaponUpgrade.WeaponUpgrades.RAILGUN_ASSISTED_CHAMBER) && stored >= IIConfigHandler.IIConfig.Weapons.AssaultRifle.upgradeRailgunChamberEnergy) {
            world.func_184148_a(null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, IESounds.railgunFire, SoundCategory.PLAYERS, 0.5f, 1.0f);
            this.extractEnergy(weapon, IIConfigHandler.IIConfig.Weapons.AssaultRifle.upgradeRailgunChamberEnergy, false);
        }
        super.createProjectile(user, world, dir, pos, weapon, nbt, ammo);
    }

    @Override
    protected float getVelocityModifier(ItemStack weapon, EasyNBT nbt, ItemStack ammo) {
        switch (ItemNBTHelper.getInt((ItemStack)weapon, (String)FIRE_MODE)) {
            case 0: {
                return this.hasIIUpgrade(weapon, (IIItemEnum)ItemIIWeaponUpgrade.WeaponUpgrades.ELECTRIC_FIRING_MOTOR) && this.getEnergyStored(weapon) >= IIConfigHandler.IIConfig.Weapons.AssaultRifle.upgradeFiringMotorEnergy ? 0.75f : 1.0f;
            }
            case 1: {
                return this.hasIIUpgrade(weapon, (IIItemEnum)ItemIIWeaponUpgrade.WeaponUpgrades.RAILGUN_ASSISTED_CHAMBER) && this.getEnergyStored(weapon) >= IIConfigHandler.IIConfig.Weapons.AssaultRifle.upgradeRailgunChamberEnergy ? 1.5f : 1.25f;
            }
            case 2: {
                return 0.55f;
            }
        }
        return 1.0f;
    }

    @Override
    public int getFireDelay(ItemStack weapon, EasyNBT nbt) {
        switch (ItemNBTHelper.getInt((ItemStack)weapon, (String)FIRE_MODE)) {
            case 0: {
                if (this.hasIIUpgrade(weapon, (IIItemEnum)ItemIIWeaponUpgrade.WeaponUpgrades.ELECTRIC_FIRING_MOTOR) && this.getEnergyStored(weapon) >= IIConfigHandler.IIConfig.Weapons.AssaultRifle.upgradeFiringMotorEnergy) {
                    return 1;
                }
                return IIConfigHandler.IIConfig.Weapons.AssaultRifle.bulletFireTimeAuto;
            }
            case 1: {
                if (this.hasIIUpgrade(weapon, (IIItemEnum)ItemIIWeaponUpgrade.WeaponUpgrades.RAILGUN_ASSISTED_CHAMBER)) {
                    return 10;
                }
                return IIConfigHandler.IIConfig.Weapons.AssaultRifle.bulletFireTimeSemiAuto;
            }
            case 2: {
                return 40;
            }
        }
        return 0;
    }

    @Override
    public float getRecoilDecay(ItemStack weapon, EasyNBT nbt, boolean isAimed) {
        if (this.hasIIUpgrade(weapon, (IIItemEnum)ItemIIWeaponUpgrade.WeaponUpgrades.GYROSCOPIC_STABILIZER) && this.getEnergyStored(weapon) >= IIConfigHandler.IIConfig.Weapons.AssaultRifle.upgradeStabilizerEnergy) {
            return isAimed ? 0.65f : 0.2f;
        }
        return super.getRecoilDecay(weapon, nbt, isAimed);
    }

    @Override
    @Nullable
    protected SoundEvent getDryfireSound(ItemStack weapon, EasyNBT nbt) {
        return IISounds.assaultRifleShotDry;
    }

    @Override
    @Nullable
    protected AdvancedSounds.RangedSound getFireSound(ItemStack weapon, EasyNBT nbt) {
        return ItemNBTHelper.getInt((ItemStack)weapon, (String)FIRE_MODE) == 2 ? IISounds.assaultRifleRailgunShot : IISounds.assaultRifleShot;
    }

    @Override
    @Nullable
    protected SoundEvent getChargeFireSound(ItemStack weapon, EasyNBT nbt) {
        return IISounds.assaultRifleRailgunCharge;
    }

    @Override
    protected int getEnemyAttractRange(ItemStack weapon, EasyNBT nbt) {
        return IIConfigHandler.IIConfig.Weapons.AssaultRifle.enemyAttractRange;
    }

    @Override
    public int getAimingTime(ItemStack weapon, EasyNBT nbt) {
        return IIConfigHandler.IIConfig.Weapons.AssaultRifle.aimTime;
    }

    @Override
    public int getReloadTime(ItemStack weapon, ItemStack loaded, EasyNBT upgrades) {
        if (ItemNBTHelper.getInt((ItemStack)weapon, (String)FIRE_MODE) == 2) {
            return IIConfigHandler.IIConfig.Weapons.AssaultRifle.grenadeReloadTime;
        }
        return IIConfigHandler.IIConfig.Weapons.AssaultRifle.clipReloadTime;
    }

    @Override
    public float getHorizontalRecoil(ItemStack weapon, EasyNBT nbt, boolean isAimed) {
        return IIConfigHandler.IIConfig.Weapons.AssaultRifle.recoilHorizontal;
    }

    @Override
    public float getVerticalRecoil(ItemStack weapon, EasyNBT nbt, boolean isAimed) {
        return IIConfigHandler.IIConfig.Weapons.AssaultRifle.recoilVertical;
    }

    @Override
    public float getMaxHorizontalRecoil(ItemStack weapon, EasyNBT nbt) {
        return 10.0f;
    }

    @Override
    public float getMaxVerticalRecoil(ItemStack weapon, EasyNBT nbt) {
        return 10.0f;
    }

    @Override
    protected float getGunfireParticleSize(ItemStack weapon, EasyNBT nbt) {
        return 1.5f;
    }

    public void removeFromWorkbench(EntityPlayer player, ItemStack stack) {
        if (this.hasIIUpgrade(stack, (IIItemEnum)ItemIIWeaponUpgrade.WeaponUpgrades.ELECTRIC_FIRING_MOTOR) && this.hasIIUpgrade(stack, ItemIIWeaponUpgrade.WeaponUpgrades.SCOPE, ItemIIWeaponUpgrade.WeaponUpgrades.INFRARED_SCOPE)) {
            IIUtils.unlockIIAdvancement(player, "main/weapon_of_war");
        }
        if (this.hasIIUpgrades(stack, ItemIIWeaponUpgrade.WeaponUpgrades.RAILGUN_ASSISTED_CHAMBER, ItemIIWeaponUpgrade.WeaponUpgrades.RIFLE_GRENADE_LAUNCHER)) {
            IIUtils.unlockIIAdvancement(player, "main/the_accelerator");
        }
        if (this.hasIIUpgrade(stack, (IIItemEnum)ItemIIWeaponUpgrade.WeaponUpgrades.STEREOSCOPIC_RANGEFINDER)) {
            IIUtils.unlockIIAdvancement(player, "main/special_operations_initiative");
        }
    }

    @Override
    public void onScroll(ItemStack stack, boolean forward, EntityPlayerMP player) {
        int mode;
        int switched;
        if (ItemNBTHelper.getInt((ItemStack)stack, (String)"reloading") == 0 && ItemNBTHelper.getInt((ItemStack)stack, (String)FIRE_MODE_TIMER) == 0 && (switched = MathHelper.func_76125_a((int)((mode = ItemNBTHelper.getInt((ItemStack)stack, (String)FIRE_MODE)) + (forward ? 1 : -1)), (int)0, (int)(this.getUpgrades(stack).func_74764_b(ItemIIWeaponUpgrade.WeaponUpgrades.RIFLE_GRENADE_LAUNCHER.func_176610_l()) ? 2 : 1))) != mode) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)LAST_FIRE_MODE, (int)mode);
            ItemNBTHelper.setInt((ItemStack)stack, (String)FIRE_MODE, (int)switched);
            ItemNBTHelper.setInt((ItemStack)stack, (String)FIRE_MODE_TIMER, (int)6);
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, IISounds.assaultRifleModeChange, SoundCategory.PLAYERS, 0.25f, 1.0f);
        }
    }

    @Override
    public boolean shouldZoom(ItemStack stack, EntityPlayer player) {
        boolean isAimed = (double)ItemNBTHelper.getInt((ItemStack)stack, (String)"aiming") > (double)this.getAimingTime(stack, EasyNBT.wrapNBT(this.getUpgrades(stack))) * 0.75;
        return isAimed && this.isScoped(stack);
    }

    @Override
    public float getZoomProgress(ItemStack stack, EntityPlayer player) {
        int aiming = ItemNBTHelper.getInt((ItemStack)stack, (String)"aiming");
        int fullTime = this.getAimingTime(stack, EasyNBT.wrapNBT(this.getUpgrades(stack)));
        return MathHelper.func_76131_a((float)((float)aiming / (float)fullTime - 0.75f), (float)0.0f, (float)0.25f) / 0.25f;
    }

    @Override
    public float[] getZoomSteps(ItemStack stack, EntityPlayer player) {
        return new float[]{0.45f};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getZoomOverlayTexture(ItemStack stack, EntityPlayer player) {
        return this.hasIIUpgrade(stack, (IIItemEnum)ItemIIWeaponUpgrade.WeaponUpgrades.SCOPE) ? OVERLAY_SCOPE : OVERLAY_SCOPE_IR;
    }

    public boolean isScoped(ItemStack stack) {
        return this.hasIIUpgrade(stack, ItemIIWeaponUpgrade.WeaponUpgrades.SCOPE, ItemIIWeaponUpgrade.WeaponUpgrades.INFRARED_SCOPE);
    }

    private boolean isEnergyUpgraded(ItemStack stack) {
        return this.getUpgrades(stack).func_74764_b(ENERGY_UPGRADED);
    }

    public int getMaxEnergyStored(ItemStack stack) {
        return this.isEnergyUpgraded(stack) ? 4000 : 0;
    }
}

