/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.item.weapons;

import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import pl.pabilo8.immersiveintelligence.api.bullets.AmmoUtils;
import pl.pabilo8.immersiveintelligence.api.bullets.IAmmo;
import pl.pabilo8.immersiveintelligence.api.utils.ItemTooltipHandler;
import pl.pabilo8.immersiveintelligence.api.utils.tools.ISkinnable;
import pl.pabilo8.immersiveintelligence.client.ClientProxy;
import pl.pabilo8.immersiveintelligence.client.IIClientUtils;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIUpgradableItemRendererAMT;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.entity.bullet.EntityBullet;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ammohandler.AmmoHandler;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageItemKeybind;
import pl.pabilo8.immersiveintelligence.common.util.AdvancedSounds;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;
import pl.pabilo8.immersiveintelligence.common.util.item.ItemIIUpgradableTool;

public abstract class ItemIIGunBase
extends ItemIIUpgradableTool
implements ISkinnable,
ItemTooltipHandler.IAdvancedTooltipItem,
IOBJModelCallback<ItemStack> {
    public static final String RELOADING = "reloading";
    public static final String AIMING = "aiming";
    public static final String SHOULD_RELOAD = "shouldReload";
    public static final String RECOIL_H = "recoilH";
    public static final String RECOIL_V = "recoilV";
    public static final String FIRE_DELAY = "fireDelay";
    public static final String MAGAZINE = "magazine";
    public static final String BULLETS = "bullets";

    public ItemIIGunBase(String name) {
        super(name, 1, name.toUpperCase(), new String[0]);
        this.fixupItem();
    }

    public void fixupItem() {
        Item rItem = (Item)IEContent.registeredIEItems.remove(IEContent.registeredIEItems.size() - 1);
        if (rItem != this) {
            throw new IllegalStateException("fixupItem was not called at the appropriate time");
        }
        this.func_77655_b("immersiveintelligence." + this.itemName);
        this.func_77637_a(IIContent.II_CREATIVE_TAB);
        IIContent.ITEMS.add((Item)this);
    }

    public boolean canModify(ItemStack stack) {
        return this.getSlotCount(stack) > 0;
    }

    public Slot[] getWorkbenchSlots(Container container, ItemStack stack) {
        IItemHandler inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        String upgradeType = this.itemName.toUpperCase();
        ArrayList<IESlot.Upgrades> list = new ArrayList<IESlot.Upgrades>();
        for (int i = 0; i < this.getSlotCount(stack); ++i) {
            list.add(new IESlot.Upgrades(container, inv, i, 80 + i % 3 * 20, 32 + i / 3 * 20, upgradeType, stack, true));
        }
        return list.toArray(new Slot[0]);
    }

    @Nonnull
    public IRarity getForgeRarity(@Nonnull ItemStack stack) {
        IRarity skin = this.getSkinRarity(stack);
        return skin != null ? skin : super.getForgeRarity(stack);
    }

    @Override
    public String getSkinnableName() {
        return this.itemName;
    }

    @Override
    public String getSkinnableDefaultTextureLocation() {
        return "immersiveintelligence:textures/items/weapons/";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        this.getAmmoHandler(stack).addAmmoInformation(stack, world, tooltip, flag);
        this.addSkinTooltip(stack, tooltip);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addAdvancedInformation(ItemStack stack, int offsetX, List<Integer> offsetsY) {
        ItemTooltipHandler.drawItemList(offsetX, (int)offsetsY.get(0), this.getAmmoList(stack));
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public FontRenderer getFontRenderer(ItemStack stack) {
        return IIClientUtils.fontRegular;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EntityEquipmentSlot slot, @Nonnull ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot != EntityEquipmentSlot.MAINHAND) {
            return multimap;
        }
        multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", this.getEquipSpeed(stack, this.getNBT(stack)) * -3.0, 0));
        double melee = this.getUpgrades(stack).func_74760_g("melee");
        if (melee != 0.0) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", melee, 0));
        }
        return multimap;
    }

    @Nonnull
    public EnumAction func_77661_b(@Nonnull ItemStack stack) {
        return EnumAction.NONE;
    }

    public int func_77626_a(@Nonnull ItemStack stack) {
        return this.getFireDelay(stack, EasyNBT.wrapNBT(stack.func_77978_p())) + 1;
    }

    public void func_77663_a(ItemStack stack, World world, Entity user, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, world, user, itemSlot, isSelected);
        if (!(isSelected && user instanceof EntityLivingBase && ((EntityLivingBase)user).func_184582_a(EntityEquipmentSlot.MAINHAND).equals(stack))) {
            return;
        }
        EasyNBT nbt = this.getNBT(stack);
        EasyNBT upgrades = this.getUpgradesNBT(stack);
        AmmoHandler ammoHandler = this.getAmmoHandler(stack);
        int currentAim = nbt.getInt(AIMING);
        int fireDelay = nbt.getInt(FIRE_DELAY);
        float recoilH = nbt.getFloat(RECOIL_H);
        float recoilV = nbt.getFloat(RECOIL_V);
        int reloading = nbt.getInt(RELOADING);
        boolean shouldReload = nbt.getBoolean(SHOULD_RELOAD);
        boolean isAimed = currentAim > this.getAimingTime(stack, upgrades);
        float recoilDecay = this.getRecoilDecay(stack, nbt, isAimed);
        if (reloading == 0 && user.func_70093_af()) {
            currentAim = MathHelper.func_76125_a((int)(currentAim + 1), (int)0, (int)this.getAimingTime(stack, upgrades));
        } else if (currentAim > 0) {
            currentAim = MathHelper.func_76125_a((int)(currentAim - 3), (int)0, (int)this.getAimingTime(stack, upgrades));
        }
        if (fireDelay > 0) {
            --fireDelay;
        }
        recoilH = Math.max(recoilH - recoilDecay, 0.0f);
        recoilV = Math.max(recoilV - recoilDecay, 0.0f);
        if (world.field_72995_K && !shouldReload && ClientProxy.keybind_manualReload.func_151470_d()) {
            IIPacketHandler.sendToServer(new MessageItemKeybind(0));
        }
        if (shouldReload) {
            if ((reloading = ammoHandler.reloadWeapon(stack, world, user, nbt, upgrades, reloading)) == 0) {
                shouldReload = false;
            }
        } else {
            reloading = 0;
        }
        nbt.withInt(RELOADING, reloading);
        nbt.withInt(AIMING, currentAim);
        nbt.withBoolean(SHOULD_RELOAD, shouldReload);
        nbt.withFloat(RECOIL_H, recoilH);
        nbt.withFloat(RECOIL_V, recoilV);
        nbt.withInt(FIRE_DELAY, fireDelay);
    }

    public void onUsingTick(@Nonnull ItemStack stack, EntityLivingBase user, int count) {
        switch (this.getFireMode(stack)) {
            case SINGULAR: {
                if (user instanceof EntityPlayer) break;
                this.shoot(stack, user, count);
                break;
            }
            case AUTOMATIC: {
                this.shoot(stack, user, count);
                break;
            }
            case SINGULAR_CHARGED: {
                EasyNBT nbt = this.getNBT(stack);
                if (!this.getAmmoHandler(stack).canFire(stack, nbt)) break;
                if (count == this.func_77626_a(stack)) {
                    nbt.withInt(FIRE_DELAY, this.getFireDelay(stack, nbt));
                    SoundEvent sound = this.getChargeFireSound(stack, nbt);
                    if (sound != null) {
                        user.field_70170_p.func_184148_a(null, user.field_70165_t, user.field_70163_u, user.field_70161_v, sound, SoundCategory.PLAYERS, 0.5f, 0.9f);
                    }
                }
                this.shoot(stack, user, count);
                break;
            }
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack weapon = player.func_184586_b(hand);
        AmmoHandler ammoHandler = this.getAmmoHandler(weapon);
        if (hand == EnumHand.MAIN_HAND) {
            player.func_184598_c(hand);
            if (this.getFireMode(weapon) == FireModeType.SINGULAR) {
                this.shoot(weapon, (EntityLivingBase)player, 1);
                return new ActionResult(EnumActionResult.FAIL, (Object)weapon);
            }
            if (ammoHandler.canFire(weapon, this.getNBT(weapon))) {
                return new ActionResult(EnumActionResult.FAIL, (Object)weapon);
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)weapon);
    }

    protected void shoot(@Nonnull ItemStack weapon, EntityLivingBase user, int count) {
        World world = user.func_130014_f_();
        EasyNBT nbt = this.getNBT(weapon);
        EasyNBT upgrades = this.getUpgradesNBT(weapon);
        AmmoHandler ammoHandler = this.getAmmoHandler(weapon);
        if (!ammoHandler.canFire(weapon, nbt)) {
            SoundEvent sound = this.getDryfireSound(weapon, upgrades);
            if (sound != null && count == 1) {
                world.func_184148_a(null, user.field_70165_t, user.field_70163_u, user.field_70161_v, sound, SoundCategory.PLAYERS, 0.25f, 0.9f);
            }
            return;
        }
        if (nbt.getInt(FIRE_DELAY) == 0) {
            nbt.withInt(FIRE_DELAY, this.getFireDelay(weapon, nbt));
            if (!world.field_72995_K) {
                AdvancedSounds.RangedSound sound;
                boolean isAimed = nbt.getInt(AIMING) > this.getAimingTime(weapon, upgrades);
                float recoilH = nbt.getFloat(RECOIL_H);
                float recoilHAdded = this.getHorizontalRecoil(weapon, upgrades, isAimed);
                float recoilV = nbt.getFloat(RECOIL_V);
                float recoilVAdded = this.getVerticalRecoil(weapon, upgrades, isAimed);
                Vec3d vec = IIUtils.getVectorForRotation(user.field_70125_A + this.getActualRecoil(recoilV, recoilVAdded), user.func_70079_am() + this.getActualRecoil(recoilH, recoilHAdded));
                Vec3d vv = user.func_174791_d().func_72441_c(0.0, (double)user.func_70047_e() - (double)0.1f, 0.0);
                ItemStack ammo = ammoHandler.getNextAmmo(weapon, nbt, true);
                this.createProjectile(user, world, vec, vv, weapon, nbt, ammo);
                int enemyAttractRange = this.getEnemyAttractRange(weapon, upgrades);
                if (enemyAttractRange > 0) {
                    Utils.attractEnemies((EntityLivingBase)user, (float)enemyAttractRange);
                }
                if ((sound = this.getFireSound(weapon, upgrades)) != null) {
                    IIPacketHandler.playRangedSound(world, user.func_174791_d().func_178787_e(vec), sound, SoundCategory.PLAYERS, 75, 1.5f, 1.0f + (float)(Utils.RAND.nextGaussian() * 0.02));
                }
                nbt.withFloat(RECOIL_H, MathHelper.func_76131_a((float)(recoilH + this.getHorizontalRecoil(weapon, upgrades, isAimed)), (float)0.0f, (float)this.getMaxHorizontalRecoil(weapon, upgrades)));
                nbt.withFloat(RECOIL_V, MathHelper.func_76131_a((float)(recoilV + this.getVerticalRecoil(weapon, upgrades, isAimed)), (float)0.0f, (float)this.getMaxVerticalRecoil(weapon, upgrades)));
                ItemStack cc = this.getCasingStack(ammo);
                IIUtils.giveOrDropCasingStack((Entity)user, cc);
            }
        }
    }

    public ItemStack findAmmo(Entity entity, ItemStack weapon) {
        if (!(entity instanceof EntityLivingBase)) {
            return ItemStack.field_190927_a;
        }
        if (entity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler capability = (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            if (capability == null) {
                return ItemStack.field_190927_a;
            }
            AmmoHandler handler = this.getAmmoHandler(weapon);
            for (int i = 0; i < capability.getSlots(); ++i) {
                ItemStack ammo = capability.getStackInSlot(i);
                if (ammo.func_190926_b() || !handler.isValidAmmo(weapon, ammo)) continue;
                return ammo;
            }
        }
        return ItemStack.field_190927_a;
    }

    protected void createProjectile(EntityLivingBase user, World world, Vec3d dir, Vec3d pos, ItemStack weapon, EasyNBT nbt, ItemStack ammo) {
        EntityBullet a = AmmoUtils.createBullet(world, ammo, pos, dir, this.getVelocityModifier(weapon, nbt, ammo));
        a.setShooters((Entity)user, new Entity[0]);
        world.func_72838_d((Entity)a);
    }

    public abstract AmmoHandler getAmmoHandler(ItemStack var1);

    protected abstract FireModeType getFireMode(ItemStack var1);

    protected double getAttackDamage(ItemStack weapon) {
        return 0.0;
    }

    protected abstract double getEquipSpeed(ItemStack var1, EasyNBT var2);

    public abstract int getFireDelay(ItemStack var1, EasyNBT var2);

    protected abstract int getEnemyAttractRange(ItemStack var1, EasyNBT var2);

    public abstract int getAimingTime(ItemStack var1, EasyNBT var2);

    public abstract int getReloadTime(ItemStack var1, ItemStack var2, EasyNBT var3);

    public float getRecoilDecay(ItemStack weapon, EasyNBT nbt, boolean isAimed) {
        return isAimed ? 0.2f : 0.125f;
    }

    public abstract float getHorizontalRecoil(ItemStack var1, EasyNBT var2, boolean var3);

    public abstract float getVerticalRecoil(ItemStack var1, EasyNBT var2, boolean var3);

    public abstract float getMaxHorizontalRecoil(ItemStack var1, EasyNBT var2);

    public abstract float getMaxVerticalRecoil(ItemStack var1, EasyNBT var2);

    protected abstract float getGunfireParticleSize(ItemStack var1, EasyNBT var2);

    protected ItemStack getCasingStack(ItemStack ammo) {
        return ((IAmmo)ammo.func_77973_b()).getCasingStack(1);
    }

    protected float getVelocityModifier(ItemStack weapon, EasyNBT nbt, ItemStack ammo) {
        return 1.0f;
    }

    @Nullable
    protected abstract SoundEvent getDryfireSound(ItemStack var1, EasyNBT var2);

    @Nullable
    protected abstract AdvancedSounds.RangedSound getFireSound(ItemStack var1, EasyNBT var2);

    @Nullable
    protected SoundEvent getChargeFireSound(ItemStack weapon, EasyNBT nbt) {
        return null;
    }

    private EasyNBT getNBT(ItemStack weapon) {
        return EasyNBT.wrapNBT(ItemNBTHelper.getTag((ItemStack)weapon));
    }

    private EasyNBT getUpgradesNBT(ItemStack weapon) {
        return EasyNBT.wrapNBT(this.getUpgrades(weapon));
    }

    public final boolean isAmmo(ItemStack ammo, ItemStack weapon) {
        return this.getAmmoHandler(weapon).isValidAmmo(weapon, ammo);
    }

    public boolean isAimed(ItemStack weapon) {
        return ItemNBTHelper.getInt((ItemStack)weapon, (String)AIMING) == this.getAimingTime(weapon, EasyNBT.wrapNBT(this.getUpgrades(weapon)));
    }

    public float getActualRecoil(float current, float added) {
        return current * MathHelper.func_76126_a((float)(current / added));
    }

    public NBTTagList getAmmoList(ItemStack stack) {
        return this.getAmmoHandler(stack).getAmmoList(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public IIUpgradableItemRendererAMT<?> getItemRenderer() {
        return (IIUpgradableItemRendererAMT)this.getTileEntityItemStackRenderer();
    }

    public static enum FireModeType {
        AUTOMATIC,
        SINGULAR,
        SINGULAR_CHARGED;

    }
}

