/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.item.weapons;

import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.utils.tools.IAdvancedZoomTool;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IISounds;
import pl.pabilo8.immersiveintelligence.common.item.ammo.ItemIIBulletMagazine;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ItemIIGunBase;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ItemIIWeaponUpgrade;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ammohandler.AmmoHandler;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ammohandler.AmmoHandlerList;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ammohandler.AmmoHandlerMagazine;
import pl.pabilo8.immersiveintelligence.common.util.AdvancedSounds;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;
import pl.pabilo8.immersiveintelligence.common.util.item.IIItemEnum;

public class ItemIIRifle
extends ItemIIGunBase
implements IAdvancedZoomTool {
    public static final String HANDMADE = "handmade";
    public static final ResourceLocation OVERLAY_SCOPE = new ResourceLocation("immersiveintelligence", "textures/gui/item/machinegun/scope.png");
    public static final int MAG_SIZE = IIConfigHandler.IIConfig.Weapons.Rifle.clipSize;
    private final AmmoHandlerList ammoHandler = new AmmoHandlerList(this, "bullets", IIContent.itemAmmoMachinegun, MAG_SIZE){

        @Override
        @Nullable
        protected SoundEvent getStartLoadingSound(ItemStack weapon, EasyNBT nbt) {
            return IISounds.rifleLoadStart;
        }

        @Override
        @Nullable
        protected SoundEvent getReloadSound(ItemStack weapon, EasyNBT nbt) {
            return IISounds.rifleLoad;
        }

        @Override
        @Nullable
        protected SoundEvent getFinishLoadingSound(ItemStack weapon, EasyNBT nbt) {
            return IISounds.rifleLoadEnd;
        }
    };
    private final AmmoHandlerMagazine ammoHandlerSemiAuto = new AmmoHandlerMagazine(this, "magazine", IIContent.itemAmmoMachinegun){

        @Override
        protected boolean isValidType(ItemStack weapon, ItemIIBulletMagazine.Magazines magazine) {
            return magazine == ItemIIBulletMagazine.Magazines.RIFLE;
        }

        @Override
        @Nullable
        protected SoundEvent getUnloadSound(ItemStack weapon, EasyNBT nbt) {
            return IISounds.rifleUnloadMagazine;
        }

        @Override
        @Nullable
        protected SoundEvent getReloadSound(ItemStack weapon, EasyNBT nbt) {
            return IISounds.rifleReloadMagazine;
        }
    };

    public ItemIIRifle() {
        super("rifle");
    }

    public int getSlotCount(ItemStack stack) {
        return 2;
    }

    public void removeFromWorkbench(EntityPlayer player, ItemStack stack) {
    }

    @Override
    public AmmoHandler getAmmoHandler(ItemStack weapon) {
        return this.hasIIUpgrade(weapon, (IIItemEnum)ItemIIWeaponUpgrade.WeaponUpgrades.SEMI_AUTOMATIC) ? this.ammoHandlerSemiAuto : this.ammoHandler;
    }

    @Override
    protected ItemIIGunBase.FireModeType getFireMode(ItemStack weapon) {
        return this.hasIIUpgrade(weapon, (IIItemEnum)ItemIIWeaponUpgrade.WeaponUpgrades.SEMI_AUTOMATIC) ? ItemIIGunBase.FireModeType.AUTOMATIC : ItemIIGunBase.FireModeType.SINGULAR;
    }

    @Override
    protected double getEquipSpeed(ItemStack weapon, EasyNBT nbt) {
        return this.hasIIUpgrade(weapon, ItemIIWeaponUpgrade.WeaponUpgrades.EXTENDED_BARREL, ItemIIWeaponUpgrade.WeaponUpgrades.SEMI_AUTOMATIC) ? 1.0625 : 0.9;
    }

    @Override
    public int getFireDelay(ItemStack weapon, EasyNBT nbt) {
        return this.hasIIUpgrade(weapon, (IIItemEnum)ItemIIWeaponUpgrade.WeaponUpgrades.SEMI_AUTOMATIC) ? IIConfigHandler.IIConfig.Weapons.Rifle.bulletFireTimeSemiAuto : IIConfigHandler.IIConfig.Weapons.Rifle.bulletFireTime;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            list.add((Object)new ItemStack((Item)this, 1));
            ItemStack handmade = new ItemStack((Item)this, 1, 0);
            handmade.func_77982_d(EasyNBT.newNBT().withBoolean(HANDMADE, true).unwrap());
            list.add((Object)handmade);
        }
    }

    public String func_77667_c(ItemStack stack) {
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)HANDMADE)) {
            return "item.immersiveintelligence.rifle_handmade";
        }
        return super.func_77667_c(stack);
    }

    @Override
    @Nullable
    protected SoundEvent getDryfireSound(ItemStack weapon, EasyNBT easyNBT) {
        return IISounds.rifleShotDry;
    }

    @Override
    @Nullable
    protected AdvancedSounds.RangedSound getFireSound(ItemStack weapon, EasyNBT easyNBT) {
        return IISounds.rifleShot;
    }

    @Override
    protected int getEnemyAttractRange(ItemStack weapon, EasyNBT nbt) {
        return IIConfigHandler.IIConfig.Weapons.Rifle.enemyAttractRange;
    }

    @Override
    public int getAimingTime(ItemStack weapon, EasyNBT nbt) {
        return IIConfigHandler.IIConfig.Weapons.Rifle.aimTime;
    }

    @Override
    public int getReloadTime(ItemStack weapon, ItemStack loaded, EasyNBT nbt) {
        return this.hasIIUpgrades(weapon, ItemIIWeaponUpgrade.WeaponUpgrades.SEMI_AUTOMATIC) ? IIConfigHandler.IIConfig.Weapons.Rifle.magazineReloadTime : IIConfigHandler.IIConfig.Weapons.Rifle.bulletReloadTime;
    }

    @Override
    public float getHorizontalRecoil(ItemStack weapon, EasyNBT nbt, boolean isAimed) {
        return (isAimed ? 0.5f : 1.0f) * IIConfigHandler.IIConfig.Weapons.Rifle.recoilHorizontal;
    }

    @Override
    public float getVerticalRecoil(ItemStack weapon, EasyNBT nbt, boolean isAimed) {
        if (nbt.hasKey(ItemIIWeaponUpgrade.WeaponUpgrades.SEMI_AUTOMATIC)) {
            return (isAimed ? 0.75f : 1.0f) * 1.55f;
        }
        return (isAimed ? 0.5f : 1.0f) * IIConfigHandler.IIConfig.Weapons.Rifle.recoilVertical;
    }

    @Override
    public float getMaxHorizontalRecoil(ItemStack weapon, EasyNBT nbt) {
        return IIConfigHandler.IIConfig.Weapons.Rifle.maxRecoilHorizontal;
    }

    @Override
    public float getMaxVerticalRecoil(ItemStack weapon, EasyNBT nbt) {
        return IIConfigHandler.IIConfig.Weapons.Rifle.maxRecoilVertical;
    }

    @Override
    protected float getGunfireParticleSize(ItemStack weapon, EasyNBT nbt) {
        return 1.5f;
    }

    @Override
    protected float getVelocityModifier(ItemStack weapon, EasyNBT nbt, ItemStack ammo) {
        if (nbt.hasKey(ItemIIWeaponUpgrade.WeaponUpgrades.EXTENDED_BARREL)) {
            return IIConfigHandler.IIConfig.Weapons.Rifle.longBarrelVelocityMod;
        }
        if (nbt.hasKey(ItemIIWeaponUpgrade.WeaponUpgrades.SEMI_AUTOMATIC)) {
            return 0.75f;
        }
        return 1.0f;
    }

    @Override
    public boolean shouldZoom(ItemStack stack, EntityPlayer player) {
        boolean isAimed = (double)ItemNBTHelper.getInt((ItemStack)stack, (String)"aiming") > (double)this.getAimingTime(stack, EasyNBT.wrapNBT(this.getUpgrades(stack))) * 0.75;
        return isAimed && this.hasIIUpgrade(stack, (IIItemEnum)ItemIIWeaponUpgrade.WeaponUpgrades.SCOPE);
    }

    @Override
    public float getZoomProgress(ItemStack stack, EntityPlayer player) {
        int aiming = ItemNBTHelper.getInt((ItemStack)stack, (String)"aiming");
        int fullTime = this.getAimingTime(stack, EasyNBT.wrapNBT(this.getUpgrades(stack)));
        return MathHelper.func_76131_a((float)((float)aiming / (float)fullTime - 0.75f), (float)0.0f, (float)0.25f) / 0.25f;
    }

    @Override
    public float[] getZoomSteps(ItemStack stack, EntityPlayer player) {
        return new float[]{0.125f, 0.25f};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getZoomOverlayTexture(ItemStack stack, EntityPlayer player) {
        return OVERLAY_SCOPE;
    }
}

