/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.item.weapons;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IISounds;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.item.ammo.ItemIIBulletMagazine;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ItemIIGunBase;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ItemIIWeaponUpgrade;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ammohandler.AmmoHandler;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ammohandler.AmmoHandlerMagazine;
import pl.pabilo8.immersiveintelligence.common.util.AdvancedSounds;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;
import pl.pabilo8.immersiveintelligence.common.util.item.IIItemEnum;

public class ItemIISubmachinegun
extends ItemIIGunBase {
    private final AmmoHandlerMagazine ammoHandler = new AmmoHandlerMagazine(this, "magazine", IIContent.itemAmmoSubmachinegun){

        @Override
        protected boolean isValidType(ItemStack weapon, ItemIIBulletMagazine.Magazines magazine) {
            return magazine != ItemIIBulletMagazine.Magazines.SUBMACHINEGUN_DRUM || ItemIISubmachinegun.this.hasIIUpgrade(weapon, (IIItemEnum)ItemIIWeaponUpgrade.WeaponUpgrades.BOTTOM_LOADING);
        }

        @Override
        public void markLoadedAmmo(EasyNBT nbt, ItemStack ammo) {
            if (IIContent.itemBulletMagazine.stackToSub(ammo) == ItemIIBulletMagazine.Magazines.SUBMACHINEGUN_DRUM) {
                nbt.withBoolean("isDrum", true);
            } else {
                nbt.without("isDrum");
            }
        }

        @Override
        @Nullable
        protected SoundEvent getUnloadSound(ItemStack weapon, EasyNBT nbt) {
            return IISounds.submachinegunUnload;
        }

        @Override
        @Nullable
        protected SoundEvent getReloadSound(ItemStack weapon, EasyNBT nbt) {
            return IISounds.submachinegunReload;
        }
    };

    public ItemIISubmachinegun() {
        super("submachinegun");
    }

    public int getSlotCount(ItemStack stack) {
        return 3;
    }

    public void removeFromWorkbench(EntityPlayer player, ItemStack stack) {
        if (this.hasIIUpgrade(stack, ItemIIWeaponUpgrade.WeaponUpgrades.STURDY_BARREL, ItemIIWeaponUpgrade.WeaponUpgrades.BOTTOM_LOADING)) {
            IIUtils.unlockIIAdvancement(player, "main/infinite_power");
        }
        if (this.hasIIUpgrades(stack, ItemIIWeaponUpgrade.WeaponUpgrades.SUPPRESSOR, ItemIIWeaponUpgrade.WeaponUpgrades.FOLDING_STOCK)) {
            IIUtils.unlockIIAdvancement(player, "main/the_silent_unseen");
        }
    }

    @Override
    public AmmoHandler getAmmoHandler(ItemStack weapon) {
        return this.ammoHandler;
    }

    @Override
    protected ItemIIGunBase.FireModeType getFireMode(ItemStack weapon) {
        return ItemIIGunBase.FireModeType.AUTOMATIC;
    }

    @Override
    protected double getEquipSpeed(ItemStack weapon, EasyNBT nbt) {
        return nbt.hasKey(ItemIIWeaponUpgrade.WeaponUpgrades.FOLDING_STOCK) ? 0.35 : 0.65;
    }

    @Override
    public int getFireDelay(ItemStack weapon, EasyNBT nbt) {
        return IIConfigHandler.IIConfig.Weapons.Submachinegun.bulletFireTime;
    }

    @Override
    @Nullable
    protected SoundEvent getDryfireSound(ItemStack weapon, EasyNBT easyNBT) {
        return IISounds.submachinegunShotDry;
    }

    @Override
    @Nullable
    protected AdvancedSounds.RangedSound getFireSound(ItemStack weapon, EasyNBT easyNBT) {
        return IISounds.submachinegunShot;
    }

    @Override
    protected int getEnemyAttractRange(ItemStack weapon, EasyNBT nbt) {
        return nbt.hasKey(ItemIIWeaponUpgrade.WeaponUpgrades.SUPPRESSOR) ? IIConfigHandler.IIConfig.Weapons.Submachinegun.enemyAttractRangeSuppressor : IIConfigHandler.IIConfig.Weapons.Submachinegun.enemyAttractRange;
    }

    @Override
    public int getAimingTime(ItemStack weapon, EasyNBT nbt) {
        return nbt.hasKey(ItemIIWeaponUpgrade.WeaponUpgrades.FOLDING_STOCK) ? IIConfigHandler.IIConfig.Weapons.Submachinegun.aimTimeFoldedStock : IIConfigHandler.IIConfig.Weapons.Submachinegun.aimTime;
    }

    @Override
    public int getReloadTime(ItemStack weapon, ItemStack loaded, EasyNBT nbt) {
        if (IIContent.itemBulletMagazine.stackToSub(weapon) == ItemIIBulletMagazine.Magazines.SUBMACHINEGUN_DRUM) {
            return IIConfigHandler.IIConfig.Weapons.Submachinegun.drumReloadTime;
        }
        return IIConfigHandler.IIConfig.Weapons.Submachinegun.clipReloadTime;
    }

    @Override
    public float getHorizontalRecoil(ItemStack weapon, EasyNBT nbt, boolean isAimed) {
        return IIConfigHandler.IIConfig.Weapons.Submachinegun.newRecoilHorizontal;
    }

    @Override
    public float getVerticalRecoil(ItemStack weapon, EasyNBT nbt, boolean isAimed) {
        return IIConfigHandler.IIConfig.Weapons.Submachinegun.newRecoilVertical;
    }

    @Override
    public float getMaxHorizontalRecoil(ItemStack weapon, EasyNBT nbt) {
        return IIConfigHandler.IIConfig.Weapons.Submachinegun.newMaxRecoilHorizontal;
    }

    @Override
    public float getMaxVerticalRecoil(ItemStack weapon, EasyNBT nbt) {
        return IIConfigHandler.IIConfig.Weapons.Submachinegun.newMaxRecoilVertical;
    }

    @Override
    protected float getGunfireParticleSize(ItemStack weapon, EasyNBT nbt) {
        return nbt.hasKey(ItemIIWeaponUpgrade.WeaponUpgrades.SUPPRESSOR) ? 0.5f : 1.5f;
    }

    @Override
    protected float getVelocityModifier(ItemStack weapon, EasyNBT nbt, ItemStack ammo) {
        return nbt.hasKey(ItemIIWeaponUpgrade.WeaponUpgrades.STURDY_BARREL) ? IIConfigHandler.IIConfig.Weapons.Submachinegun.sturdyBarrelVelocityMod : 1.0f;
    }
}

