/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.item.weapons;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.tool.IUpgrade;
import blusunrize.immersiveengineering.api.tool.IUpgradeableTool;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.client.render.MachinegunRenderer;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIUpgradableItemRendererAMT;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ItemIIGunBase;
import pl.pabilo8.immersiveintelligence.common.util.ISerializableEnum;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;
import pl.pabilo8.immersiveintelligence.common.util.item.IIItemEnum;
import pl.pabilo8.immersiveintelligence.common.util.item.ItemIISubItemsBase;

public class ItemIIWeaponUpgrade
extends ItemIISubItemsBase<WeaponUpgrades>
implements IUpgrade {
    public ItemIIWeaponUpgrade() {
        super("weapon_upgrade", 1, (Enum[])WeaponUpgrades.values());
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<String> list, @Nonnull ITooltipFlag flag) {
        WeaponUpgrades sub = (WeaponUpgrades)this.stackToSub(stack);
        for (WeaponTypes type : sub.toolset) {
            list.add(IIUtils.getHexCol(type.color, type.symbol + " " + I18n.func_135052_a((String)("desc.immersiveintelligence.toolupgrade.item." + type.func_176610_l()), (Object[])new Object[0])));
        }
        String[] flavour = ImmersiveEngineering.proxy.splitStringOnWidth(I18n.func_135052_a((String)("desc.immersiveintelligence.toolupgrade." + sub.func_176610_l()), (Object[])new Object[0]), 200);
        Arrays.stream(flavour).map(IIUtils::getItalicString).forEach(list::add);
    }

    public Set<String> getUpgradeTypes(ItemStack stack) {
        return ((WeaponUpgrades)this.stackToSub((ItemStack)stack)).toolset.stream().map(ISerializableEnum::func_176610_l).map(String::toUpperCase).collect(Collectors.toSet());
    }

    public boolean canApplyUpgrades(ItemStack target, ItemStack upgrade) {
        if (target.func_77973_b() instanceof IUpgradeableTool) {
            return ((WeaponUpgrades)this.stackToSub(upgrade)).applyCheck.test(target, upgrade);
        }
        return false;
    }

    public void applyUpgrades(ItemStack target, ItemStack upgrade, NBTTagCompound modifications) {
        ((WeaponUpgrades)this.stackToSub(upgrade)).function.accept(upgrade, modifications);
    }

    private static Predicate<EasyNBT> hasUpgrade(@Nonnull WeaponUpgrades upgrade) {
        return easyNBT -> easyNBT.hasKey(upgrade.func_176610_l());
    }

    @SideOnly(value=Side.CLIENT)
    public static void addUpgradesToRender() {
        MachinegunRenderer.upgrades.put(stack -> IIContent.itemMachinegun.getUpgrades((ItemStack)stack).func_74767_n("water_cooling"), (stack, tmtNamedBoxGroups) -> {
            tmtNamedBoxGroups.remove(MachinegunRenderer.model.barrelBox);
            tmtNamedBoxGroups.add(MachinegunRenderer.model.waterCoolingBox);
        });
        MachinegunRenderer.upgrades.put(stack -> IIContent.itemMachinegun.getUpgrades((ItemStack)stack).func_74767_n("heavy_barrel"), (stack, tmtNamedBoxGroups) -> {
            tmtNamedBoxGroups.remove(MachinegunRenderer.model.barrelBox);
            tmtNamedBoxGroups.add(MachinegunRenderer.model.heavyBarrelBox);
        });
        MachinegunRenderer.upgrades.put(stack -> IIContent.itemMachinegun.getUpgrades((ItemStack)stack).func_74767_n("second_magazine"), (stack, tmtNamedBoxGroups) -> {
            tmtNamedBoxGroups.add(MachinegunRenderer.model.secondMagazineMainBox);
            tmtNamedBoxGroups.add(MachinegunRenderer.model.secondMagazineMagBox);
        });
        MachinegunRenderer.upgrades.put(stack -> IIContent.itemMachinegun.getUpgrades((ItemStack)stack).func_74767_n("belt_fed_loader"), (stack, tmtNamedBoxGroups) -> {
            tmtNamedBoxGroups.remove(MachinegunRenderer.model.ammoBox);
            tmtNamedBoxGroups.add(MachinegunRenderer.model.beltFedLoaderBox);
        });
        MachinegunRenderer.upgrades.put(stack -> IIContent.itemMachinegun.getUpgrades((ItemStack)stack).func_74767_n("scope"), (stack, tmtNamedBoxGroups) -> tmtNamedBoxGroups.add(MachinegunRenderer.model.scopeBox));
        MachinegunRenderer.upgrades.put(stack -> IIContent.itemMachinegun.getUpgrades((ItemStack)stack).func_74767_n("infrared_scope"), (stack, tmtNamedBoxGroups) -> tmtNamedBoxGroups.add(MachinegunRenderer.model.infraredScopeBox));
        MachinegunRenderer.upgrades.put(stack -> IIContent.itemMachinegun.getUpgrades((ItemStack)stack).func_74767_n("hasty_bipod"), (stack, tmtNamedBoxGroups) -> {
            tmtNamedBoxGroups.remove(MachinegunRenderer.model.bipodBox);
            tmtNamedBoxGroups.add(MachinegunRenderer.model.hastyBipodBox);
        });
        MachinegunRenderer.upgrades.put(stack -> IIContent.itemMachinegun.getUpgrades((ItemStack)stack).func_74767_n("precise_bipod"), (stack, tmtNamedBoxGroups) -> {
            tmtNamedBoxGroups.remove(MachinegunRenderer.model.bipodBox);
            tmtNamedBoxGroups.add(MachinegunRenderer.model.preciseBipodBox);
        });
        MachinegunRenderer.upgrades.put(stack -> IIContent.itemMachinegun.getUpgrades((ItemStack)stack).func_74767_n("tripod"), (stack, tmtNamedBoxGroups) -> {
            tmtNamedBoxGroups.remove(MachinegunRenderer.model.bipodBox);
            tmtNamedBoxGroups.add(MachinegunRenderer.model.tripodBox);
        });
        MachinegunRenderer.upgrades.put(stack -> IIContent.itemMachinegun.getUpgrades((ItemStack)stack).func_74767_n("shield"), (stack, tmtNamedBoxGroups) -> tmtNamedBoxGroups.add(MachinegunRenderer.model.shieldBox));
        IIUpgradableItemRendererAMT<?> smg = IIContent.itemSubmachinegun.getItemRenderer();
        smg.addUpgradePart(ItemIIWeaponUpgrade.hasUpgrade(WeaponUpgrades.STURDY_BARREL), "sturdy_barrel");
        smg.addUpgradePart(ItemIIWeaponUpgrade.hasUpgrade(WeaponUpgrades.SUPPRESSOR), "suppressor");
        smg.addUpgradePart(ItemIIWeaponUpgrade.hasUpgrade(WeaponUpgrades.BOTTOM_LOADING), "bottom_loading");
        smg.addUpgradePart(ItemIIWeaponUpgrade.hasUpgrade(WeaponUpgrades.FOLDING_STOCK), "folding_stock");
        smg.addUpgradePart(easyNBT -> easyNBT.hasKey("melee"), "bayonet");
        IIUpgradableItemRendererAMT<?> stg = IIContent.itemAssaultRifle.getItemRenderer();
        stg.addUpgradePart(ItemIIWeaponUpgrade.hasUpgrade(WeaponUpgrades.SCOPE), "scope");
        stg.addUpgradePart(ItemIIWeaponUpgrade.hasUpgrade(WeaponUpgrades.INFRARED_SCOPE), "infrared_scope");
        stg.addUpgradePart(ItemIIWeaponUpgrade.hasUpgrade(WeaponUpgrades.STEREOSCOPIC_RANGEFINDER), "rangefinder");
        stg.addUpgradePart(ItemIIWeaponUpgrade.hasUpgrade(WeaponUpgrades.RAILGUN_ASSISTED_CHAMBER), "railgun");
        stg.addUpgradePart(ItemIIWeaponUpgrade.hasUpgrade(WeaponUpgrades.RIFLE_GRENADE_LAUNCHER), "grenade_launcher");
        stg.addUpgradePart(ItemIIWeaponUpgrade.hasUpgrade(WeaponUpgrades.ELECTRIC_FIRING_MOTOR), "electric_motor");
        stg.addUpgradePart(ItemIIWeaponUpgrade.hasUpgrade(WeaponUpgrades.GYROSCOPIC_STABILIZER), "stabilizer");
        IIUpgradableItemRendererAMT<?> rifle = IIContent.itemRifle.getItemRenderer();
        rifle.addUpgradePart(ItemIIWeaponUpgrade.hasUpgrade(WeaponUpgrades.SCOPE), "scope");
        rifle.addUpgradePart(easyNBT -> easyNBT.hasKey("melee"), "bayonet");
        rifle.addUpgradePart(ItemIIWeaponUpgrade.hasUpgrade(WeaponUpgrades.EXTENDED_BARREL), "extended_barrel");
        rifle.addUpgradePart(ItemIIWeaponUpgrade.hasUpgrade(WeaponUpgrades.SEMI_AUTOMATIC), "semi_automatic");
    }

    public static enum WeaponUpgrades implements IIItemEnum
    {
        HEAVY_BARREL(WeaponTypes.MACHINEGUN, "water_cooling"),
        WATER_COOLING(WeaponTypes.MACHINEGUN, "heavy_barrel"),
        BELT_FED_LOADER(WeaponTypes.MACHINEGUN, "second_magazine"),
        SECOND_MAGAZINE(WeaponTypes.MACHINEGUN, "belt_fed_loader"),
        HASTY_BIPOD(WeaponTypes.MACHINEGUN, "precise_bipod", "tripod"),
        PRECISE_BIPOD(WeaponTypes.MACHINEGUN, "hasty_bipod", "tripod"),
        SCOPE(new WeaponTypes[]{WeaponTypes.MACHINEGUN, WeaponTypes.AUTOREVOLVER, WeaponTypes.ASSAULT_RIFLE, WeaponTypes.RIFLE}, "infrared_scope"),
        INFRARED_SCOPE(new WeaponTypes[]{WeaponTypes.MACHINEGUN, WeaponTypes.ASSAULT_RIFLE}, (stack, nbt) -> {
            if (stack.func_77973_b() instanceof ItemIIGunBase) {
                nbt.func_74757_a("energy", true);
            }
        }, "scope"),
        SHIELD(WeaponTypes.MACHINEGUN, new String[0]),
        TRIPOD(WeaponTypes.MACHINEGUN, "hasty_bipod", "precise_bipod"),
        STURDY_BARREL(WeaponTypes.SUBMACHINEGUN, new String[0]),
        SUPPRESSOR(WeaponTypes.SUBMACHINEGUN, new String[0]),
        BOTTOM_LOADING(WeaponTypes.SUBMACHINEGUN, new String[0]),
        FOLDING_STOCK(WeaponTypes.SUBMACHINEGUN, new String[0]),
        RIFLE_GRENADE_LAUNCHER(WeaponTypes.ASSAULT_RIFLE, (stack, nbt) -> nbt.func_74757_a("energy", true), "stereoscopic_rangefinder"),
        STEREOSCOPIC_RANGEFINDER(WeaponTypes.ASSAULT_RIFLE, (stack, nbt) -> nbt.func_74757_a("energy", true), "rifle_grenade_launcher"),
        GYROSCOPIC_STABILIZER(WeaponTypes.ASSAULT_RIFLE, (stack, nbt) -> nbt.func_74757_a("energy", true), "electric_firing_motor", "railgun_assisted_chamber"),
        ELECTRIC_FIRING_MOTOR(WeaponTypes.ASSAULT_RIFLE, (stack, nbt) -> nbt.func_74757_a("energy", true), "gyroscopic_stabilizer", "railgun_assisted_chamber"),
        RAILGUN_ASSISTED_CHAMBER(WeaponTypes.ASSAULT_RIFLE, (stack, nbt) -> nbt.func_74757_a("energy", true), "gyroscopic_stabilizer", "electric_firing_motor"),
        SEMI_AUTOMATIC(WeaponTypes.RIFLE, "extended_barrel"),
        EXTENDED_BARREL(WeaponTypes.RIFLE, "semi_automatic");

        public final ImmutableSet<WeaponTypes> toolset;
        private final BiPredicate<ItemStack, ItemStack> applyCheck;
        private final BiConsumer<ItemStack, NBTTagCompound> function;

        private WeaponUpgrades(WeaponTypes type, String ... incompatible) {
            this(new WeaponTypes[]{type}, incompatible);
        }

        private WeaponUpgrades(WeaponTypes[] types, String ... incompatible) {
            this(types, (ItemStack stack, NBTTagCompound nbt) -> {}, incompatible);
        }

        private WeaponUpgrades(WeaponTypes type, BiConsumer<ItemStack, NBTTagCompound> appliedTag, String ... incompatible) {
            this(new WeaponTypes[]{type}, appliedTag, incompatible);
        }

        private WeaponUpgrades(WeaponTypes[] types, BiConsumer<ItemStack, NBTTagCompound> appliedTag, String ... incompatible) {
            this.toolset = ImmutableSet.copyOf((Object[])types);
            this.applyCheck = (target, upgrade) -> {
                NBTTagCompound upgrades = ((IUpgradeableTool)target.func_77973_b()).getUpgrades(target);
                if (upgrades.func_74764_b(this.func_176610_l())) {
                    return false;
                }
                for (String s : incompatible) {
                    if (!upgrades.func_74764_b(s)) continue;
                    return false;
                }
                return true;
            };
            BiConsumer<ItemStack, NBTTagCompound> nbtFunction = (upgrade, modifications) -> modifications.func_74757_a(this.func_176610_l(), true);
            this.function = appliedTag != null ? nbtFunction.andThen(appliedTag) : nbtFunction;
        }
    }

    public static enum WeaponTypes implements ISerializableEnum
    {
        MACHINEGUN(14432569, '\u24b6'),
        SUBMACHINEGUN(16746829, '\u24b7'),
        RAILGUN(4024147, '\u24b8'),
        REVOLVER(4080769, '\u24b9'),
        AUTOREVOLVER(2895963, '\u24ba'),
        ASSAULT_RIFLE(16737344, '\u24bb'),
        SPIGOT_MORTAR(8016781, '\u24bc'),
        RIFLE(8684046, '\u24bd');

        public final int color;
        public final char symbol;

        private WeaponTypes(int color, char symbol) {
            this.color = color;
            this.symbol = symbol;
        }
    }
}

