/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.item.weapons.ammohandler;

import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.bullets.IAmmo;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ItemIIGunBase;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ammohandler.AmmoHandler;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;

public abstract class AmmoHandlerList
extends AmmoHandler {
    private final IAmmo validAmmo;
    private final String tag;
    private final int size;

    public AmmoHandlerList(ItemIIGunBase item, String tag, IAmmo validAmmo, int size) {
        super(item);
        this.tag = tag;
        this.validAmmo = validAmmo;
        this.size = size;
    }

    @Override
    public boolean canFire(ItemStack weapon, EasyNBT nbt) {
        return !nbt.getList(this.tag, 10).func_82582_d();
    }

    @Override
    public boolean isValidAmmo(ItemStack weapon, ItemStack ammo) {
        return ammo.func_77973_b() == this.validAmmo;
    }

    @Override
    @Nonnull
    public ItemStack getNextAmmo(ItemStack weapon, EasyNBT nbt, boolean doTake) {
        NBTTagList list = nbt.getList(this.tag, 10);
        if (doTake) {
            return new ItemStack((NBTTagCompound)list.func_74744_a(0));
        }
        return new ItemStack(list.func_150305_b(0));
    }

    @Override
    public int reloadWeapon(ItemStack weapon, World world, Entity user, EasyNBT nbt, EasyNBT upgrades, int reloading) {
        boolean finish;
        ItemStack found = this.item.findAmmo(user, weapon);
        if (found.func_190926_b()) {
            return 0;
        }
        NBTTagList list = nbt.getList(this.tag, 10);
        if (list.func_74745_c() >= this.size) {
            return 0;
        }
        int reloadTime = this.item.getReloadTime(weapon, found, upgrades);
        nbt.withItemStack("found", found);
        if (reloading == 1) {
            this.playSound(user, this.getStartLoadingSound(weapon, upgrades), SoundCategory.PLAYERS, 1.0f, 1.0f);
        } else if (reloading == reloadTime / 3) {
            this.playSound(user, this.getReloadSound(weapon, upgrades), SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        boolean bl = finish = ++reloading >= reloadTime;
        if (finish || list.func_74745_c() < this.size - 1 && (double)reloading >= (double)reloadTime / 1.5) {
            ItemStack copy = found.func_77946_l();
            copy.func_190920_e(1);
            list.func_74742_a((NBTBase)copy.serializeNBT());
            found.func_190918_g(1);
            nbt.withTag(this.tag, (NBTBase)list);
            if (list.func_74745_c() < this.size) {
                return reloading / 3;
            }
        }
        if (finish) {
            if (!world.field_72995_K) {
                this.playSound(user, this.getFinishLoadingSound(weapon, upgrades), SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            return 0;
        }
        return reloading;
    }

    @Override
    public void addAmmoInformation(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flag) {
        NBTTagList list = ItemNBTHelper.getTag((ItemStack)stack).func_150295_c(this.tag, 10);
        for (NBTBase nbt : list) {
            tooltip.add("   " + TextFormatting.GOLD + new ItemStack((NBTTagCompound)nbt).func_82833_r());
        }
    }

    @Override
    public NBTTagList getAmmoList(ItemStack stack) {
        return ItemNBTHelper.getTag((ItemStack)stack).func_150295_c(this.tag, 10);
    }

    @Nullable
    protected abstract SoundEvent getFinishLoadingSound(ItemStack var1, EasyNBT var2);

    @Nullable
    protected abstract SoundEvent getStartLoadingSound(ItemStack var1, EasyNBT var2);

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nullable
    protected SoundEvent getUnloadSound(ItemStack weapon, EasyNBT nbt) {
        return null;
    }
}

