/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.item.weapons.ammohandler;

import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import pl.pabilo8.immersiveintelligence.api.bullets.IAmmo;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.item.ammo.ItemIIBulletMagazine;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ItemIIGunBase;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ammohandler.AmmoHandler;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;

public abstract class AmmoHandlerMagazine
extends AmmoHandler {
    private final IAmmo validAmmo;
    private final String tag;

    public AmmoHandlerMagazine(ItemIIGunBase item, String tag, IAmmo validAmmo) {
        super(item);
        this.tag = tag;
        this.validAmmo = validAmmo;
    }

    @Override
    public boolean canFire(ItemStack weapon, EasyNBT nbt) {
        return !IIContent.itemBulletMagazine.hasNoBullets(nbt.getItemStack(this.tag));
    }

    @Override
    public boolean isValidAmmo(ItemStack weapon, ItemStack ammo) {
        if (ammo.func_77973_b() == IIContent.itemBulletMagazine) {
            ItemIIBulletMagazine.Magazines magazine = (ItemIIBulletMagazine.Magazines)IIContent.itemBulletMagazine.stackToSub(ammo);
            return magazine.ammo == this.validAmmo && this.isValidType(weapon, magazine) && !IIContent.itemBulletMagazine.hasNoBullets(ammo);
        }
        return false;
    }

    protected boolean isValidType(ItemStack weapon, ItemIIBulletMagazine.Magazines magazine) {
        return true;
    }

    @Override
    @Nonnull
    public ItemStack getNextAmmo(ItemStack weapon, EasyNBT nbt, boolean doTake) {
        ItemStack magazine = nbt.getItemStack(this.tag);
        ItemStack ammo = IIContent.itemBulletMagazine.takeBullet(magazine, doTake);
        if (doTake) {
            nbt.withItemStack(this.tag, magazine);
        }
        return ammo;
    }

    @Override
    public int reloadWeapon(ItemStack weapon, World world, Entity user, EasyNBT nbt, EasyNBT upgrades, int reloading) {
        ItemStack loaded = nbt.getItemStack(this.tag);
        int reloadTime = this.item.getReloadTime(weapon, loaded, upgrades);
        if (!loaded.func_190926_b()) {
            if (reloading == reloadTime / 3) {
                this.playSound(user, this.getUnloadSound(weapon, upgrades), SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            if (++reloading >= reloadTime) {
                if (!world.field_72995_K) {
                    IIContent.itemBulletMagazine.defaultize(loaded);
                    IIUtils.giveOrDropCasingStack(user, loaded);
                    nbt.without(this.tag);
                }
                return 0;
            }
            return reloading;
        }
        ItemStack found = this.item.findAmmo(user, weapon);
        if (found.func_190926_b()) {
            return 0;
        }
        this.markLoadedAmmo(nbt, found);
        if ((double)reloading == (double)reloadTime / 1.5) {
            this.playSound(user, this.getReloadSound(weapon, upgrades), SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        if (++reloading >= reloadTime) {
            if (!world.field_72995_K) {
                nbt.withItemStack(this.tag, found);
                found.func_190918_g(1);
            }
            return 0;
        }
        return reloading;
    }

    public void markLoadedAmmo(EasyNBT nbt, ItemStack ammo) {
    }

    @Override
    public void addAmmoInformation(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flag) {
        IIContent.itemBulletMagazine.func_77624_a(ItemNBTHelper.getItemStack((ItemStack)stack, (String)this.tag), world, tooltip, flag);
    }

    @Override
    public NBTTagList getAmmoList(ItemStack stack) {
        return ItemNBTHelper.getTagCompound((ItemStack)ItemNBTHelper.getItemStack((ItemStack)stack, (String)this.tag), (String)"bullets").func_150295_c("dictionary", 10);
    }
}

