/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.item.weapons.ammohandler;

import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import pl.pabilo8.immersiveintelligence.api.bullets.IAmmo;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ItemIIGunBase;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ammohandler.AmmoHandler;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;

public abstract class AmmoHandlerSingle
extends AmmoHandler {
    private final IAmmo validAmmo;
    private final String tag;

    public AmmoHandlerSingle(ItemIIGunBase item, String tag, IAmmo validAmmo) {
        super(item);
        this.tag = tag;
        this.validAmmo = validAmmo;
    }

    @Override
    public boolean canFire(ItemStack weapon, EasyNBT nbt) {
        return !nbt.getItemStack(this.tag).func_190926_b();
    }

    @Override
    public boolean isValidAmmo(ItemStack weapon, ItemStack ammo) {
        return ammo.func_77973_b() == this.validAmmo;
    }

    @Override
    @Nonnull
    public ItemStack getNextAmmo(ItemStack weapon, EasyNBT nbt, boolean doTake) {
        ItemStack stack = nbt.getItemStack(this.tag);
        if (doTake) {
            nbt.without(this.tag);
        }
        return stack;
    }

    @Override
    public int reloadWeapon(ItemStack weapon, World world, Entity user, EasyNBT nbt, EasyNBT upgrades, int reloading) {
        ItemStack found = this.item.findAmmo(user, weapon);
        if (found.func_190926_b()) {
            return 0;
        }
        int reloadTime = this.item.getReloadTime(weapon, found, upgrades);
        if (reloading == 0) {
            this.playSound(user, this.getReloadSound(weapon, upgrades), SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        nbt.withItemStack("found", found);
        if (++reloading >= reloadTime) {
            if (!world.field_72995_K) {
                nbt.withItemStack(this.tag, found);
                found.func_190918_g(1);
            }
            return 0;
        }
        return reloading;
    }

    @Override
    public void addAmmoInformation(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flag) {
        tooltip.add("   " + TextFormatting.GOLD + ItemNBTHelper.getItemStack((ItemStack)stack, (String)this.tag).func_82833_r());
    }

    @Override
    public NBTTagList getAmmoList(ItemStack stack) {
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)ItemNBTHelper.getTagCompound((ItemStack)stack, (String)this.tag));
        return list;
    }
}

