/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.network;

import blusunrize.immersiveengineering.api.DimensionBlockPos;
import blusunrize.immersiveengineering.client.ClientUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class IIMessage
implements IMessage {
    protected abstract void onServerReceive(WorldServer var1, NetHandlerPlayServer var2);

    @SideOnly(value=Side.CLIENT)
    protected abstract void onClientReceive(WorldClient var1, NetHandlerPlayClient var2);

    protected ByteBuf writeString(ByteBuf buf, String value) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)value);
        return buf;
    }

    protected String readString(ByteBuf buf) {
        return ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    protected ByteBuf writePos(ByteBuf buf, BlockPos value) {
        return buf.writeInt(value.func_177958_n()).writeInt(value.func_177956_o()).writeInt(value.func_177952_p());
    }

    protected BlockPos readPos(ByteBuf buf) {
        return new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
    }

    protected ByteBuf writeDimPos(ByteBuf buf, DimensionBlockPos value) {
        return buf.writeInt(value.func_177958_n()).writeInt(value.func_177956_o()).writeInt(value.func_177952_p()).writeInt(value.dimension);
    }

    protected DimensionBlockPos readDimPos(ByteBuf buf) {
        return new DimensionBlockPos(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    protected ByteBuf writeVec3(ByteBuf buf, Vec3d value) {
        return buf.writeDouble(value.field_72450_a).writeDouble(value.field_72448_b).writeDouble(value.field_72449_c);
    }

    protected Vec3d readVec3(ByteBuf buf) {
        return new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    protected ByteBuf writeTagCompound(ByteBuf buf, NBTTagCompound value) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)value);
        return buf;
    }

    protected NBTTagCompound readTagCompound(ByteBuf buf) {
        return ByteBufUtils.readTag((ByteBuf)buf);
    }

    public static class IIMessageHandler<MSG extends IIMessage>
    implements IMessageHandler<MSG, IMessage> {
        public IMessage onMessage(MSG message, MessageContext ctx) {
            if (ctx.side.isClient()) {
                this.receiveMessageClient(message, ctx);
            } else {
                this.receiveMessageServer(message, ctx);
            }
            return null;
        }

        private void receiveMessageServer(MSG message, MessageContext ctx) {
            WorldServer world = ctx.getServerHandler().field_147369_b.func_71121_q();
            if (world != null) {
                world.func_152344_a(() -> message.onServerReceive(world, ctx.getServerHandler()));
            }
        }

        @SideOnly(value=Side.CLIENT)
        private void receiveMessageClient(MSG message, MessageContext ctx) {
            if (ClientUtils.mc().field_71441_e != null) {
                ClientUtils.mc().func_152344_a(() -> message.onClientReceive(ClientUtils.mc().field_71441_e, ctx.getClientHandler()));
            }
        }
    }
}

