/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.network;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import pl.pabilo8.immersiveintelligence.common.network.IIMessage;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageBeginMachineUpgrade;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageBlockDamageSync;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageBooleanAnimatedPartsSync;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageChatInfo;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageEntityNBTSync;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageExplosion;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageFireworks;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageGuiNBT;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageIITileSync;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageItemKeybind;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageItemScrollableSwitch;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageManualClose;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageParticleEffect;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageParticleGunfire;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessagePlayIISound;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessagePlayerAimAnimationSync;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageRotaryPowerSync;
import pl.pabilo8.immersiveintelligence.common.util.AdvancedSounds;

public class IIPacketHandler {
    public static final SimpleNetworkWrapper INSTANCE = NetworkRegistry.INSTANCE.newSimpleChannel("immersiveintelli");
    private static int messageID = 0;
    public static int DEFAULT_RANGE = 40;

    public static void preInit() {
        IIPacketHandler.registerMessage(MessageItemScrollableSwitch.class, false, true);
        IIPacketHandler.registerMessage(MessageBooleanAnimatedPartsSync.class, true, true);
        IIPacketHandler.registerMessage(MessageChatInfo.class, true, false);
        IIPacketHandler.registerMessage(MessageIITileSync.class, true, true);
        IIPacketHandler.registerMessage(MessageGuiNBT.class, false, true);
        IIPacketHandler.registerMessage(MessageEntityNBTSync.class, true, true);
        IIPacketHandler.registerMessage(MessageFireworks.class, true, false);
        IIPacketHandler.registerMessage(MessageRotaryPowerSync.class, true, false);
        IIPacketHandler.registerMessage(MessageBlockDamageSync.class, true, false);
        IIPacketHandler.registerMessage(MessagePlayerAimAnimationSync.class, true, false);
        IIPacketHandler.registerMessage(MessageItemKeybind.class, true, true);
        IIPacketHandler.registerMessage(MessageExplosion.class, true, false);
        IIPacketHandler.registerMessage(MessageParticleEffect.class, true, false);
        IIPacketHandler.registerMessage(MessageBeginMachineUpgrade.class, true, true);
        IIPacketHandler.registerMessage(MessageParticleGunfire.class, true, false);
        IIPacketHandler.registerMessage(MessageManualClose.class, false, true);
        IIPacketHandler.registerMessage(MessagePlayIISound.class, true, false);
    }

    private static <T extends IIMessage> void registerMessage(Class<T> message, boolean clientSide, boolean serverSide) {
        IIMessage.IIMessageHandler handler = new IIMessage.IIMessageHandler();
        if (clientSide) {
            INSTANCE.registerMessage(handler, message, messageID++, Side.CLIENT);
        }
        if (serverSide) {
            INSTANCE.registerMessage(handler, message, messageID++, Side.SERVER);
        }
    }

    public static void sendToServer(IIMessage message) {
        INSTANCE.sendToServer((IMessage)message);
    }

    public static void sendToClient(BlockPos pos, World world, IIMessage message) {
        INSTANCE.sendToAllTracking((IMessage)message, IIPacketHandler.targetPointFromPos(pos, world, DEFAULT_RANGE));
    }

    public static void sendToClient(Vec3d pos, World world, IIMessage message) {
        INSTANCE.sendToAllTracking((IMessage)message, IIPacketHandler.targetPointFromPos(pos, world, DEFAULT_RANGE));
    }

    public static void sendToClient(Entity entity, IIMessage message) {
        INSTANCE.sendToAllTracking((IMessage)message, entity);
    }

    public static void sendToClient(TileEntity tile, IIMessage message) {
        INSTANCE.sendToAllTracking((IMessage)message, IIPacketHandler.targetPointFromTile(tile, DEFAULT_RANGE));
    }

    public static void sendChatInfo(EntityPlayer player, ITextComponent ... components) {
        INSTANCE.sendTo((IMessage)new MessageChatInfo(components), (EntityPlayerMP)player);
    }

    public static void sendChatString(EntityPlayer player, String string) {
        IIPacketHandler.sendChatInfo(player, new ITextComponent[]{new TextComponentString(string)});
    }

    public static void sendChatTranslation(EntityPlayer player, String translation, Object ... args) {
        IIPacketHandler.sendChatInfo(player, new ITextComponent[]{new TextComponentTranslation(translation, args)});
    }

    public static void playMultiSound(World world, Vec3d pos, AdvancedSounds.MultiSound sound, SoundCategory category, int distance, int time, float volume, float pitch) {
        INSTANCE.sendToAllAround((IMessage)new MessagePlayIISound(sound, category, time, pos, volume, pitch), IIPacketHandler.targetPointFromPos(pos, world, distance));
    }

    public static void playRangedSound(World world, Vec3d pos, AdvancedSounds.RangedSound sound, SoundCategory category, int distance, float volume, float pitch) {
        INSTANCE.sendToAllAround((IMessage)new MessagePlayIISound(sound, category, distance, pos, volume, pitch), IIPacketHandler.targetPointFromPos(pos, world, distance));
    }

    public static NetworkRegistry.TargetPoint targetPointFromPos(BlockPos pos, World world, int range) {
        return new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)range);
    }

    public static NetworkRegistry.TargetPoint targetPointFromPos(Vec3d pos, World world, int range) {
        return new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, (double)range);
    }

    public static NetworkRegistry.TargetPoint targetPointFromEntity(Entity entity, int range) {
        return new NetworkRegistry.TargetPoint(entity.field_70170_p.field_73011_w.getDimension(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (double)range);
    }

    public static NetworkRegistry.TargetPoint targetPointFromTile(TileEntity tile, int range) {
        return new NetworkRegistry.TargetPoint(tile.func_145831_w().field_73011_w.getDimension(), (double)tile.func_174877_v().func_177958_n(), (double)tile.func_174877_v().func_177956_o(), (double)tile.func_174877_v().func_177952_p(), (double)range);
    }
}

