/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.network.messages;

import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import pl.pabilo8.immersiveintelligence.api.utils.MachineUpgrade;
import pl.pabilo8.immersiveintelligence.api.utils.vehicles.IUpgradableMachine;
import pl.pabilo8.immersiveintelligence.common.network.IIMessage;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;

public class MessageBeginMachineUpgrade
extends IIMessage {
    private int entityID;
    private BlockPos pos;
    private boolean install;
    private String machineID;

    public MessageBeginMachineUpgrade(TileEntity tile, String machineID, Entity user, boolean install) {
        this.entityID = user.func_145782_y();
        this.pos = tile.func_174877_v();
        this.install = install;
        this.machineID = machineID;
    }

    public MessageBeginMachineUpgrade() {
    }

    @Override
    protected void onServerReceive(WorldServer world, NetHandlerPlayServer handler) {
        IUpgradableMachine machine;
        Entity entity = world.func_73045_a(this.entityID);
        if (!(entity instanceof EntityLivingBase) || !world.func_175667_e(this.pos)) {
            return;
        }
        TileEntity tile = world.func_175625_s(this.pos);
        MachineUpgrade upgrade = MachineUpgrade.getUpgradeByID(this.machineID);
        if (tile instanceof IUpgradableMachine && (machine = (IUpgradableMachine)tile).getInstallProgress() == 0 && upgrade != null && machine.upgradeMatches(upgrade)) {
            if (this.install) {
                IItemHandler capability = (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                if (capability == null) {
                    return;
                }
                if (!(entity instanceof EntityPlayer) || !((EntityPlayer)entity).func_184812_l_()) {
                    for (IngredientStack requiredStack : upgrade.getRequiredStacks()) {
                        int reqSize = requiredStack.inputSize;
                        for (int slot = 0; slot < capability.getSlots(); ++slot) {
                            ItemStack inSlot = capability.getStackInSlot(slot);
                            if (inSlot.func_190926_b() || !requiredStack.matchesItemStackIgnoringSize(inSlot)) continue;
                            int ii = Math.min(inSlot.func_190916_E(), reqSize);
                            capability.extractItem(slot, ii, false);
                            if ((reqSize -= ii) <= 0) break;
                        }
                        if (reqSize <= 0) continue;
                        return;
                    }
                }
                machine.startUpgrade(upgrade);
            } else {
                machine.removeUpgrade(upgrade);
            }
            IIPacketHandler.INSTANCE.sendToAllTracking((IMessage)this, IIPacketHandler.targetPointFromTile(tile, 32));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void onClientReceive(WorldClient world, NetHandlerPlayClient handler) {
        if (world != null) {
            TileEntity tile = world.func_175625_s(this.pos);
            MachineUpgrade upgrade = MachineUpgrade.getUpgradeByID(this.machineID);
            if (!(tile instanceof IUpgradableMachine)) {
                return;
            }
            IUpgradableMachine machine = (IUpgradableMachine)tile;
            if (this.install) {
                if (machine.getInstallProgress() == 0 && upgrade != null && machine.upgradeMatches(upgrade)) {
                    machine.startUpgrade(upgrade);
                }
            } else {
                machine.removeUpgrade(upgrade);
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.entityID = buf.readInt();
        this.pos = this.readPos(buf);
        this.install = buf.readBoolean();
        this.machineID = this.readString(buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityID);
        this.writePos(buf, this.pos);
        buf.writeBoolean(this.install);
        this.writeString(buf, this.machineID);
    }
}

