/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.network.messages;

import blusunrize.immersiveengineering.api.DimensionBlockPos;
import blusunrize.immersiveengineering.common.util.Utils;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.LambdaMetafactory;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.bullets.DamageBlockPos;
import pl.pabilo8.immersiveintelligence.api.bullets.PenetrationRegistry;
import pl.pabilo8.immersiveintelligence.client.fx.ParticleUtils;
import pl.pabilo8.immersiveintelligence.client.fx.nuke.ParticleShockwave;
import pl.pabilo8.immersiveintelligence.common.network.IIMessage;

public class MessageBlockDamageSync
extends IIMessage {
    private float damage;
    private DimensionBlockPos dPos;
    private Vec3d direction;

    public MessageBlockDamageSync(DamageBlockPos pos) {
        this.damage = pos.damage;
        this.dPos = pos;
    }

    public MessageBlockDamageSync(DamageBlockPos pos, Vec3d direction) {
        this.damage = pos.damage;
        this.dPos = pos;
        this.direction = direction;
    }

    public MessageBlockDamageSync() {
    }

    @Override
    protected void onServerReceive(WorldServer world, NetHandlerPlayServer handler) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void onClientReceive(WorldClient world, NetHandlerPlayClient handler) {
        DamageBlockPos dmgPos = new DamageBlockPos(this.dPos, this.damage);
        if (this.damage > 0.0f) {
            if (this.direction != null) {
                Vec3d cPos = new Vec3d((Vec3i)this.dPos).func_72441_c(0.5, 0.5, 0.5).func_178787_e(this.direction.func_186678_a(-0.6));
                this.direction = this.direction.func_186678_a(-1.0);
                ParticleShockwave particle = new ParticleShockwave((World)world, cPos, Vec3d.field_186680_a, 2.5f);
                particle.func_187114_a(5);
                ParticleUtils.particleRenderer.addEffect(particle);
                for (int p = 0; p < 4; ++p) {
                    ParticleUtils.spawnBlockFragmentFX(cPos, new Vec3d(this.direction.field_72450_a, 0.0, this.direction.field_72449_c).func_178785_b(Utils.RAND.nextFloat() % 1.57f - 0.785f).func_178789_a(Utils.RAND.nextFloat() % 1.57f - 0.785f).func_72441_c(0.0, this.direction.field_72448_b, 0.0).func_186678_a(0.28), 0.5f, world.func_180495_p((BlockPos)this.dPos));
                }
            }
            PenetrationRegistry.blockDamageClient.stream().filter((Predicate<DamageBlockPos>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$onClientReceive$0(pl.pabilo8.immersiveintelligence.api.bullets.DamageBlockPos pl.pabilo8.immersiveintelligence.api.bullets.DamageBlockPos ), (Lpl/pabilo8/immersiveintelligence/api/bullets/DamageBlockPos;)Z)((DamageBlockPos)dmgPos)).findFirst().orElseGet((Supplier<DamageBlockPos>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$onClientReceive$1(pl.pabilo8.immersiveintelligence.api.bullets.DamageBlockPos ), ()Lpl/pabilo8/immersiveintelligence/api/bullets/DamageBlockPos;)((DamageBlockPos)dmgPos)).damage = dmgPos.damage;
        } else {
            PenetrationRegistry.blockDamageClient.removeIf(damageBlockPos -> damageBlockPos.equals((Object)dmgPos));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeFloat(this.damage);
        this.writeDimPos(buf, this.dPos);
        if (this.direction != null) {
            buf.writeBoolean(true);
            this.writeVec3(buf, this.direction);
        } else {
            buf.writeBoolean(false);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.damage = buf.readFloat();
        this.dPos = this.readDimPos(buf);
        if (buf.readBoolean()) {
            this.direction = this.readVec3(buf);
        }
    }

    private static /* synthetic */ DamageBlockPos lambda$onClientReceive$1(DamageBlockPos dmgPos) {
        PenetrationRegistry.blockDamageClient.add(dmgPos);
        return dmgPos;
    }

    private static /* synthetic */ boolean lambda$onClientReceive$0(DamageBlockPos dmgPos, DamageBlockPos d) {
        return d.equals((Object)dmgPos);
    }
}

