/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.network.messages;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.common.entity.EntityMachinegun;
import pl.pabilo8.immersiveintelligence.common.entity.EntityMortar;
import pl.pabilo8.immersiveintelligence.common.entity.bullet.EntityBullet;
import pl.pabilo8.immersiveintelligence.common.entity.vehicle.EntityFieldHowitzer;
import pl.pabilo8.immersiveintelligence.common.entity.vehicle.EntityMotorbike;
import pl.pabilo8.immersiveintelligence.common.network.IIMessage;

public class MessageEntityNBTSync
extends IIMessage {
    private int entityID;
    private NBTTagCompound tag;

    public MessageEntityNBTSync(Entity entity, NBTTagCompound tag) {
        this.entityID = entity.func_145782_y();
        this.tag = tag;
    }

    public MessageEntityNBTSync() {
    }

    @Override
    protected void onServerReceive(WorldServer world, NetHandlerPlayServer handler) {
        Entity entity = world.func_73045_a(this.entityID);
        if (entity instanceof EntityMachinegun) {
            ((EntityMachinegun)entity).func_70037_a(this.tag);
        } else if (entity instanceof EntityMotorbike) {
            ((EntityMotorbike)entity).syncKeyPress(this.tag);
        } else if (entity instanceof EntityFieldHowitzer) {
            ((EntityFieldHowitzer)entity).syncKeyPress(this.tag);
        } else if (entity instanceof EntityMortar) {
            ((EntityMortar)entity).syncKeyPress(this.tag);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void onClientReceive(WorldClient world, NetHandlerPlayClient handler) {
        Entity entity = world.func_73045_a(this.entityID);
        if (entity instanceof EntityBullet) {
            ((EntityBullet)entity).func_70037_a(this.tag);
        } else if (entity instanceof EntityMachinegun) {
            ((EntityMachinegun)entity).func_70037_a(this.tag);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.entityID = buf.readInt();
        this.tag = this.readTagCompound(buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityID);
        this.writeTagCompound(buf, this.tag);
    }
}

