/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.network.messages;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.client.fx.ParticleUtils;
import pl.pabilo8.immersiveintelligence.common.network.IIMessage;

public class MessageExplosion
extends IIMessage {
    private boolean flaming;
    private boolean damagesTerrain;
    private float radius;
    private float strength;
    private Vec3d pos;

    public MessageExplosion(boolean flaming, boolean damagesTerrain, float radius, float strength, Vec3d pos) {
        this.flaming = flaming;
        this.damagesTerrain = damagesTerrain;
        this.radius = radius;
        this.strength = strength;
        this.pos = pos;
    }

    public MessageExplosion() {
    }

    @Override
    protected void onServerReceive(WorldServer world, NetHandlerPlayServer handler) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void onClientReceive(WorldClient world, NetHandlerPlayClient handler) {
        ParticleUtils.spawnExplosionBoomFX((World)world, this.pos, this.radius, this.strength, this.flaming, this.damagesTerrain);
    }

    public void fromBytes(ByteBuf buf) {
        this.flaming = buf.readBoolean();
        this.damagesTerrain = buf.readBoolean();
        this.radius = buf.readFloat();
        this.strength = buf.readFloat();
        this.pos = this.readVec3(buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.flaming);
        buf.writeBoolean(this.damagesTerrain);
        buf.writeFloat(this.radius);
        buf.writeFloat(this.strength);
        this.writeVec3(buf, this.pos);
    }
}

