/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.network.messages;

import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.common.network.IIMessage;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;

public class MessageIITileSync
extends IIMessage {
    BlockPos pos;
    NBTTagCompound nbt;

    public MessageIITileSync(TileEntityIEBase tile, NBTTagCompound nbt) {
        this.pos = tile.func_174877_v();
        this.nbt = nbt;
    }

    public MessageIITileSync(TileEntityIEBase tile, EasyNBT nbt) {
        this(tile, nbt.unwrap());
    }

    public MessageIITileSync(TileEntityIEBase tile) {
        this(tile, MessageIITileSync.getNBT(tile));
    }

    public static NBTTagCompound getNBT(TileEntityIEBase tile) {
        NBTTagCompound nbt = new NBTTagCompound();
        tile.writeCustomNBT(nbt, false);
        return nbt;
    }

    public MessageIITileSync() {
    }

    @Override
    protected void onServerReceive(WorldServer world, NetHandlerPlayServer handler) {
        TileEntity tile;
        if (world.func_175667_e(this.pos) && (tile = world.func_175625_s(this.pos)) instanceof TileEntityIEBase) {
            ((TileEntityIEBase)tile).receiveMessageFromClient(this.nbt);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void onClientReceive(WorldClient world, NetHandlerPlayClient handler) {
        TileEntity tile;
        if (world.func_175667_e(this.pos) && (tile = world.func_175625_s(this.pos)) instanceof TileEntityIEBase) {
            ((TileEntityIEBase)tile).receiveMessageFromServer(this.nbt);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = this.readPos(buf);
        this.nbt = this.readTagCompound(buf);
    }

    public void toBytes(ByteBuf buf) {
        this.writePos(buf, this.pos);
        this.writeTagCompound(buf, this.nbt);
    }
}

