/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.network.messages;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.Entity;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import pl.pabilo8.immersiveintelligence.client.fx.ParticleUtils;
import pl.pabilo8.immersiveintelligence.common.entity.vehicle.EntityMotorbike;
import pl.pabilo8.immersiveintelligence.common.network.IIMessage;

public class MessageParticleEffect
extends IIMessage {
    private Vec3d pos;
    private String id;

    public MessageParticleEffect(Vec3d pos, String id) {
        this.pos = pos;
        this.id = id;
    }

    public MessageParticleEffect() {
    }

    @Override
    protected void onServerReceive(WorldServer world, NetHandlerPlayServer handler) {
    }

    @Override
    protected void onClientReceive(WorldClient world, NetHandlerPlayClient handler) {
        switch (this.id) {
            case "white_phosphorus": {
                ParticleUtils.spawnExplosionPhosphorusFX(this.pos);
                break;
            }
            case "motorbike_explosion": {
                Entity e = world.func_73045_a((int)this.pos.field_72450_a);
                if (!(e instanceof EntityMotorbike)) break;
                EntityMotorbike motorbike = (EntityMotorbike)e;
                motorbike.selfDestruct();
                break;
            }
            case "gunfire": {
                ParticleUtils.spawnGunfireFX(this.pos, Vec3d.field_186680_a, 8.0f);
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = this.readVec3(buf);
        this.id = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        this.writeVec3(buf, this.pos);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.id);
    }
}

