/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.network.messages;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import pl.pabilo8.immersiveintelligence.client.ClientEventHandler;
import pl.pabilo8.immersiveintelligence.client.fx.ParticleUtils;
import pl.pabilo8.immersiveintelligence.common.network.IIMessage;

public class MessageParticleGunfire
extends IIMessage {
    private boolean usesEntity;
    private int entityID;
    public Vec3d pos;
    public Vec3d dir;
    public float size;

    public MessageParticleGunfire(Vec3d pos, Vec3d dir, float size) {
        this.usesEntity = false;
        this.pos = pos;
        this.dir = dir;
        this.size = size;
    }

    public MessageParticleGunfire(Entity entity, float size) {
        this.usesEntity = true;
        this.entityID = entity.func_145782_y();
        this.size = size;
    }

    public MessageParticleGunfire() {
    }

    @Override
    protected void onServerReceive(WorldServer world, NetHandlerPlayServer handler) {
    }

    @Override
    protected void onClientReceive(WorldClient world, NetHandlerPlayClient handler) {
        if (this.usesEntity) {
            Entity entity = world.func_73045_a(this.entityID);
            if (entity instanceof EntityLivingBase) {
                ClientEventHandler.gunshotEntities.put((EntityLivingBase)entity, Float.valueOf(this.size));
            }
        } else {
            ParticleUtils.spawnGunfireFX(this.pos, this.dir, this.size);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.usesEntity = buf.readBoolean();
        if (this.usesEntity) {
            this.entityID = buf.readInt();
        } else {
            this.pos = this.readVec3(buf);
            this.dir = this.readVec3(buf);
        }
        this.size = buf.readFloat();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.usesEntity);
        if (this.usesEntity) {
            buf.writeInt(this.entityID);
        } else {
            this.writeVec3(buf, this.pos);
            this.writeVec3(buf, this.dir);
        }
        buf.writeFloat(this.size);
    }
}

