/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.network.messages;

import blusunrize.immersiveengineering.client.ClientUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.client.util.carversound.RangedCompoundSound;
import pl.pabilo8.immersiveintelligence.client.util.carversound.TimedCompoundSound;
import pl.pabilo8.immersiveintelligence.common.IISounds;
import pl.pabilo8.immersiveintelligence.common.network.IIMessage;
import pl.pabilo8.immersiveintelligence.common.util.AdvancedSounds;

public class MessagePlayIISound
extends IIMessage {
    private AdvancedSounds.RangedSound soundRanged;
    private AdvancedSounds.MultiSound soundCompound;
    private Type type;
    private SoundCategory category;
    private int duration;
    private int distance;
    private Vec3d pos;
    private float volume;
    private float pitch;

    public MessagePlayIISound(AdvancedSounds.MultiSound sound, SoundCategory category, int duration, Vec3d pos, float volume, float pitch) {
        this.soundCompound = sound;
        this.category = category;
        this.duration = duration;
        this.type = Type.COMPOUND;
        this.pos = pos;
        this.volume = volume;
        this.pitch = pitch;
    }

    public MessagePlayIISound(AdvancedSounds.RangedSound sound, SoundCategory category, int fullDistance, Vec3d pos, float volume, float pitch) {
        this.soundRanged = sound;
        this.category = category;
        this.distance = fullDistance;
        this.type = Type.RANGED;
        this.pos = pos;
        this.volume = volume;
        this.pitch = pitch;
    }

    public MessagePlayIISound() {
    }

    @Override
    protected void onServerReceive(WorldServer world, NetHandlerPlayServer handler) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void onClientReceive(WorldClient world, NetHandlerPlayClient handler) {
        if (this.soundCompound == null && this.soundRanged == null) {
            return;
        }
        switch (this.type) {
            case COMPOUND: {
                ClientUtils.mc().func_147118_V().func_147682_a((ISound)new TimedCompoundSound(this.soundCompound, this.category, this.pos, this.duration, this.volume, this.pitch));
                break;
            }
            case RANGED: {
                ClientUtils.mc().func_147118_V().func_147682_a((ISound)new RangedCompoundSound(this.soundRanged, this.distance, this.category, this.pos, this.volume, this.pitch));
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.type = Type.values()[buf.readInt()];
        this.category = SoundCategory.values()[buf.readInt()];
        this.pos = this.readVec3(buf);
        this.volume = buf.readFloat();
        this.pitch = buf.readFloat();
        switch (this.type) {
            case RANGED: {
                this.soundRanged = IISounds.rangedSounds.get(buf.readInt());
                this.distance = buf.readInt();
                break;
            }
            case COMPOUND: {
                this.soundCompound = IISounds.multiSounds.get(buf.readInt());
                this.duration = buf.readInt();
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.type.ordinal());
        buf.writeInt(this.category.ordinal());
        this.writeVec3(buf, this.pos);
        buf.writeFloat(this.volume);
        buf.writeFloat(this.pitch);
        switch (this.type) {
            case RANGED: {
                buf.writeInt(this.soundRanged.id);
                buf.writeInt(this.distance);
                break;
            }
            case COMPOUND: {
                buf.writeInt(this.soundCompound.id);
                buf.writeInt(this.duration);
            }
        }
    }

    private static enum Type {
        RANGED,
        COMPOUND;

    }
}

