/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.util;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Tuple;
import pl.pabilo8.immersiveintelligence.api.bullets.PenetrationRegistry;
import pl.pabilo8.immersiveintelligence.common.IISounds;

public class AdvancedSounds {

    public static class RangedSound {
        public final int id = IISounds.rangedSounds.size();
        private final Set<Tuple<Double, SoundEvent>> sounds;

        @SafeVarargs
        public RangedSound(Tuple<Double, SoundEvent> ... sounds) {
            IISounds.rangedSounds.add(this);
            this.sounds = Sets.newHashSet((Object[])sounds);
        }

        public Set<Tuple<Double, SoundEvent>> getSounds() {
            return this.sounds;
        }
    }

    public static class HitSound {
        private final SoundEvent soundImpact;
        private final SoundEvent soundRicochet;

        public HitSound(SoundEvent impact, @Nullable SoundEvent ricochet) {
            this.soundImpact = impact;
            this.soundRicochet = ricochet;
        }

        public SoundEvent getSoundImpact() {
            return this.soundImpact;
        }

        public SoundEvent getSoundRicochet() {
            return this.soundRicochet;
        }

        @Nullable
        public SoundEvent getSpecialSound(PenetrationRegistry.HitEffect effect) {
            return effect == PenetrationRegistry.HitEffect.RICOCHET ? this.soundRicochet : this.soundImpact;
        }
    }

    public static class MultiSound {
        public final int id = IISounds.rangedSounds.size();
        @Nullable
        private final SoundEvent soundBegin;
        @Nullable
        private final SoundEvent soundEnd;
        @Nonnull
        private final SoundEvent soundMid;

        public MultiSound(SoundEvent soundBegin, SoundEvent soundMid, SoundEvent soundEnd) {
            IISounds.multiSounds.add(this);
            this.soundBegin = soundBegin;
            this.soundMid = soundMid;
            this.soundEnd = soundEnd;
        }

        @Nullable
        public SoundEvent getSoundBegin() {
            return this.soundBegin;
        }

        @Nonnull
        public SoundEvent getSoundMid() {
            return this.soundMid;
        }

        @Nullable
        public SoundEvent getSoundEnd() {
            return this.soundEnd;
        }
    }
}

