/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.util;

import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import pl.pabilo8.immersiveintelligence.common.IISounds;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageExplosion;

public class IIExplosion
extends Explosion {
    private static final float LOSS = 1.125f;
    private final float power;
    private final boolean doDrops;

    public IIExplosion(World worldIn, Entity entityIn, double x, double y, double z, float size, float power, boolean flaming, boolean damagesTerrain, boolean doDrops) {
        super(worldIn, entityIn, x, y, z, size, flaming, damagesTerrain);
        this.power = power;
        this.doDrops = doDrops;
    }

    public IIExplosion(World worldIn, Entity entityIn, double x, double y, double z, float size, float power, boolean flaming, boolean damagesTerrain) {
        this(worldIn, entityIn, x, y, z, size, power, flaming, damagesTerrain, true);
    }

    public IIExplosion(World worldIn, Entity entityIn, Vec3d pos, float size, float power, boolean flaming, boolean damagesTerrain, boolean doDrops) {
        this(worldIn, entityIn, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, size, power, flaming, damagesTerrain, doDrops);
    }

    public IIExplosion(World worldIn, Entity entityIn, Vec3d pos, float size, float power, boolean flaming, boolean damagesTerrain) {
        this(worldIn, entityIn, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, size, power, flaming, damagesTerrain);
    }

    public void func_77278_a() {
        this.field_77281_g.addAll(this.generateAffectedBlockPositions());
        float f3 = this.field_77280_f * 2.0f;
        int k1 = MathHelper.func_76128_c((double)(this.field_77284_b - (double)f3 - 1.0));
        int l1 = MathHelper.func_76128_c((double)(this.field_77284_b + (double)f3 + 1.0));
        int i2 = MathHelper.func_76128_c((double)(this.field_77285_c - (double)f3 - 1.0));
        int i1 = MathHelper.func_76128_c((double)(this.field_77285_c + (double)f3 + 1.0));
        int j2 = MathHelper.func_76128_c((double)(this.field_77282_d - (double)f3 - 1.0));
        int j1 = MathHelper.func_76128_c((double)(this.field_77282_d + (double)f3 + 1.0));
        List list = this.field_77287_j.func_72839_b(this.field_77283_e, new AxisAlignedBB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        ForgeEventFactory.onExplosionDetonate((World)this.field_77287_j, (Explosion)this, (List)list, (double)f3);
        Vec3d vec3d = new Vec3d(this.field_77284_b, this.field_77285_c, this.field_77282_d);
        for (Entity entity : list) {
            EntityPlayer entityplayer;
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            if (entity.field_70128_L || entity.func_180427_aV() || !((d12 = entity.func_70011_f(this.field_77284_b, this.field_77285_c, this.field_77282_d) / (double)f3) <= 1.0) || (d13 = (double)MathHelper.func_76133_a((double)((d5 = entity.field_70165_t - this.field_77284_b) * d5 + (d7 = entity.field_70163_u + (double)entity.func_70047_e() - this.field_77285_c) * d7 + (d9 = entity.field_70161_v - this.field_77282_d) * d9))) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = this.field_77287_j.func_72842_a(vec3d, entity.func_174813_aQ());
            double d10 = (1.0 - d12) * d14;
            entity.func_70097_a(DamageSource.func_94539_a((Explosion)this), (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f3 + 1.0)));
            double d11 = d10;
            if (entity instanceof EntityLivingBase) {
                d11 = EnchantmentProtection.func_92092_a((EntityLivingBase)((EntityLivingBase)entity), (double)d10);
            }
            entity.field_70159_w += d5 * d11;
            entity.field_70181_x += d7 * d11;
            entity.field_70179_y += d9 * d11;
            if (!(entity instanceof EntityPlayer) || (entityplayer = (EntityPlayer)entity).func_175149_v() || entityplayer.func_184812_l_() && entityplayer.field_71075_bZ.field_75100_b) continue;
            this.field_77288_k.put(entityplayer, new Vec3d(d5 * d10, d7 * d10, d9 * d10));
        }
    }

    public Set<BlockPos> generateAffectedBlockPositions() {
        HashSet set = Sets.newHashSet();
        int steps = MathHelper.func_76143_f((double)(Math.PI * (double)this.field_77280_f));
        Vec3d center = this.getPosition();
        int lineDensityScale = 2;
        for (int yawSlices = 0; yawSlices < 2 * steps; ++yawSlices) {
            for (int pitchSlice = 0; pitchSlice < steps; ++pitchSlice) {
                float power = this.power - this.field_77280_f * this.field_77287_j.field_73012_v.nextFloat() / 2.0f;
                float yaw = (float)(Math.PI / (double)steps * (double)yawSlices);
                float pitch = (float)(Math.PI / (double)steps * (double)pitchSlice);
                Vec3d direction = new Vec3d((double)(MathHelper.func_76126_a((float)pitch) * MathHelper.func_76134_b((float)yaw)) * 0.5, (double)MathHelper.func_76134_b((float)pitch) * 0.5, (double)(MathHelper.func_76126_a((float)pitch) * MathHelper.func_76126_a((float)yaw)) * 0.5);
                Vec3d current = center;
                while (center.func_72438_d(current) <= (double)this.field_77280_f && power > 0.0f) {
                    power -= 1.125f;
                    BlockPos pos = new BlockPos(MathHelper.func_76128_c((double)current.field_72450_a), MathHelper.func_76128_c((double)current.field_72448_b), MathHelper.func_76128_c((double)current.field_72449_c));
                    if (!set.contains(pos)) {
                        if (!this.field_77287_j.func_175667_e(pos)) continue;
                        IBlockState state = this.field_77287_j.func_180495_p(pos);
                        Block block = state.func_177230_c();
                        if (!block.isAir(state, (IBlockAccess)this.field_77287_j, pos) && state.func_185887_b(this.field_77287_j, pos) >= 0.0f && power > 0.0f && (this.field_77283_e == null || this.field_77283_e.func_174816_a((Explosion)this, this.field_77287_j, pos, state, power))) {
                            set.add(pos);
                        }
                    }
                    current = current.func_178787_e(direction);
                }
            }
        }
        return set;
    }

    public void func_77279_a(boolean spawnParticles) {
        float pitch = (1.0f + (Utils.RAND.nextFloat() - Utils.RAND.nextFloat()) * 0.2f) * 0.7f;
        IIPacketHandler.playRangedSound(this.field_77287_j, this.getPosition(), this.field_77286_a ? IISounds.explosionIncendiary : IISounds.explosion, SoundCategory.NEUTRAL, (int)(72.0f * this.field_77280_f), 1.0f, pitch);
        if (spawnParticles) {
            IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageExplosion(this.field_77286_a, this.field_82755_b, this.field_77280_f, this.power, this.getPosition()), IIPacketHandler.targetPointFromPos(this.getPos(), this.field_77287_j, (int)(64.0f + this.field_77280_f)));
        }
        if (this.field_82755_b) {
            for (BlockPos blockpos : this.field_77281_g) {
                IBlockState iblockstate = this.field_77287_j.func_180495_p(blockpos);
                Block block = iblockstate.func_177230_c();
                if (iblockstate.func_185904_a() == Material.field_151579_a) continue;
                if (this.doDrops && block.func_149659_a((Explosion)this)) {
                    block.func_180653_a(this.field_77287_j, blockpos, this.field_77287_j.func_180495_p(blockpos), 1.0f / this.field_77280_f, 0);
                }
                block.onBlockExploded(this.field_77287_j, blockpos, (Explosion)this);
            }
        }
        if (this.field_77286_a) {
            for (BlockPos blockpos1 : this.field_77281_g) {
                if (this.field_77287_j.func_180495_p(blockpos1).func_185904_a() != Material.field_151579_a || !this.field_77287_j.func_180495_p(blockpos1.func_177977_b()).func_185913_b() || this.field_77290_i.nextInt(3) != 0) continue;
                this.field_77287_j.func_175656_a(blockpos1, Blocks.field_150480_ab.func_176223_P());
            }
        }
    }

    public IIExplosion doExplosion() {
        return this.doExplosion(true);
    }

    public IIExplosion doExplosion(boolean spawnParticles) {
        if (!ForgeEventFactory.onExplosionStart((World)this.field_77287_j, (Explosion)this)) {
            this.func_77278_a();
            this.func_77279_a(spawnParticles);
        }
        return this;
    }

    private BlockPos getPos() {
        return new BlockPos(this.field_77284_b, this.field_77285_c, this.field_77282_d);
    }
}

