/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.util;

import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.lib.manual.IManualPage;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualPages;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonStreamParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import pl.pabilo8.immersiveintelligence.client.manual.pages.IIManualPageContributorSkin;
import pl.pabilo8.immersiveintelligence.client.util.ResLoc;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationLoader;
import pl.pabilo8.immersiveintelligence.common.IILogger;
import pl.pabilo8.immersiveintelligence.common.util.IIReference;

public class IISkinHandler {
    public static final String NBT_ENTRY = "contributorSkin";
    public static final LinkedHashMap<String, IISpecialSkin> specialSkins = new LinkedHashMap();
    public static final LinkedHashMap<String, ArrayList<IISpecialSkin>> specialSkinsByUUID = new LinkedHashMap();
    public static boolean isConnected = false;

    public static void registerSprites(TextureMap map, String skinnable) {
        for (Map.Entry<String, IISpecialSkin> entry : specialSkins.entrySet()) {
            IISpecialSkin skin = entry.getValue();
            if (!skin.doesApply(skinnable)) continue;
            IIAnimationLoader.preloadTexturesFromMTL(ResLoc.of(IIReference.RES_TEXTURES_SKIN, skin.name, "/", skinnable).withExtension(".mtl"), map);
        }
    }

    public static IISpecialSkin getSkin(String skin) {
        if (!IISkinHandler.isValidSkin(skin)) {
            return null;
        }
        return specialSkins.get(skin);
    }

    public static String getItemSkin(ItemStack item) {
        return ItemNBTHelper.getString((ItemStack)item, (String)NBT_ENTRY);
    }

    public static boolean isValidSkin(String skin) {
        return !skin.isEmpty() && specialSkins.containsKey(skin);
    }

    public static String getCurrentSkin(ItemStack item) {
        return ItemNBTHelper.getString((ItemStack)item, (String)NBT_ENTRY);
    }

    public static void getManualPages() {
        ManualHelper.getManual().manualContents.removeAll((Object)"contributor_skins");
        ArrayList<Object> skin_pages = new ArrayList<Object>();
        skin_pages.add(new ManualPages.Text(ManualHelper.getManual(), "contributor_skins"));
        for (IISpecialSkin skin : specialSkins.values()) {
            skin_pages.add((Object)new IIManualPageContributorSkin(ManualHelper.getManual(), skin));
        }
        ManualInstance.ManualEntry contributor_skins = ManualHelper.getManual().getEntry("contributor_skins");
        if (contributor_skins == null) {
            contributor_skins = new ManualInstance.ManualEntry("contributor_skins", "ii_warfare", new IManualPage[0]);
            ManualHelper.getManual().manualContents.put((Object)"ii_warfare", (Object)contributor_skins);
        }
        contributor_skins.setPages((IManualPage[])skin_pages.toArray(new ManualPages[0]));
    }

    public static class ThreadContributorSpecialsDownloader
    extends Thread {
        public static ThreadContributorSpecialsDownloader activeThread;

        public ThreadContributorSpecialsDownloader() {
            this.setName("Immersive Intelligence Contributors Thread");
            this.setDaemon(true);
            this.start();
            activeThread = this;
        }

        @Override
        public void run() {
            Gson gson = new Gson();
            try {
                IILogger.info("Attempting to download II special skin list from GitHub");
                URL url = new URL("https://raw.githubusercontent.com/VDeltaGabriel/ImmersiveIntelligenceDEV/master/contributor_skins.json");
                specialSkins.clear();
                specialSkinsByUUID.clear();
                JsonStreamParser parser = new JsonStreamParser((Reader)new InputStreamReader(url.openStream()));
                JsonArray array = parser.next().getAsJsonArray();
                for (JsonElement jsonElement : array) {
                    try {
                        JsonObject jsonObject = jsonElement.getAsJsonObject();
                        String name = jsonObject.get("name").getAsString();
                        ArrayList uuid = new ArrayList();
                        ArrayList appliesTo = new ArrayList();
                        ArrayList<String> mods = new ArrayList<String>();
                        jsonObject.get("uuid").getAsJsonArray().iterator().forEachRemaining(jsonElement1 -> uuid.add(jsonElement1.getAsString()));
                        jsonObject.get("appliesTo").getAsJsonArray().iterator().forEachRemaining(jsonElement1 -> appliesTo.add(jsonElement1.getAsString()));
                        jsonObject.get("mods").getAsJsonArray().iterator().forEachRemaining(jsonElement1 -> mods.add(jsonElement1.getAsString()));
                        IISpecialSkin skin = new IISpecialSkin(name, uuid.toArray(new String[0]), appliesTo.toArray(new String[0]), mods);
                        specialSkins.put(skin.name, skin);
                        if (skin.uuid == null) continue;
                        for (String id : skin.uuid) {
                            if (specialSkinsByUUID.containsKey(id)) {
                                specialSkinsByUUID.get(id).add(skin);
                                continue;
                            }
                            specialSkinsByUUID.put(id, new ArrayList<IISpecialSkin>(Collections.singleton(skin)));
                        }
                    }
                    catch (Exception excepParse) {
                        IILogger.warn(excepParse);
                    }
                }
                specialSkins.values().forEach(IISpecialSkin::parseAdditionals);
                StringBuilder builder = new StringBuilder("Loaded skins: ");
                specialSkins.values().forEach(specialSkin -> builder.append(specialSkin.name).append(", "));
                IILogger.info(builder.delete(builder.lastIndexOf(", "), builder.length()).toString());
            }
            catch (Exception e) {
                IILogger.info("Could not load contributor special skin list.");
                isConnected = false;
                e.printStackTrace();
            }
        }
    }

    public static class IISpecialSkin {
        public final String name;
        public final String[] uuid;
        public final String[] appliesTo;
        public final List<String> mods;
        public int textColor = 0xFFFFFF;
        public boolean hasCape = false;
        public EnumRarity rarity = EnumRarity.UNCOMMON;

        public IISpecialSkin(String name, String[] uuid, String[] appliesTo, List<String> mods) {
            this.name = name;
            this.uuid = uuid;
            this.appliesTo = appliesTo;
            this.mods = mods;
        }

        public boolean doesApply(String skinnableName) {
            return !Arrays.asList(this.appliesTo).isEmpty() && Arrays.asList(this.appliesTo).contains(skinnableName);
        }

        void parseAdditionals() {
            this.hasCape = this.mods.contains("cape");
            Optional<String> optional = this.mods.stream().filter(s -> s.contains("text_color=")).findFirst();
            optional.ifPresent(s -> {
                this.textColor = Integer.parseInt(s.substring(11), 16);
            });
            this.mods.removeIf(s -> s.contains("text_color="));
            optional = this.mods.stream().filter(s -> s.contains("rarity=")).findFirst();
            optional.map(s -> s.substring(7).replace('/', ':')).ifPresent(substring -> Arrays.stream(EnumRarity.values()).filter(rarity -> rarity.field_77934_f.equals(substring)).forEach(rarity -> {
                this.rarity = rarity;
            }));
            this.mods.removeIf(s -> s.contains("rarity="));
        }

        public String toString() {
            Gson json = new Gson();
            JsonObject info = new JsonObject();
            info.addProperty("name", this.name);
            info.add("uuid", json.toJsonTree((Object)this.uuid));
            info.add("appliesTo", json.toJsonTree((Object)this.appliesTo));
            info.add("mods", json.toJsonTree(this.mods));
            return info.toString();
        }
    }
}

