/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.util;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.client.util.carversound.TimedCompoundSound;
import pl.pabilo8.immersiveintelligence.common.util.AdvancedSounds;

public class IISoundAnimation {
    private final HashMap<Double, SoundEvent> sounds = new HashMap();
    private final HashMap<Double, Tuple<AdvancedSounds.MultiSound, Double>> repeatedSounds = new HashMap();
    private final HashMap<Integer, SoundEvent[]> compiledSounds = new HashMap();
    private final HashMap<Integer, Tuple<AdvancedSounds.MultiSound, Integer>> compiledRepeatedSounds = new HashMap();
    private final double animationDuration;

    public IISoundAnimation(double animationDuration) {
        this.animationDuration = animationDuration;
    }

    public void compile(int maxTime) {
        this.compiledSounds.clear();
        this.sounds.entrySet().stream().map(e -> new Tuple((Object)((int)((Double)e.getKey() * (double)maxTime)), e.getValue())).collect(Collectors.groupingBy(Tuple::func_76341_a)).forEach((time, sound) -> {
            SoundEvent[] sounds = (SoundEvent[])sound.stream().map(Tuple::func_76340_b).toArray(SoundEvent[]::new);
            this.compiledSounds.put((Integer)time, sounds);
        });
        this.repeatedSounds.forEach((beginTime, sound) -> this.compiledRepeatedSounds.put((int)(beginTime * (double)maxTime), (Tuple<AdvancedSounds.MultiSound, Integer>)new Tuple(sound.func_76341_a(), (Object)((int)((Double)sound.func_76340_b() * (double)maxTime)))));
    }

    public IISoundAnimation withSound(double time, @Nonnull SoundEvent sound) {
        this.sounds.put(time / this.animationDuration, sound);
        return this;
    }

    public IISoundAnimation withRepeatedSound(double begin, double end, @Nonnull AdvancedSounds.MultiSound sound) {
        this.repeatedSounds.put(begin / this.animationDuration, (Tuple<AdvancedSounds.MultiSound, Double>)new Tuple((Object)sound, (Object)((end - begin) / this.animationDuration)));
        return this;
    }

    @Nullable
    public SoundEvent[] getSounds(int time) {
        return this.compiledSounds.get(time);
    }

    public void handleSounds(List<TimedCompoundSound> current, BlockPos pos, int animationTime, float volume) {
        this.handleSingleSounds(pos, animationTime, volume);
        this.handleRepeatedSounds(current, pos, animationTime, volume);
    }

    @SideOnly(value=Side.CLIENT)
    public void handleSingleSounds(BlockPos pos, int animationTime, float volume) {
        SoundEvent[] sounds = this.getSounds(animationTime);
        Minecraft mc = ClientUtils.mc();
        if (animationTime == 0) {
            return;
        }
        if (sounds != null) {
            for (SoundEvent sound : sounds) {
                Vec3d vv = new Vec3d((Vec3i)pos).func_72441_c((double)Utils.RAND.nextFloat(), (double)Utils.RAND.nextFloat(), (double)Utils.RAND.nextFloat());
                mc.field_71441_e.func_184148_a((EntityPlayer)mc.field_71439_g, vv.field_72450_a, vv.field_72448_b, vv.field_72449_c, sound, SoundCategory.BLOCKS, volume, 1.0f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleRepeatedSounds(List<TimedCompoundSound> current, BlockPos pos, int animationTime, float volume) {
        Minecraft mc = ClientUtils.mc();
        if (animationTime == 0) {
            return;
        }
        Tuple<AdvancedSounds.MultiSound, Integer> added = this.compiledRepeatedSounds.get(animationTime);
        if (added != null) {
            TimedCompoundSound sound = new TimedCompoundSound((AdvancedSounds.MultiSound)added.func_76341_a(), SoundCategory.BLOCKS, new Vec3d((Vec3i)pos), (Integer)added.func_76340_b(), volume, 1.0f);
            current.add(sound);
            mc.func_147118_V().func_147682_a((ISound)sound);
        }
        current.removeIf(TimedCompoundSound::func_147667_k);
    }
}

