/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.util.block;

import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.util.ISerializableEnum;
import pl.pabilo8.immersiveintelligence.common.util.block.IIBlockInterfaces;
import pl.pabilo8.immersiveintelligence.common.util.block.ItemBlockIIBase;

public class BlockIIBase<E extends Enum<E>>
extends Block
implements IEBlockInterfaces.IIEMetaBlock {
    public final String name;
    protected static IProperty<?>[] tempProperties;
    protected static IUnlistedProperty<?>[] tempUnlistedProperties;
    public final PropertyEnum<E> property;
    public final IProperty<?>[] additionalProperties;
    public final IUnlistedProperty<?>[] additionalUnlistedProperties;
    public final E[] enumValues;
    protected final boolean[] hidden;
    protected final boolean[] fullCubes;
    protected final int[] stackAmounts;
    protected final int[] opaqueness;
    protected final float[] hardness;
    protected final float[] blastResistance;
    protected final String[] description;
    protected final Material[] materials;
    protected final SoundType[] soundTypes;
    protected final HashMap<E, Set<String>> toolTypes;
    protected final HashMap<E, Set<BlockRenderLayer>> renderLayers;
    protected EnumPushReaction[] mobilityFlags;
    @Nullable
    public final ItemBlockIIBase itemBlock;
    public Map<Integer, String> tesrMap = new HashMap<Integer, String>();

    public BlockIIBase(String name, PropertyEnum<E> mainProperty, Material material, Function<BlockIIBase<E>, ItemBlockIIBase> itemBlock, Object ... additionalProperties) {
        super(BlockIIBase.setTempProperties(material, mainProperty, additionalProperties));
        this.name = name;
        this.property = mainProperty;
        this.enumValues = (Enum[])mainProperty.func_177699_b().getEnumConstants();
        ArrayList<IProperty> propList = new ArrayList<IProperty>();
        ArrayList<IUnlistedProperty> unlistedPropList = new ArrayList<IUnlistedProperty>();
        for (Object o : additionalProperties) {
            if (o instanceof IProperty) {
                propList.add((IProperty)o);
            }
            if (o instanceof IProperty[]) {
                Collections.addAll(propList, (IProperty[])o);
            }
            if (o instanceof IUnlistedProperty) {
                unlistedPropList.add((IUnlistedProperty)o);
            }
            if (!(o instanceof IUnlistedProperty[])) continue;
            Collections.addAll(unlistedPropList, (IUnlistedProperty[])o);
        }
        this.additionalProperties = propList.toArray(new IProperty[0]);
        this.additionalUnlistedProperties = unlistedPropList.toArray(new IUnlistedProperty[0]);
        this.func_180632_j(this.getInitDefaultState());
        this.func_149663_c("immersiveintelligence." + name);
        this.func_149647_a(IIContent.II_CREATIVE_TAB);
        int sub = this.enumValues.length;
        this.hidden = new boolean[sub];
        Arrays.fill(this.hidden, false);
        this.fullCubes = new boolean[sub];
        Arrays.fill(this.fullCubes, false);
        this.stackAmounts = new int[sub];
        Arrays.fill(this.stackAmounts, 64);
        this.opaqueness = new int[sub];
        Arrays.fill(this.opaqueness, material.func_76218_k() ? 0 : 255);
        this.blastResistance = new float[sub];
        this.field_149781_w = 2.0f;
        Arrays.fill(this.blastResistance, 2.0f);
        this.hardness = new float[sub];
        this.field_149782_v = 1.0f;
        Arrays.fill(this.hardness, 1.0f);
        this.description = new String[sub];
        Arrays.fill(this.description, "");
        this.materials = new Material[sub];
        Arrays.fill(this.materials, material);
        this.soundTypes = new SoundType[sub];
        this.field_149762_H = this.adjustSound(material);
        Arrays.fill(this.soundTypes, this.field_149762_H);
        this.toolTypes = new HashMap();
        this.renderLayers = new HashMap(sub);
        this.mobilityFlags = new EnumPushReaction[sub];
        Arrays.fill(this.mobilityFlags, EnumPushReaction.NORMAL);
        IIContent.BLOCKS.add(this);
        this.itemBlock = itemBlock.apply(this);
        IIContent.ITEMS.add((Item)this.itemBlock);
        this.field_149786_r = 255;
    }

    public void parseSubBlocks() {
        for (int i = 0; i < this.enumValues.length; ++i) {
            IIBlockInterfaces.IIBlockProperties properties = ((IIBlockInterfaces.IIBlockEnum)this.enumValues[i]).getProperties();
            if (properties == null) continue;
            if (properties.hidden().isSet()) {
                this.hidden[i] = properties.hidden().isTrue();
            }
            if (properties.fullCube().isSet()) {
                this.fullCubes[i] = properties.fullCube().isTrue();
            }
            if (properties.stackSize() != -1) {
                this.stackAmounts[i] = properties.stackSize();
            }
            if (properties.opacity() != -1) {
                this.opaqueness[i] = properties.opacity();
            }
            if (properties.blastResistance() != -1.0f) {
                this.blastResistance[i] = properties.blastResistance();
            }
            if (properties.hardness() != -1.0f) {
                this.hardness[i] = properties.hardness();
            }
            if (properties.descKey().isEmpty()) continue;
            this.description[i] = properties.descKey();
        }
    }

    private SoundType adjustSound(Material material) {
        if (material == Material.field_151574_g) {
            return SoundType.field_185858_k;
        }
        if (material == Material.field_151593_r || material == Material.field_151580_n) {
            return SoundType.field_185854_g;
        }
        if (material == Material.field_151592_s || material == Material.field_151588_w) {
            return SoundType.field_185853_f;
        }
        if (material == Material.field_151577_b || material == Material.field_151584_j || material == Material.field_151590_u || material == Material.field_151585_k || material == Material.field_151582_l) {
            return SoundType.field_185850_c;
        }
        if (material == Material.field_151578_c) {
            return SoundType.field_185849_b;
        }
        if (material == Material.field_151573_f) {
            return SoundType.field_185852_e;
        }
        if (material == Material.field_151595_p) {
            return SoundType.field_185855_h;
        }
        if (material == Material.field_151597_y) {
            return SoundType.field_185856_i;
        }
        if (material == Material.field_151576_e) {
            return SoundType.field_185851_d;
        }
        if (material == Material.field_151575_d || material == Material.field_151570_A) {
            return SoundType.field_185848_a;
        }
        return SoundType.field_185851_d;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Nonnull
    public SoundType getSoundType(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nullable Entity entity) {
        int meta = ((IIBlockInterfaces.IIBlockEnum)((Object)((Enum)((Object)state.func_177229_b(this.property))))).getMeta();
        return this.soundTypes[meta % this.enumValues.length];
    }

    private static Material setTempProperties(Material material, PropertyEnum<?> property, Object ... additionalProperties) {
        ArrayList<Object> propList = new ArrayList<Object>();
        ArrayList<IUnlistedProperty> unlistedPropList = new ArrayList<IUnlistedProperty>();
        propList.add(property);
        for (Object o : additionalProperties) {
            if (o instanceof IProperty) {
                propList.add((IProperty)o);
            }
            if (o instanceof IProperty[]) {
                Collections.addAll(propList, (IProperty[])o);
            }
            if (o instanceof IUnlistedProperty) {
                unlistedPropList.add((IUnlistedProperty)o);
            }
            if (!(o instanceof IUnlistedProperty[])) continue;
            Collections.addAll(unlistedPropList, (IUnlistedProperty[])o);
        }
        tempProperties = propList.toArray(new IProperty[0]);
        tempUnlistedProperties = unlistedPropList.toArray(new IUnlistedProperty[0]);
        return material;
    }

    public void addToTESRMap(E ... id) {
        for (E subBlock : id) {
            this.tesrMap.put(((IIBlockInterfaces.IIBlockEnum)subBlock).getMeta(), ((Enum)subBlock).name());
        }
    }

    @Nonnull
    public String getIEBlockName() {
        return this.name;
    }

    @Nonnull
    public Enum<E>[] getMetaEnums() {
        return this.enumValues;
    }

    @Nonnull
    public IBlockState getInventoryState(int meta) {
        return this.func_176203_a(meta);
    }

    @Nonnull
    public PropertyEnum<E> getMetaProperty() {
        return this.property;
    }

    public boolean useCustomStateMapper() {
        return true;
    }

    @Nullable
    public String getCustomStateMapping(int meta, boolean itemBlock) {
        if (meta > this.enumValues.length - 1) {
            return null;
        }
        IIBlockInterfaces.IIBlockProperties properties = ((IIBlockInterfaces.IIBlockEnum)this.enumValues[meta % this.enumValues.length]).getProperties();
        if (properties != null && properties.needsCustomState()) {
            return ((ISerializableEnum)this.enumValues[meta % this.enumValues.length]).func_176610_l();
        }
        return null;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public StateMapperBase getCustomMapper() {
        return null;
    }

    public boolean appendPropertiesToState() {
        return true;
    }

    public String getTranslationKey(ItemStack stack) {
        return super.func_149739_a() + "." + ((ISerializableEnum)this.enumValues[stack.func_77960_j() % this.enumValues.length]).func_176610_l();
    }

    protected static Object[] combineProperties(Object[] currentProperties, Object ... addedProperties) {
        Object[] array = new Object[currentProperties.length + addedProperties.length];
        System.arraycopy(currentProperties, 0, array, 0, currentProperties.length);
        System.arraycopy(addedProperties, 0, array, currentProperties.length, addedProperties.length);
        return array;
    }

    protected BlockStateContainer createNotTempBlockState() {
        IProperty[] array = new IProperty[1 + this.additionalProperties.length];
        array[0] = this.property;
        System.arraycopy(this.additionalProperties, 0, array, 1, this.additionalProperties.length);
        if (this.additionalUnlistedProperties.length > 0) {
            return new ExtendedBlockState((Block)this, array, this.additionalUnlistedProperties);
        }
        return new BlockStateContainer((Block)this, array);
    }

    protected IBlockState getInitDefaultState() {
        IBlockState state = this.field_176227_L.func_177621_b().func_177226_a(this.property, this.enumValues[0]);
        for (IProperty<?> additionalProperty : this.additionalProperties) {
            if (additionalProperty == null || additionalProperty.func_177700_c().isEmpty()) continue;
            state = this.applyProperty(state, additionalProperty, additionalProperty.func_177700_c().iterator().next());
        }
        return state;
    }

    protected <V extends Comparable<V>> IBlockState applyProperty(IBlockState in, IProperty<V> prop, Object val) {
        return in.func_177226_a(prop, (Comparable)val);
    }

    public void onIEBlockPlacedBy(World world, BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase placer, ItemStack stack) {
    }

    public boolean canIEBlockBePlaced(World world, BlockPos pos, IBlockState newState, EnumFacing side, float hitX, float hitY, float hitZ, EntityPlayer player, ItemStack stack) {
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        if (this.property != null) {
            return this.createNotTempBlockState();
        }
        if (tempUnlistedProperties.length > 0) {
            return new ExtendedBlockState((Block)this, tempProperties, tempUnlistedProperties);
        }
        return new BlockStateContainer((Block)this, tempProperties);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int eventID, int eventParam) {
        if (worldIn.field_72995_K && eventID == 255) {
            worldIn.func_184138_a(pos, state, state, 3);
            return true;
        }
        return super.func_189539_a(state, worldIn, pos, eventID, eventParam);
    }

    public int func_176201_c(@Nullable IBlockState state) {
        if (state == null || this.enumValues == null || !((Object)((Object)this)).equals(state.func_177230_c())) {
            return 0;
        }
        return ((IIBlockInterfaces.IIBlockEnum)((Object)((Enum)((Object)state.func_177229_b(this.property))))).getMeta();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(this.property, this.enumValues[meta % this.enumValues.length]);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (E type : this.enumValues) {
            if (this.hidden[((IIBlockInterfaces.IIBlockEnum)type).getMeta()]) continue;
            list.add((Object)new ItemStack((Block)this, 1, ((IIBlockInterfaces.IIBlockEnum)type).getMeta()));
        }
    }

    public BlockIIBase<E> setSubMaterial(E subBlock, Material material) {
        this.materials[((IIBlockInterfaces.IIBlockEnum)subBlock).getMeta()] = material;
        this.soundTypes[((IIBlockInterfaces.IIBlockEnum)subBlock).getMeta()] = this.adjustSound(material);
        return this;
    }

    public BlockIIBase<E> setBlockLayer(BlockRenderLayer ... layer) {
        for (E subBlock : this.enumValues) {
            this.renderLayers.put(subBlock, new HashSet<BlockRenderLayer>(Arrays.asList(layer)));
        }
        return this;
    }

    public BlockIIBase<E> setSubBlockLayer(E subBlock, BlockRenderLayer ... layer) {
        this.renderLayers.put(subBlock, new HashSet<BlockRenderLayer>(Arrays.asList(layer)));
        return this;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        Enum subBlock = (Enum)((Object)state.func_177229_b(this.property));
        if (this.renderLayers.containsKey(subBlock)) {
            return this.renderLayers.get(subBlock).contains(layer);
        }
        return layer == BlockRenderLayer.SOLID;
    }

    public BlockIIBase<E> setLightOpacity(int opacity) {
        this.field_149786_r = opacity;
        Arrays.fill(this.opaqueness, this.field_149786_r);
        return this;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (this.enumValues == null || !((Object)((Object)this)).equals(state.func_177230_c())) {
            return 0;
        }
        int meta = ((IIBlockInterfaces.IIBlockEnum)((Object)((Enum)((Object)state.func_177229_b(this.property))))).getMeta();
        return this.opaqueness[meta % this.enumValues.length];
    }

    public Block func_149711_c(float hardness) {
        this.field_149782_v = hardness;
        Arrays.fill(this.hardness, this.field_149782_v);
        return this;
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        if (this.enumValues == null || !((Object)((Object)this)).equals(state.func_177230_c())) {
            return 0.0f;
        }
        int meta = ((IIBlockInterfaces.IIBlockEnum)((Object)((Enum)((Object)state.func_177229_b(this.property))))).getMeta();
        return this.hardness[meta % this.enumValues.length];
    }

    public Block func_149752_b(float resistance) {
        this.field_149781_w = resistance;
        Arrays.fill(this.blastResistance, this.field_149781_w);
        return this;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        int meta = this.func_176201_c(world.func_180495_p(pos));
        return this.blastResistance[meta % this.enumValues.length];
    }

    public BlockIIBase<E> setMetaMobilityFlag(E subType, EnumPushReaction flag) {
        this.mobilityFlags[((Enum)subType).ordinal()] = flag;
        return this;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        int meta = ((IIBlockInterfaces.IIBlockEnum)((Object)((Enum)((Object)state.func_177229_b(this.property))))).getMeta();
        if (this.mobilityFlags[meta % this.enumValues.length] == null) {
            return EnumPushReaction.NORMAL;
        }
        return this.mobilityFlags[meta % this.enumValues.length];
    }

    public final BlockIIBase<E> setFullCube(boolean fullCube) {
        this.field_149787_q = fullCube;
        Arrays.fill(this.fullCubes, fullCube);
        return this;
    }

    protected boolean normalBlockCheck(@Nonnull IBlockState state) {
        if (this.enumValues == null || !((Object)((Object)this)).equals(state.func_177230_c())) {
            return true;
        }
        int meta = ((IIBlockInterfaces.IIBlockEnum)((Object)((Enum)((Object)state.func_177229_b(this.property))))).getMeta();
        return this.fullCubes[meta % this.enumValues.length];
    }

    public boolean func_149637_q(@Nonnull IBlockState state) {
        return this.normalBlockCheck(state);
    }

    public boolean func_149721_r(@Nonnull IBlockState state) {
        return this.normalBlockCheck(state);
    }

    public boolean func_149730_j(@Nonnull IBlockState state) {
        return this.normalBlockCheck(state);
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return this.normalBlockCheck(state);
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        if (this.enumValues == null || !((Object)((Object)this)).equals(state.func_177230_c())) {
            return true;
        }
        return this.normalBlockCheck(state);
    }

    public boolean isNormalCube(@Nonnull IBlockState state, @Nullable IBlockAccess world, @Nullable BlockPos pos) {
        return this.normalBlockCheck(state);
    }

    public void setToolTypes(String ... toolTypes) {
        for (E subBlock : this.enumValues) {
            this.toolTypes.put(subBlock, new HashSet<String>(Arrays.asList(toolTypes)));
        }
    }

    public boolean isToolEffective(@Nonnull String type, @Nonnull IBlockState state) {
        Enum subBlock = (Enum)((Object)state.func_177229_b(this.property));
        if (this.toolTypes.containsKey(subBlock)) {
            return this.toolTypes.get(subBlock).contains(type);
        }
        return super.isToolEffective(type, state);
    }

    public ItemStack getStack(E subBlock) {
        return this.getStack(subBlock, 1);
    }

    public ItemStack getStack(E subBlock, int amount) {
        return new ItemStack((Block)this, amount, ((Enum)subBlock).ordinal());
    }

    public IngredientStack getIngredientStack(E subBlock, int amount) {
        return new IngredientStack(this.getStack(subBlock, amount));
    }
}

