/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.util.block;

import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import pl.pabilo8.immersiveintelligence.api.CorrosionHandler;
import pl.pabilo8.immersiveintelligence.common.IIContent;

public class BlockIIFluid
extends BlockFluidClassic {
    private int flammability = 0;
    private int fireSpread = 0;
    public boolean isAcid;
    private PotionEffect[] potionEffects;

    public BlockIIFluid(String name, Fluid fluid, Material material) {
        super(fluid, material);
        this.func_149663_c("immersiveintelligence." + name);
        this.func_149647_a(IIContent.II_CREATIVE_TAB);
        IIContent.BLOCKS.add((Block)this);
        this.isAcid = name.endsWith("acid");
    }

    public BlockIIFluid setFlammability(int flammability, int fireSpread) {
        this.flammability = flammability;
        this.fireSpread = fireSpread;
        return this;
    }

    public BlockIIFluid setPotionEffects(PotionEffect ... potionEffects) {
        this.potionEffects = potionEffects;
        return this;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.flammability;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.fireSpread;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.flammability > 0;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (this.potionEffects != null && entity instanceof EntityLivingBase) {
            for (PotionEffect effect : this.potionEffects) {
                if (effect == null) continue;
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(effect));
            }
            if (this.isAcid) {
                for (ItemStack stack1 : entity.func_184193_aE()) {
                    if (stack1.func_77973_b() instanceof CorrosionHandler.IAcidProtectionEquipment && ((CorrosionHandler.IAcidProtectionEquipment)stack1.func_77973_b()).protectsFromAcid(stack1)) continue;
                    entity.func_70097_a(IEDamageSources.acid, 2.0f);
                    break;
                }
            }
        }
    }

    public void addToChemthrower() {
        if (this.potionEffects != null) {
            ChemthrowerHandler.registerEffect((Fluid)this.definedFluid, (ChemthrowerHandler.ChemthrowerEffect)(this.isAcid ? new ChemthrowerEffect_Acid(this.potionEffects) : new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, this.potionEffects)));
        }
        if (this.flammability > 0) {
            ChemthrowerHandler.registerFlammable((Fluid)this.definedFluid);
        }
    }

    public static class ChemthrowerEffect_Acid
    extends ChemthrowerHandler.ChemthrowerEffect_Potion {
        public ChemthrowerEffect_Acid(PotionEffect ... effects) {
            super(IEDamageSources.acid, 2.0f, effects);
        }

        public void applyToEntity(EntityLivingBase target, @Nullable EntityPlayer shooter, ItemStack thrower, Fluid fluid) {
            for (ItemStack stack1 : target.func_184193_aE()) {
                if (stack1.func_77973_b() instanceof CorrosionHandler.IAcidProtectionEquipment && ((CorrosionHandler.IAcidProtectionEquipment)stack1.func_77973_b()).protectsFromAcid(stack1)) continue;
                super.applyToEntity(target, shooter, thrower, fluid);
                return;
            }
        }
    }
}

