/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.util.block;

import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.common.blocks.BlockIEBase;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.util.ISerializableEnum;

public class IIBlockInterfaces {

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface EnumMultiblockProvider {
        public Class<? extends TileEntity> tile();

        public Class<? extends MultiblockHandler.IMultiblock> multiblock();
    }

    public static interface IITileMultiblockEnum
    extends IITileProviderEnum {
        @Override
        @Nullable
        default public Class<? extends TileEntity> getTile() {
            EnumMultiblockProvider tp = IIUtils.getEnumAnnotation(EnumMultiblockProvider.class, this);
            return tp == null ? null : tp.tile();
        }

        @Nullable
        default public Class<? extends MultiblockHandler.IMultiblock> getMultiblock() {
            EnumMultiblockProvider tp = IIUtils.getEnumAnnotation(EnumMultiblockProvider.class, this);
            return tp == null ? null : tp.multiblock();
        }

        @Override
        default public boolean listForCreative() {
            return false;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface EnumTileProvider {
        public Class<? extends TileEntity> tile();
    }

    public static interface IITileProviderEnum
    extends IIBlockEnum {
        default public Class<? extends TileEntity> getTile() {
            EnumTileProvider tp = IIUtils.getEnumAnnotation(EnumTileProvider.class, this);
            return tp == null ? null : tp.tile();
        }
    }

    public static enum TernaryValue {
        UNSET,
        TRUE,
        FALSE;


        boolean isTrue() {
            return this != FALSE;
        }

        public boolean isSet() {
            return this != UNSET;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface IIBlockProperties {
        public boolean needsCustomState() default false;

        public TernaryValue hidden() default TernaryValue.UNSET;

        public TernaryValue fullCube() default TernaryValue.UNSET;

        public int stackSize() default -1;

        public String[] oreDict() default {};

        public int opacity() default -1;

        public float hardness() default -1.0f;

        public float blastResistance() default -1.0f;

        public String[] harvestTools() default {};

        public String descKey() default "";

        public int harvestLevel() default -1;

        public BlockRenderLayer[] renderLayer() default {};
    }

    public static interface IIBlockEnum
    extends BlockIEBase.IBlockEnum,
    ISerializableEnum {
        default public int getMeta() {
            return ((Enum)((Object)this)).ordinal();
        }

        @Nullable
        default public IIBlockProperties getProperties() {
            return IIUtils.getEnumAnnotation(IIBlockProperties.class, this);
        }

        default public boolean listForCreative() {
            IIBlockProperties properties = this.getProperties();
            return properties == null || properties.hidden() != TernaryValue.TRUE;
        }
    }
}

