/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.util.block;

import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.client.IIClientUtils;
import pl.pabilo8.immersiveintelligence.common.util.block.BlockIIBase;

public class ItemBlockIIBase
extends ItemBlock {
    protected final BlockIIBase<?> field_150939_a;

    public ItemBlockIIBase(BlockIIBase block) {
        super((Block)block);
        this.field_150939_a = block;
        this.func_77627_a(true);
    }

    public int func_77647_b(int damageValue) {
        return damageValue;
    }

    public void func_150895_a(@Nullable CreativeTabs tab, @Nonnull NonNullList<ItemStack> itemList) {
        if (this.func_194125_a(tab)) {
            this.field_150939_a.func_149666_a(tab, itemList);
        }
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        return this.field_150939_a.getTranslationKey(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return IIClientUtils.fontRegular;
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag tooltipFlag) {
        FluidStack fs;
        if (!this.field_150939_a.description[stack.func_77960_j()].isEmpty()) {
            tooltip.add(TextFormatting.GRAY + this.field_150939_a.description[stack.func_77960_j()]);
        }
        super.func_77624_a(stack, world, tooltip, tooltipFlag);
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"energyStorage")) {
            tooltip.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.energyStored", (Object[])new Object[]{TextFormatting.GOLD.toString() + ItemNBTHelper.getInt((ItemStack)stack, (String)"energyStorage") + TextFormatting.RESET}));
        }
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"tank") && (fs = FluidStack.loadFluidStackFromNBT((NBTTagCompound)ItemNBTHelper.getTagCompound((ItemStack)stack, (String)"tank"))) != null) {
            tooltip.add(fs.getLocalizedName() + ": " + fs.amount + "mB");
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!this.field_150939_a.canIEBlockBePlaced(world, pos, newState, side, hitX, hitY, hitZ, player, stack)) {
            return false;
        }
        boolean ret = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
        if (ret) {
            this.field_150939_a.onIEBlockPlacedBy(world, pos, newState, side, hitX, hitY, hitZ, (EntityLivingBase)player, stack);
        }
        return ret;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (!block.func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177972_a(side);
        }
        if (stack.func_190916_E() > 0 && player.func_175151_a(pos, side, stack) && this.canBlockBePlaced(world, pos, side, stack)) {
            int i = this.func_77647_b(stack.func_77960_j());
            IBlockState iblockstate1 = this.field_150939_a.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, i, (EntityLivingBase)player, hand);
            if (this.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, iblockstate1)) {
                SoundType soundtype = world.func_180495_p(pos).func_177230_c().getSoundType(world.func_180495_p(pos), world, pos, (Entity)player);
                world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public boolean func_179222_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing side, @Nullable EntityPlayer player, @Nonnull ItemStack stack) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        if (block == Blocks.field_150431_aC && block.func_176200_f((IBlockAccess)worldIn, pos)) {
            side = EnumFacing.UP;
        } else if (!block.func_176200_f((IBlockAccess)worldIn, pos)) {
            pos = pos.func_177972_a(side);
        }
        return this.canBlockBePlaced(worldIn, pos, side, stack);
    }

    private boolean canBlockBePlaced(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, @Nonnull ItemStack stack) {
        Block block = world.func_180495_p(pos).func_177230_c();
        AxisAlignedBB axisalignedbb = this.field_150939_a.func_180646_a(this.field_150939_a.func_176203_a(stack.func_77952_i()), (IBlockAccess)world, pos);
        if (axisalignedbb != null && !world.func_72917_a(axisalignedbb.func_186670_a(pos), null)) {
            return false;
        }
        return block.func_176200_f((IBlockAccess)world, pos) && this.field_150939_a.func_176198_a(world, pos, side);
    }
}

