/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.util.easynbt;

import blusunrize.immersiveengineering.api.DimensionBlockPos;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.util.Constants;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import pl.pabilo8.immersiveintelligence.common.IILogger;
import pl.pabilo8.immersiveintelligence.common.util.ISerializableEnum;

public class EasyNBT
extends Constants.NBT {
    private final NBTTagCompound wrapped;

    private EasyNBT(NBTTagCompound wrapped) {
        this.wrapped = wrapped;
    }

    public static EasyNBT newNBT() {
        return new EasyNBT(new NBTTagCompound());
    }

    public static EasyNBT wrapNBT(NBTTagCompound nbt) {
        return new EasyNBT(nbt);
    }

    public static EasyNBT wrapNBT(ItemStack nbt) {
        return new EasyNBT(ItemNBTHelper.getTag((ItemStack)nbt));
    }

    public static EasyNBT parseEasyNBT(String format, Object ... arguments) {
        return new EasyNBT(EasyNBT.parseNBT(format, arguments));
    }

    public EasyNBT withInt(String key, int value) {
        this.wrapped.func_74768_a(key, value);
        return this;
    }

    public EasyNBT withByte(String key, int value) {
        this.wrapped.func_74768_a(key, value);
        return this;
    }

    public EasyNBT withFloat(String key, float value) {
        this.wrapped.func_74776_a(key, value);
        return this;
    }

    public EasyNBT withDouble(String key, double value) {
        this.wrapped.func_74780_a(key, value);
        return this;
    }

    public EasyNBT withBoolean(String key, boolean value) {
        this.wrapped.func_74757_a(key, value);
        return this;
    }

    public EasyNBT withString(String key, String value) {
        this.wrapped.func_74778_a(key, value);
        return this;
    }

    public <E extends Enum<E>> EasyNBT withEnum(String key, E value) {
        this.wrapped.func_74778_a(key, ((ISerializableEnum)((Object)value)).func_176610_l());
        return this;
    }

    public EasyNBT withList(String key, Object ... value) {
        this.wrapped.func_74782_a(key, (NBTBase)EasyNBT.listOf(value));
        return this;
    }

    public EasyNBT withIntArray(String key, int ... value) {
        this.wrapped.func_74783_a(key, value);
        return this;
    }

    public EasyNBT withTag(String key, NBTBase value) {
        this.wrapped.func_74782_a(key, value);
        return this;
    }

    public EasyNBT withTag(String key, EasyNBT value) {
        this.wrapped.func_74782_a(key, (NBTBase)value.unwrap());
        return this;
    }

    public EasyNBT withTag(String key, Consumer<NBTTagCompound> accepted) {
        NBTTagCompound tag = new NBTTagCompound();
        accepted.accept(tag);
        this.wrapped.func_74782_a(key, (NBTBase)tag);
        return this;
    }

    public EasyNBT withPos(String key, BlockPos value) {
        return this.withIntArray(key, value.func_177958_n(), value.func_177956_o(), value.func_177952_p());
    }

    public EasyNBT withDimPos(String key, DimensionBlockPos value) {
        return this.withIntArray(key, value.func_177958_n(), value.func_177956_o(), value.func_177952_p(), value.dimension);
    }

    public EasyNBT withVec3d(String key, Vec3d value) {
        return this.withList(key, value.field_72450_a, value.field_72448_b, value.field_72449_c);
    }

    public EasyNBT withItemStack(String key, ItemStack value) {
        return this.withTag(key, (NBTBase)value.serializeNBT());
    }

    public EasyNBT withFluidStack(String key, FluidStack value) {
        return this.withTag(key, (NBTBase)value.writeToNBT(new NBTTagCompound()));
    }

    public EasyNBT without(String key) {
        this.wrapped.func_82580_o(key);
        return this;
    }

    public EasyNBT conditionally(boolean condition, Consumer<EasyNBT> whenTrue) {
        if (condition) {
            whenTrue.accept(this);
        }
        return this;
    }

    public EasyNBT accept(Consumer<NBTTagCompound> accepted) {
        accepted.accept(this.wrapped);
        return this;
    }

    public EasyNBT mergeWith(@Nullable NBTTagCompound other) {
        if (other != null) {
            this.wrapped.func_179237_a(other);
        }
        return this;
    }

    public EasyNBT mergeWith(@Nullable EasyNBT other) {
        if (other != null) {
            this.wrapped.func_179237_a(other.wrapped);
        }
        return this;
    }

    public boolean hasKey(String key) {
        return this.wrapped.func_74764_b(key);
    }

    public boolean hasKey(IStringSerializable key) {
        return this.wrapped.func_74764_b(key.func_176610_l());
    }

    public boolean hasKey(String key, int type) {
        return this.wrapped.func_74764_b(key) && this.wrapped.func_74781_a(key).func_74732_a() == type;
    }

    public int getInt(String key) {
        return this.wrapped.func_74762_e(key);
    }

    public byte getByte(String key) {
        return this.wrapped.func_74771_c(key);
    }

    public float getFloat(String key) {
        return this.wrapped.func_74760_g(key);
    }

    public double getDouble(String key) {
        return this.wrapped.func_74769_h(key);
    }

    public boolean getBoolean(String key) {
        return this.wrapped.func_74767_n(key);
    }

    public String getString(String key) {
        return this.wrapped.func_74779_i(key);
    }

    public NBTTagList getList(String key, int type) {
        return this.wrapped.func_150295_c(key, type);
    }

    public <T extends NBTBase> Stream<T> streamList(Class<T> clazz, String key, int type) {
        return this.wrapped.func_150295_c((String)key, (int)type).field_74747_a.stream().map(n -> n);
    }

    public <T extends NBTBase> Stream<T> streamList(Class<T> clazz, String key) {
        return this.streamList(clazz, key, this.getTagIDByClass(clazz));
    }

    public int[] getIntArray(String key) {
        return this.wrapped.func_74759_k(key);
    }

    public NBTTagCompound getCompound(String key) {
        return this.wrapped.func_74775_l(key);
    }

    public EasyNBT getEasyCompound(String key) {
        return new EasyNBT(this.wrapped.func_74775_l(key));
    }

    public BlockPos getPos(String key) {
        int[] pos = this.getIntArray(key);
        if (pos.length > 2) {
            return new BlockPos(pos[0], pos[1], pos[2]);
        }
        if (this.wrapped.func_74764_b(key)) {
            IILogger.error("Malformed BlockPos tag for \"" + key + "\" in" + Arrays.toString(new Throwable().getStackTrace()));
        }
        return BlockPos.field_177992_a;
    }

    public DimensionBlockPos getDimPos(String key) {
        int[] pos = this.getIntArray(key);
        if (pos.length > 3) {
            return new DimensionBlockPos(pos[0], pos[1], pos[2], pos[3]);
        }
        if (this.wrapped.func_74764_b(key)) {
            IILogger.error("Malformed DimensionBlockPos tag for \"" + key + "\" in" + Arrays.toString(new Throwable().getStackTrace()));
        }
        return new DimensionBlockPos(BlockPos.field_177992_a, 0);
    }

    public Vec3d getVec3d(String key) {
        NBTTagList pos = this.getList(key, 6);
        if (pos.func_74745_c() > 2) {
            NBTTagDouble x = (NBTTagDouble)pos.func_179238_g(0);
            NBTTagDouble y = (NBTTagDouble)pos.func_179238_g(1);
            NBTTagDouble z = (NBTTagDouble)pos.func_179238_g(2);
            return new Vec3d(x.func_150286_g(), y.func_150286_g(), z.func_150286_g());
        }
        if (this.wrapped.func_74764_b(key)) {
            IILogger.error("Malformed Vec3D tag for \"" + key + "\" in" + Arrays.toString(new Throwable().getStackTrace()));
        }
        return Vec3d.field_186680_a;
    }

    public ItemStack getItemStack(String key) {
        return new ItemStack(this.getCompound(key));
    }

    public FluidStack getFluidStack(String key) {
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)this.getCompound(key));
    }

    public void checkSetInt(String key, Consumer<Integer> ifPresent, int ifNot) {
        if (this.wrapped.func_74764_b(key)) {
            ifPresent.accept(this.wrapped.func_74762_e(key));
        } else {
            ifPresent.accept(ifNot);
        }
    }

    public void checkSetInt(String key, Consumer<Integer> ifPresent) {
        if (this.wrapped.func_74764_b(key)) {
            ifPresent.accept(this.wrapped.func_74762_e(key));
        }
    }

    public void checkSetByte(String key, Consumer<Byte> ifPresent, byte ifNot) {
        if (this.wrapped.func_74764_b(key)) {
            ifPresent.accept(this.wrapped.func_74771_c(key));
        } else {
            ifPresent.accept(ifNot);
        }
    }

    public void checkSetByte(String key, Consumer<Byte> ifPresent) {
        if (this.wrapped.func_74764_b(key)) {
            ifPresent.accept(this.wrapped.func_74771_c(key));
        }
    }

    public void checkSetFloat(String key, Consumer<Float> ifPresent, float ifNot) {
        if (this.wrapped.func_74764_b(key)) {
            ifPresent.accept(Float.valueOf(this.wrapped.func_74760_g(key)));
        } else {
            ifPresent.accept(Float.valueOf(ifNot));
        }
    }

    public void checkSetFloat(String key, Consumer<Float> ifPresent) {
        if (this.wrapped.func_74764_b(key)) {
            ifPresent.accept(Float.valueOf(this.wrapped.func_74760_g(key)));
        }
    }

    public void checkSetDouble(String key, Consumer<Double> ifPresent, double ifNot) {
        if (this.wrapped.func_74764_b(key)) {
            ifPresent.accept(this.wrapped.func_74769_h(key));
        } else {
            ifPresent.accept(ifNot);
        }
    }

    public void checkSetDouble(String key, Consumer<Double> ifPresent) {
        if (this.wrapped.func_74764_b(key)) {
            ifPresent.accept(this.wrapped.func_74769_h(key));
        }
    }

    public void checkSetBoolean(String key, Consumer<Boolean> ifPresent, boolean ifNot) {
        if (this.wrapped.func_74764_b(key)) {
            ifPresent.accept(this.wrapped.func_74767_n(key));
        } else {
            ifPresent.accept(ifNot);
        }
    }

    public void checkSetBoolean(String key, Consumer<Boolean> ifPresent) {
        if (this.wrapped.func_74764_b(key)) {
            ifPresent.accept(this.wrapped.func_74767_n(key));
        }
    }

    public void checkSetString(String key, Consumer<String> ifPresent, String ifNot) {
        if (this.wrapped.func_74764_b(key)) {
            ifPresent.accept(this.wrapped.func_74779_i(key));
        } else {
            ifPresent.accept(ifNot);
        }
    }

    public void checkSetString(String key, Consumer<String> ifPresent) {
        if (this.wrapped.func_74764_b(key)) {
            ifPresent.accept(this.wrapped.func_74779_i(key));
        }
    }

    public void checkSetCompound(String key, Consumer<NBTTagCompound> ifPresent, NBTTagCompound ifNot) {
        if (this.wrapped.func_74764_b(key)) {
            ifPresent.accept(this.wrapped.func_74775_l(key));
        } else {
            ifPresent.accept(ifNot);
        }
    }

    public void checkSetCompound(String key, Consumer<NBTTagCompound> ifPresent) {
        if (this.wrapped.func_74764_b(key)) {
            ifPresent.accept(this.wrapped.func_74775_l(key));
        }
    }

    public <T extends NBTBase> void checkSetTag(String key, Class<T> clazz, Consumer<T> ifPresent) {
        NBTBase tag;
        if (this.wrapped.func_74764_b(key) && clazz.isInstance(tag = this.wrapped.func_74781_a(key))) {
            ifPresent.accept(clazz.cast(tag));
        }
    }

    public int size() {
        return this.wrapped.func_186856_d();
    }

    public boolean isEmpty() {
        return this.wrapped.func_82582_d();
    }

    public boolean containsKey(Object key) {
        return key instanceof String && this.wrapped.func_74764_b((String)key);
    }

    public NBTTagCompound unwrap() {
        return this.wrapped;
    }

    public Map<String, NBTBase> asMap() {
        return (Map)ReflectionHelper.getPrivateValue(NBTTagCompound.class, (Object)this.wrapped.func_74737_b(), (String[])new String[]{"tagMap"});
    }

    public String toString() {
        return this.wrapped.toString();
    }

    public static NBTTagCompound parseNBT(String format, Object ... arguments) {
        String json = String.format(format, arguments);
        try {
            return JsonToNBT.func_180713_a((String)json);
        }
        catch (NBTException ignored) {
            return new NBTTagCompound();
        }
    }

    public <T extends NBTBase> byte getTagIDByClass(Class<T> clazz) {
        try {
            return ((NBTBase)clazz.newInstance()).func_74732_a();
        }
        catch (IllegalAccessException | InstantiationException ignored) {
            return 0;
        }
    }

    public static NBTTagList listOf(Object ... elements) {
        NBTTagList list = new NBTTagList();
        if (elements.length == 0) {
            return list;
        }
        for (Object element : elements) {
            DimensionBlockPos pos;
            if (element instanceof NBTBase) {
                list.func_74742_a((NBTBase)element);
                continue;
            }
            if (element instanceof Integer) {
                list.func_74742_a((NBTBase)new NBTTagInt(((Integer)element).intValue()));
                continue;
            }
            if (element instanceof Float) {
                list.func_74742_a((NBTBase)new NBTTagFloat(((Float)element).floatValue()));
                continue;
            }
            if (element instanceof Double) {
                list.func_74742_a((NBTBase)new NBTTagDouble(((Double)element).doubleValue()));
                continue;
            }
            if (element instanceof Boolean) {
                list.func_74742_a((NBTBase)new NBTTagByte((byte)((Boolean)element != false ? 1 : 0)));
                continue;
            }
            if (element instanceof EasyNBT) {
                list.func_74742_a((NBTBase)((EasyNBT)((Object)element)).wrapped);
                continue;
            }
            if (element instanceof DimensionBlockPos) {
                pos = (DimensionBlockPos)element;
                list.func_74742_a((NBTBase)EasyNBT.listOf(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), pos.dimension));
                continue;
            }
            if (element instanceof BlockPos) {
                pos = (BlockPos)element;
                list.func_74742_a((NBTBase)EasyNBT.listOf(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
                continue;
            }
            if (element instanceof Vec3d) {
                pos = (Vec3d)element;
                list.func_74742_a((NBTBase)EasyNBT.listOf(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c));
                continue;
            }
            if (element instanceof ItemStack) {
                list.func_74742_a((NBTBase)((ItemStack)element).serializeNBT());
                continue;
            }
            if (element instanceof FluidStack) {
                list.func_74742_a((NBTBase)((FluidStack)element).writeToNBT(new NBTTagCompound()));
                continue;
            }
            if (element instanceof Object[]) {
                list.func_74742_a((NBTBase)EasyNBT.listOf(element));
                continue;
            }
            if (!(element instanceof Collection)) continue;
            list.func_74742_a((NBTBase)EasyNBT.listOf(((Collection)element).toArray(new Object[0])));
        }
        return list;
    }

    public static NBTTagIntArray intArrayOf(int ... ints) {
        return new NBTTagIntArray(ints);
    }
}

