/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.util.item;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.util.ISerializableEnum;

public interface IIItemEnum
extends ISerializableEnum {
    default public int getMeta() {
        return ((Enum)((Object)this)).ordinal();
    }

    default public boolean isHidden() {
        IIItemProperties tp = this.getProperties();
        return tp != null && tp.hidden();
    }

    default public int getStackSize() {
        IIItemProperties tp = this.getProperties();
        if (tp != null) {
            return tp.stackSize();
        }
        return -1;
    }

    @Nonnull
    default public String[] getOreDict() {
        IIItemProperties tp = this.getProperties();
        if (tp != null) {
            return tp.oreDict();
        }
        return new String[0];
    }

    @Nullable
    default public IIItemProperties getProperties() {
        return IIUtils.getEnumAnnotation(IIItemProperties.class, this);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface IIItemProperties {
        public boolean hidden() default false;

        public String[] oreDict() default {};

        public int stackSize() default -1;
    }
}

