/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.util.item;

import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import pl.pabilo8.immersiveintelligence.common.util.ISerializableEnum;
import pl.pabilo8.immersiveintelligence.common.util.item.IIItemEnum;
import pl.pabilo8.immersiveintelligence.common.util.item.ItemIIBase;

public class ItemIISubItemsBase<E extends Enum<E>>
extends ItemIIBase {
    private E[] subItems;
    private String[] subNames;
    private int[] subMaxAmounts;
    private boolean[] isMetaHidden;

    public ItemIISubItemsBase(String name, int stackSize, @Nonnull E[] subItems) {
        super(name, stackSize);
        this.field_77787_bX = true;
        this.updateValues((Enum[])subItems);
    }

    public final void updateValues(@Nonnull E[] subItems) {
        this.subItems = subItems;
        this.subNames = (String[])Arrays.stream(subItems).map(e -> (IIItemEnum)((Object)e)).map(ISerializableEnum::func_176610_l).toArray(String[]::new);
        this.isMetaHidden = new boolean[this.subNames.length];
        for (E subItem : subItems) {
            if (!((IIItemEnum)subItem).isHidden()) continue;
            this.isMetaHidden[((IIItemEnum)subItem).getMeta()] = true;
        }
        this.subMaxAmounts = ArrayUtils.toPrimitive((Integer[])((Integer[])Arrays.stream(subItems).map(e -> (IIItemEnum)((Object)e)).map(IIItemEnum::getStackSize).map(i -> i == -1 ? this.field_77777_bU : i).toArray(Integer[]::new)));
    }

    public Item func_77625_d(int maxStackSize) {
        super.func_77625_d(maxStackSize);
        if (this.subItems != null) {
            this.updateValues((Enum[])this.subItems);
        }
        return this;
    }

    public E[] getSubItems() {
        return this.subItems;
    }

    public String[] getSubNames() {
        return this.subNames;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nullable CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            if (this.subItems != null) {
                for (int i = 0; i < this.subItems.length; ++i) {
                    if (this.isMetaHidden(i)) continue;
                    list.add((Object)new ItemStack((Item)this, 1, i));
                }
            } else {
                list.add((Object)new ItemStack((Item)this));
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        String subName = stack.func_77960_j() < this.getSubNames().length ? this.getSubNames()[stack.func_77960_j()] : "";
        return this.func_77658_a() + "." + subName;
    }

    public ItemIISubItemsBase<E> setMetaUnhidden(E ... meta) {
        for (E subItem : meta) {
            this.isMetaHidden[((Enum)subItem).ordinal()] = false;
        }
        return this;
    }

    public boolean isMetaHidden(int meta) {
        return this.isMetaHidden[Math.max(0, Math.min(meta, this.isMetaHidden.length - 1))];
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.subMaxAmounts[MathHelper.func_76125_a((int)stack.func_77960_j(), (int)0, (int)(this.subItems.length - 1))];
    }

    public E stackToSub(ItemStack stack) {
        return this.subItems[MathHelper.func_76125_a((int)stack.func_77960_j(), (int)0, (int)(this.subItems.length - 1))];
    }

    public E nameToSub(String name) {
        int subNamesLength = this.subNames.length;
        for (int i = 0; i < subNamesLength; ++i) {
            if (!this.subNames[i].equals(name)) continue;
            return this.subItems[i];
        }
        return this.subItems[0];
    }

    public ItemStack getStack(E subItem) {
        return new ItemStack((Item)this, 1, ((Enum)subItem).ordinal());
    }

    public ComparableItemStack getComparableStack(E subItem) {
        return new ComparableItemStack(this.getStack(subItem));
    }

    public ItemStack getStack(E subItem, int amount) {
        return new ItemStack((Item)this, amount, ((Enum)subItem).ordinal());
    }

    public IngredientStack getIngredientStack(E subItem, int amount) {
        return new IngredientStack(this.getStack(subItem, amount));
    }
}

