/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.util.multiblock;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.util.block.BlockIITileProvider;
import pl.pabilo8.immersiveintelligence.common.util.block.IIBlockInterfaces;
import pl.pabilo8.immersiveintelligence.common.util.block.ItemBlockIIBase;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.IIMultiblockInterfaces;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.TileEntityMultiblockIIConnectable;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.util.MultiblockPOI;

public abstract class BlockIIMultiblock<E extends Enum<E>>
extends BlockIITileProvider<E> {
    public BlockIIMultiblock(String name, Material material, PropertyEnum<E> mainProperty, Object ... additionalProperties) {
        super(name, material, mainProperty, ItemBlockIIBase::new, BlockIIMultiblock.combineProperties(additionalProperties, IEProperties.FACING_HORIZONTAL, IEProperties.MULTIBLOCKSLAVE));
        for (Enum v : this.enumValues) {
            Class<? extends MultiblockHandler.IMultiblock> mb = ((IIBlockInterfaces.IITileMultiblockEnum)((Object)v)).getMultiblock();
            if (mb == null) continue;
            try {
                IIContent.MULTIBLOCKS.add(mb.newInstance());
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                // empty catch block
            }
        }
        Arrays.fill(this.hidden, true);
        this.setLightOpacity(0);
        this.setFullCube(false);
        this.setBlockLayer(BlockRenderLayer.CUTOUT);
        this.setToolTypes("IE_HAMMER");
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = super.func_176221_a(state, world, pos);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityMultiblockIIConnectable) {
            state = this.applyProperty(state, IEProperties.BOOLEANS[1], ((TileEntityMultiblockIIConnectable)tile).isPOI(MultiblockPOI.WIRE_MOUNT));
        }
        return state;
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityMultiblockPart && world.func_82736_K().func_82766_b("doTileDrops")) {
            IIEInventory master;
            TileEntityMultiblockPart tile = (TileEntityMultiblockPart)tileEntity;
            if (!tile.formed && tile.field_174879_c == -1 && !tile.getOriginalBlock().func_190926_b()) {
                world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, tile.getOriginalBlock().func_77946_l()));
            }
            if (tile.formed && tile instanceof IIEInventory && (master = (IIEInventory)tile.master()) != null && (!(master instanceof IEBlockInterfaces.ITileDrop) || !((IEBlockInterfaces.ITileDrop)master).preventInventoryDrop()) && master.getDroppedItems() != null) {
                for (ItemStack s : master.getDroppedItems()) {
                    if (s.func_190926_b()) continue;
                    world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, s.func_77946_l()));
                }
            }
        }
        if (tileEntity instanceof TileEntityMultiblockPart) {
            ((TileEntityMultiblockPart)tileEntity).disassemble();
        }
        super.func_180663_b(world, pos, state);
    }

    @Override
    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        int meta = this.func_176201_c(state);
        if (meta >= 0 && meta < this.enumValues.length) {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    @Override
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack stack = this.getOriginalBlock(world, pos);
        if (!stack.func_190926_b()) {
            return stack;
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public ItemStack getOriginalBlock(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityMultiblockPart) {
            return ((TileEntityMultiblockPart)te).getOriginalBlock();
        }
        return ItemStack.field_190927_a;
    }

    public boolean isLadder(@Nonnull IBlockState state, IBlockAccess world, @Nonnull BlockPos pos, @Nullable EntityLivingBase entity) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof IIMultiblockInterfaces.ILadderMultiblock && ((IIMultiblockInterfaces.ILadderMultiblock)te).isLadder();
    }

    @Override
    public float getExplosionResistance(World world, @Nonnull BlockPos pos, Entity exploder, @Nonnull Explosion explosion) {
        float v;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IIMultiblockInterfaces.IExplosionResistantMultiblock && (v = ((IIMultiblockInterfaces.IExplosionResistantMultiblock)te).getExplosionResistance()) != -1.0f) {
            return v / 5.0f;
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }
}

