/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.util.multiblock;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.common.IILogger;
import pl.pabilo8.immersiveintelligence.common.entity.tactile.TactileHandler;
import pl.pabilo8.immersiveintelligence.common.network.IIMessage;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageIITileSync;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.IIMultiblockInterfaces;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.MultiblockStuctureBase;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.util.MultiblockPOI;

public abstract class TileEntityMultiblockIIBase<T extends TileEntityMultiblockIIBase<T>>
extends TileEntityMultiblockPart<T>
implements IEBlockInterfaces.IMirrorAble,
IIEInventory,
IIMultiblockInterfaces.IAdvancedBounds {
    public static final String KEY_SYNC_AABB = "_sync_aabb";
    protected final MultiblockStuctureBase<T> multiblock;
    private T master = null;
    public static final String KEY_SYNC_ALL_VALUES = "_sync_all_values";
    protected List<AxisAlignedBB> aabb = null;

    protected TileEntityMultiblockIIBase(MultiblockStuctureBase<T> multiblock) {
        super(multiblock.getSize());
        this.multiblock = multiblock;
    }

    public final void func_73660_a() {
        ApiUtils.checkForNeedlessTicking((TileEntity)this);
        if (this.isDummy()) {
            return;
        }
        this.onUpdate();
    }

    public void onLoad() {
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.forceReCacheAABB();
    }

    @Nullable
    public T master() {
        if (this.master != null) {
            return this.master;
        }
        this.master = (TileEntityMultiblockIIBase)super.master();
        return this.master;
    }

    protected abstract void onUpdate();

    public void receiveMessageFromServer(@Nonnull NBTTagCompound message) {
        if (this.isFullSyncMessage(message)) {
            this.readCustomNBT(message, false);
        }
        if (message.func_74764_b(KEY_SYNC_AABB)) {
            this.forMultiblockBlocks(TileEntityMultiblockIIBase::forceReCacheAABB);
        }
    }

    protected final boolean isFullSyncMessage(@Nonnull NBTTagCompound message) {
        return message.func_74764_b(KEY_SYNC_ALL_VALUES);
    }

    @Nonnull
    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        return new IFluidTank[0];
    }

    @Nonnull
    public NonNullList<ItemStack> getInventory() {
        return NonNullList.func_191196_a();
    }

    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resource) {
        return false;
    }

    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return false;
    }

    @Override
    public float[] getBlockBounds() {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    public boolean getIsMirrored() {
        return this.mirrored;
    }

    public IEProperties.PropertyBoolInverted getBoolProperty(Class<? extends IEBlockInterfaces.IUsesBooleanProperty> inf) {
        return IEProperties.BOOLEANS[0];
    }

    public ItemStack getOriginalBlock() {
        if (this.field_174879_c < 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack s = ItemStack.field_190927_a;
        try {
            int blocksPerLevel = this.structureDimensions[1] * this.structureDimensions[2];
            int h = this.field_174879_c / blocksPerLevel;
            int l = this.field_174879_c % blocksPerLevel / this.structureDimensions[2];
            int w = this.field_174879_c % this.structureDimensions[2];
            s = this.multiblock.getStructureManual()[h][l][w];
        }
        catch (Exception e) {
            IILogger.info(e);
        }
        return s.func_77946_l();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (!this.isDummy()) {
            if (this.multiblock.isMassiveStructure()) {
                return INFINITE_EXTENT_AABB;
            }
            BlockPos nullPos = this.getBlockPosForPos(0);
            return new AxisAlignedBB(nullPos, nullPos.func_177967_a(this.facing, this.structureDimensions[1]).func_177967_a(this.mirrored ? this.facing.func_176735_f() : this.facing.func_176746_e(), this.structureDimensions[2]).func_177981_b(this.structureDimensions[0]));
        }
        return super.getRenderBoundingBox();
    }

    public BlockPos[] getMultiblockBlocks() {
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        BlockPos origin = this.func_174877_v().func_177973_b(new Vec3i(this.offset[0], this.offset[1], this.offset[2]));
        for (int y = 0; y < this.structureDimensions[0]; ++y) {
            for (int x = 0; x < this.structureDimensions[1]; ++x) {
                for (int z = 0; z < this.structureDimensions[2]; ++z) {
                    blocks.add(origin.func_177967_a(this.facing, x).func_177967_a(this.facing.func_176746_e(), z).func_177982_a(0, y, 0));
                }
            }
        }
        return blocks.toArray(new BlockPos[0]);
    }

    public void forMultiblockBlocks(Consumer<T> tileAction) {
        for (int i = 0; i < this.structureDimensions[0] * this.structureDimensions[1] * this.structureDimensions[2]; ++i) {
            TileEntity te = this.field_145850_b.func_175625_s(this.getBlockPosForPos(i));
            if (te == null || te.getClass() != this.getClass()) continue;
            tileAction.accept((TileEntityMultiblockIIBase)te);
        }
    }

    public boolean canRenderBreaking() {
        return !this.isDummy();
    }

    public void forceTileUpdate() {
        TileEntityMultiblockPart master = this.master();
        if (master != null) {
            master.func_70296_d();
            master.markContainingBlockForUpdate(null);
            NBTTagCompound nbt = new NBTTagCompound();
            master.writeCustomNBT(nbt, false);
            nbt.func_74757_a(KEY_SYNC_ALL_VALUES, true);
            master.sendNBTMessageClient(nbt);
        }
    }

    public void sendNBTMessageClient(NBTTagCompound message) {
        if (!message.func_82582_d()) {
            IIPacketHandler.sendToClient((TileEntity)this, (IIMessage)new MessageIITileSync((TileEntityIEBase)this, message));
        }
    }

    public void sendNBTMessageServer(NBTTagCompound message) {
        if (!message.func_82582_d()) {
            IIPacketHandler.sendToServer(new MessageIITileSync((TileEntityIEBase)this, message));
        }
    }

    public final void forceReCacheAABB() {
        TactileHandler handler;
        this.aabb = null;
        if (this instanceof TactileHandler.ITactileListener && (handler = ((TactileHandler.ITactileListener)((Object)this)).getTactileHandler()) != null) {
            handler.forceReload();
        }
    }

    @Override
    public List<AxisAlignedBB> getBounds(boolean collision) {
        if (this.field_174879_c != -1 && this.aabb == null) {
            this.aabb = this.multiblock.getAABB(this.field_174879_c, this.func_174877_v(), this.facing, this.mirrored);
        }
        return this.aabb;
    }

    protected abstract int[] listAllPOI(MultiblockPOI var1);

    public final int[] getPOI(MultiblockPOI poi) {
        if (poi.hasChildren()) {
            return this.getAllPOI(poi.getChildren());
        }
        return this.listAllPOI(poi);
    }

    private int[] getAllPOI(List<MultiblockPOI> pois) {
        return pois.stream().map(this::getPOI).flatMapToInt(Arrays::stream).distinct().toArray();
    }

    protected final int[] getPOI(String name) {
        return this.multiblock.getPointsOfInterest(name);
    }

    public final boolean isPOI(MultiblockPOI poi) {
        return Arrays.binarySearch(this.getPOI(poi), this.field_174879_c) >= 0;
    }

    public final boolean isPOI(String poi) {
        return Arrays.binarySearch(this.getPOI(poi), this.field_174879_c) >= 0;
    }

    public final BlockPos getPOIPos(String name) {
        return this.getBlockPosForPos(this.multiblock.getPointOfInterest(name));
    }

    public final BlockPos getPOIPos(MultiblockPOI poi) {
        return this.getBlockPosForPos(this.getPOI(poi)[0]);
    }
}

