/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.util.multiblock;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IICProxy;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.WireApi;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import pl.pabilo8.immersiveintelligence.common.IILogger;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.MultiblockStuctureBase;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.TileEntityMultiblockIIBase;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.util.MultiblockPOI;

public abstract class TileEntityMultiblockIIConnectable<T extends TileEntityMultiblockIIConnectable<T>>
extends TileEntityMultiblockIIBase<T>
implements IImmersiveConnectable {
    protected WireType limitType = null;
    private final List<Pair<Float, Consumer<Float>>> sources = new ArrayList<Pair<Float, Consumer<Float>>>();
    private long lastSourceUpdate = 0L;

    public TileEntityMultiblockIIConnectable(MultiblockStuctureBase<T> multiblock) {
        super(multiblock);
    }

    public void onEnergyPassthrough(int amount) {
    }

    public boolean allowEnergyToPass(ImmersiveNetHandler.Connection con) {
        return true;
    }

    public boolean isRelay() {
        return false;
    }

    public boolean canConnect() {
        return this.isPOI(MultiblockPOI.WIRE_MOUNT);
    }

    public boolean isEnergyOutput() {
        return false;
    }

    public int outputEnergy(int amount, boolean simulate, int energyType) {
        return 0;
    }

    public BlockPos getConnectionMaster(WireType cableType, TargetingInfo target) {
        return this.func_174877_v();
    }

    public boolean canConnectCable(WireType cableType, TargetingInfo target, Vec3i offset) {
        return this.isMatchingCable(cableType) && (this.limitType == null || this.isRelay() && WireApi.canMix((WireType)this.limitType, (WireType)cableType));
    }

    protected abstract boolean isMatchingCable(WireType var1);

    public void connectCable(WireType cableType, TargetingInfo target, IImmersiveConnectable other) {
        this.limitType = cableType;
    }

    public WireType getCableLimiter(TargetingInfo target) {
        return this.limitType;
    }

    public void removeCable(ImmersiveNetHandler.Connection connection) {
        WireType type = connection != null ? connection.cableType : null;
        Set outputs = ImmersiveNetHandler.INSTANCE.getConnections(this.field_145850_b, Utils.toCC((Object)this));
        if (!(outputs != null && outputs.size() != 0 || type != this.limitType && type != null)) {
            this.limitType = null;
        }
        this.func_70296_d();
        if (this.field_145850_b != null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    public void addAvailableEnergy(float amount, Consumer<Float> consume) {
        long currentTime = this.field_145850_b.func_82737_E();
        if (this.lastSourceUpdate != currentTime) {
            this.sources.clear();
            Pair<Float, Consumer<Float>> own = this.getOwnEnergy();
            if (own != null) {
                this.sources.add(own);
            }
            this.lastSourceUpdate = currentTime;
        }
        if (amount > 0.0f && consume != null) {
            this.sources.add((Pair<Float, Consumer<Float>>)new ImmutablePair((Object)Float.valueOf(amount), consume));
        }
    }

    @Nullable
    protected Pair<Float, Consumer<Float>> getOwnEnergy() {
        return null;
    }

    public float getDamageAmount(Entity e, ImmersiveNetHandler.Connection c) {
        int consume;
        float baseDmg = this.getBaseDamage(c);
        float max = this.getMaxDamage(c);
        if (baseDmg == 0.0f || this.field_145850_b.func_82737_E() - this.lastSourceUpdate > 1L) {
            return 0.0f;
        }
        float damage = 0.0f;
        for (int i = 0; i < this.sources.size() && damage < max; damage += baseDmg * (float)consume, ++i) {
            consume = (int)Math.min(((Float)this.sources.get(i).getLeft()).floatValue(), (max - damage) / baseDmg);
        }
        return damage;
    }

    public void processDamage(Entity e, float amount, ImmersiveNetHandler.Connection c) {
        float baseDmg = this.getBaseDamage(c);
        float damage = 0.0f;
        for (int i = 0; i < this.sources.size() && damage < amount; ++i) {
            float consume = Math.min(((Float)this.sources.get(i).getLeft()).floatValue(), (amount - damage) / baseDmg);
            ((Consumer)this.sources.get(i).getRight()).accept(Float.valueOf(consume));
            damage += baseDmg * consume;
            if (consume != ((Float)this.sources.get(i).getLeft()).floatValue()) continue;
            this.sources.remove(i);
            --i;
        }
    }

    protected float getBaseDamage(ImmersiveNetHandler.Connection c) {
        if (c.cableType == WireType.COPPER) {
            return 16.0f / (float)c.cableType.getTransferRate();
        }
        if (c.cableType == WireType.ELECTRUM) {
            return 40.0f / (float)c.cableType.getTransferRate();
        }
        if (c.cableType == WireType.STEEL) {
            return 120.0f / (float)c.cableType.getTransferRate();
        }
        return 0.0f;
    }

    protected float getMaxDamage(ImmersiveNetHandler.Connection c) {
        return (float)(c.cableType.getTransferRate() / 8) * this.getBaseDamage(c);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_189515_b(nbttagcompound);
        this.writeConnsToNBT(nbttagcompound);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 3, nbttagcompound);
    }

    public void onDataPacket(@Nonnull NetworkManager net, @Nonnull SPacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.func_145839_a(nbt);
        this.loadConnsFromNBT(nbt);
    }

    public boolean func_145842_c(int id, int arg) {
        if (id == -1 || id == 255) {
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
            return true;
        }
        if (id == 254) {
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            if (state instanceof IExtendedBlockState) {
                state = state.func_185899_b((IBlockAccess)this.field_145850_b, this.func_174877_v());
                state = state.func_177230_c().getExtendedState(state, (IBlockAccess)this.field_145850_b, this.func_174877_v());
                ImmersiveEngineering.proxy.removeStateFromSmartModelCache((IExtendedBlockState)state);
                ImmersiveEngineering.proxy.removeStateFromConnectionModelCache((IExtendedBlockState)state);
            }
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
            return true;
        }
        return super.func_145842_c(id, arg);
    }

    public void readCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        try {
            this.limitType = nbt.func_74764_b("limitType") ? ApiUtils.getWireTypeFromNBT((NBTTagCompound)nbt, (String)"limitType") : null;
            if (nbt.func_74764_b("connectionList")) {
                this.loadConnsFromNBT(nbt);
            }
        }
        catch (Exception e) {
            IILogger.error("TileEntityMultiblockIIConnectable encountered an error reading connection NBT.");
            IILogger.error(e);
        }
    }

    public void writeCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        try {
            if (this.limitType != null) {
                nbt.func_74778_a("limitType", this.limitType.getUniqueName());
            }
            if (descPacket) {
                this.writeConnsToNBT(nbt);
            }
        }
        catch (Exception e) {
            IILogger.error("TileEntityMultiblockIIConenctable encountered an error writing NBT");
            IILogger.error(e);
        }
    }

    private void loadConnsFromNBT(NBTTagCompound nbt) {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && !ClientUtils.mc().func_71356_B() && nbt != null) {
            NBTTagList connectionList = nbt.func_150295_c("connectionList", 10);
            ImmersiveNetHandler.INSTANCE.clearConnectionsOriginatingFrom(Utils.toCC((Object)this), this.field_145850_b);
            for (int i = 0; i < connectionList.func_74745_c(); ++i) {
                NBTTagCompound conTag = connectionList.func_150305_b(i);
                ImmersiveNetHandler.Connection con = ImmersiveNetHandler.Connection.readFromNBT((NBTTagCompound)conTag);
                if (con != null) {
                    ImmersiveNetHandler.INSTANCE.addConnection(this.field_145850_b, Utils.toCC((Object)this), con);
                    continue;
                }
                IILogger.error("CLIENT read connection as null from {}", nbt);
            }
        }
    }

    private void writeConnsToNBT(NBTTagCompound nbt) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && nbt != null) {
            NBTTagList connectionList = new NBTTagList();
            Set conL = ImmersiveNetHandler.INSTANCE.getConnections(this.field_145850_b, Utils.toCC((Object)this));
            if (conL != null) {
                for (ImmersiveNetHandler.Connection con : conL) {
                    connectionList.func_74742_a((NBTBase)con.writeToNBT());
                }
            }
            nbt.func_74782_a("connectionList", (NBTBase)connectionList);
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        ImmersiveNetHandler.INSTANCE.addProxy(new IICProxy((TileEntity)this));
    }

    public void func_145829_t() {
        super.func_145829_t();
        ApiUtils.addFutureServerTask((World)this.field_145850_b, () -> ImmersiveNetHandler.INSTANCE.onTEValidated((TileEntity)this));
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        ImmersiveNetHandler.INSTANCE.clearAllConnectionsFor(this.func_174877_v(), this.field_145850_b, (IImmersiveConnectable)this, false);
    }
}

