/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.util.multiblock;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorageAdvanced;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.IDataConnector;
import pl.pabilo8.immersiveintelligence.api.data.IDataDevice;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.IIMultiblockInterfaces;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.MultiblockStuctureBase;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.TileEntityMultiblockIIBase;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.util.MultiblockPOI;

public abstract class TileEntityMultiblockIIGeneric<T extends TileEntityMultiblockIIGeneric<T>>
extends TileEntityMultiblockIIBase<T>
implements IIMultiblockInterfaces.IIIInventory,
EnergyHelper.IIEInternalFluxHandler,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IRedstoneOutput,
IDataDevice,
IEBlockInterfaces.IComparatorOverride {
    protected boolean redstoneControlInverted = false;
    public NonNullList<ItemStack> inventory;
    EnergyHelper.IEForgeEnergyWrapper wrapper = new EnergyHelper.IEForgeEnergyWrapper((EnergyHelper.IIEInternalFluxConnector)this, null);
    public FluxStorageAdvanced energyStorage;
    public static final String KEY_INVENTORY = "inventory";
    public static final String KEY_ENERGY = "ifluxEnergy";
    public static final String KEY_REDSTONE_CONTROL = "redstone_control";

    public TileEntityMultiblockIIGeneric(MultiblockStuctureBase<T> multiblock) {
        super(multiblock);
        this.inventory = NonNullList.func_191196_a();
        this.energyStorage = new FluxStorageAdvanced(1);
    }

    public void readCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (this.isDummy()) {
            return;
        }
        if (this.energyStorage.getMaxEnergyStored() != 0) {
            this.energyStorage.readFromNBT(nbt);
        }
        if (this.inventory.size() != 0) {
            this.inventory = Utils.readInventory((NBTTagList)nbt.func_150295_c(KEY_INVENTORY, 10), (int)this.inventory.size());
        }
        this.redstoneControlInverted = nbt.func_74767_n(KEY_REDSTONE_CONTROL);
    }

    public void writeCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (this.isDummy()) {
            return;
        }
        if (this.energyStorage.getMaxEnergyStored() != 0) {
            this.energyStorage.writeToNBT(nbt);
        }
        if (this.inventory.size() != 0) {
            nbt.func_74782_a(KEY_INVENTORY, (NBTBase)Utils.writeInventory(this.inventory));
        }
        nbt.func_74757_a(KEY_REDSTONE_CONTROL, this.redstoneControlInverted);
    }

    @Override
    public void receiveMessageFromServer(@Nonnull NBTTagCompound message) {
        super.receiveMessageFromServer(message);
        if (this.isDummy() || this.isFullSyncMessage(message)) {
            return;
        }
        if (message.func_74764_b(KEY_INVENTORY)) {
            this.inventory = Utils.readInventory((NBTTagList)message.func_150295_c(KEY_INVENTORY, 10), (int)this.inventory.size());
        }
        if (message.func_74764_b(KEY_ENERGY)) {
            this.energyStorage.readFromNBT(message);
        }
        if (message.func_74764_b(KEY_REDSTONE_CONTROL)) {
            this.redstoneControlInverted = message.func_74767_n(KEY_REDSTONE_CONTROL);
        }
    }

    public boolean getRedstoneAtPos(int id) {
        return this.field_145850_b.func_175640_z(this.getBlockPosForPos(this.getPOI(MultiblockPOI.REDSTONE_INPUT)[id])) ^ this.redstoneControlInverted;
    }

    public final boolean canConnectRedstone(@Nonnull IBlockState state, @Nonnull EnumFacing side) {
        return this.isPOI(MultiblockPOI.REDSTONE);
    }

    public boolean hammerUseSide(@Nonnull EnumFacing side, @Nonnull EntityPlayer player, float hitX, float hitY, float hitZ) {
        if (this.isPOI(MultiblockPOI.REDSTONE_INPUT)) {
            TileEntityMultiblockIIGeneric master = (TileEntityMultiblockIIGeneric)this.master();
            if (master != null) {
                master.redstoneControlInverted = !master.redstoneControlInverted;
                ChatUtils.sendServerNoSpamMessages((EntityPlayer)player, (ITextComponent[])new ITextComponent[]{new TextComponentTranslation("chat.immersiveengineering.info.rsControl." + (master.redstoneControlInverted ? "invertedOn" : "invertedOff"), new Object[0])});
                this.forceTileUpdate();
            }
            return true;
        }
        return false;
    }

    public int getStrongRSOutput(@Nonnull IBlockState state, @Nonnull EnumFacing side) {
        return 0;
    }

    @Override
    public final void onReceive(DataPacket packet, @Nullable EnumFacing side) {
        TileEntityMultiblockIIGeneric master = (TileEntityMultiblockIIGeneric)this.master();
        if (master != null && this.isPOI(MultiblockPOI.DATA_INPUT)) {
            master.receiveData(packet, this.field_174879_c);
        }
    }

    public void receiveData(DataPacket packet, int pos) {
    }

    public void sendData(DataPacket packet, EnumFacing facing, int pos) {
        IDataConnector conn = IIUtils.findConnectorFacing(this.getBlockPosForPos(pos), this.field_145850_b, facing);
        if (conn != null) {
            conn.sendPacket(packet);
        }
    }

    @Override
    @Nonnull
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.isPOI(MultiblockPOI.ITEM_INPUT)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public int getComparatorInputOverride() {
        if (!this.isPOI(MultiblockPOI.REDSTONE_OUTPUT)) {
            return 0;
        }
        TileEntityMultiblockIIGeneric master = (TileEntityMultiblockIIGeneric)this.master();
        if (master == null) {
            return 0;
        }
        return Utils.calcRedstoneFromInventory((IIEInventory)master);
    }

    protected final IEInventoryHandler getSingleInventoryHandler(int slotID) {
        return this.getSingleInventoryHandler(slotID, true, true);
    }

    protected final IEInventoryHandler getSingleInventoryHandler(int slotID, boolean canInput, boolean canOutput) {
        return new IEInventoryHandler(1, (IIEInventory)this, slotID, canInput, canOutput);
    }

    @Nonnull
    public final FluxStorage getFluxStorage() {
        TileEntityMultiblockIIGeneric master = (TileEntityMultiblockIIGeneric)this.master();
        if (master != null) {
            return master.energyStorage;
        }
        return this.energyStorage;
    }

    @Nonnull
    public IEEnums.SideConfig getEnergySideConfig(EnumFacing facing) {
        if (this.formed && this.isPOI(MultiblockPOI.ENERGY)) {
            return this.isPOI(MultiblockPOI.ENERGY_OUTPUT) ? IEEnums.SideConfig.OUTPUT : IEEnums.SideConfig.INPUT;
        }
        return IEEnums.SideConfig.NONE;
    }

    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(EnumFacing facing) {
        if (this.formed && this.isPOI(MultiblockPOI.ENERGY)) {
            return this.wrapper;
        }
        return null;
    }

    public void postEnergyTransferUpdate(int energy, boolean simulate) {
        TileEntityMultiblockIIGeneric master;
        if (!simulate && !this.field_145850_b.field_72995_K && (master = (TileEntityMultiblockIIGeneric)this.master()) != null) {
            master.sendNBTMessageClient(master.energyStorage.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    @Nonnull
    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        TileEntityMultiblockIIGeneric master = (TileEntityMultiblockIIGeneric)this.master();
        if (master != null && this.isPOI(MultiblockPOI.FLUID)) {
            return master.getFluidTanks(this.field_174879_c, side);
        }
        return super.getAccessibleFluidTanks(side);
    }

    protected IFluidTank[] getFluidTanks(int pos, EnumFacing side) {
        return new IFluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resource) {
        if (this.isPOI(MultiblockPOI.FLUID_INPUT)) {
            return ((TileEntityMultiblockIIGeneric)this.master()).isTankAvailable(this.field_174879_c, iTank);
        }
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        if (this.isPOI(MultiblockPOI.FLUID_OUTPUT)) {
            return ((TileEntityMultiblockIIGeneric)this.master()).isTankAvailable(this.field_174879_c, iTank);
        }
        return false;
    }

    protected boolean isTankAvailable(int pos, int tank) {
        return false;
    }
}

