/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.util.multiblock.production;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import pl.pabilo8.immersiveintelligence.common.IIGuiList;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.MultiblockStuctureBase;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.TileEntityMultiblockIIGeneric;

public abstract class TileEntityMultiblockProductionBase<T extends TileEntityMultiblockProductionBase<T, R>, R extends IIIMultiblockRecipe>
extends TileEntityMultiblockIIGeneric<T>
implements IEBlockInterfaces.IGuiTile {
    public TileEntityMultiblockProductionBase(MultiblockStuctureBase<T> multiblock) {
        super(multiblock);
    }

    public void outputOrDrop(ItemStack output, @Nullable IItemHandler itemHandler, EnumFacing facing, int ... outputPos) {
        for (int p : outputPos) {
            BlockPos pos = this.getBlockPosForPos(p).func_177972_a(facing.func_176734_d());
            TileEntity inventoryTile = this.field_145850_b.func_175625_s(pos);
            if (inventoryTile != null) {
                output = Utils.insertStackIntoInventory((TileEntity)inventoryTile, (ItemStack)output, (EnumFacing)facing, (boolean)this.field_145850_b.field_72995_K);
            }
            if (!output.func_190926_b()) continue;
            return;
        }
        if (itemHandler != null) {
            output = ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)output, (boolean)this.field_145850_b.field_72995_K);
        }
        if (outputPos.length > 0 && !this.field_145850_b.field_72995_K) {
            Utils.dropStackAtPos((World)this.field_145850_b, (BlockPos)this.getBlockPosForPos(outputPos[0]).func_177972_a(facing.func_176734_d()), (ItemStack)output, (EnumFacing)facing.func_176734_d());
        }
    }

    public void attemptOutput(IEInventoryHandler handler, int slot, int outputPos, EnumFacing facing) {
    }

    public abstract float getMinProductionOffset();

    public abstract int getMaxProductionQueue();

    protected abstract IIMultiblockProcess<R> findNewProductionProcess();

    public abstract float getProductionStep(IIMultiblockProcess<R> var1, boolean var2);

    protected abstract boolean attemptProductionOutput(IIMultiblockProcess<R> var1);

    protected abstract void onProductionFinish(IIMultiblockProcess<R> var1);

    public final T getGuiMaster() {
        return (T)((TileEntityMultiblockProductionBase)this.master());
    }

    public final boolean canOpenGui() {
        return false;
    }

    public boolean canOpenGui(EntityPlayer player) {
        return this.formed;
    }

    public void onGuiOpened(EntityPlayer player, boolean clientside) {
        if (!clientside) {
            this.forceTileUpdate();
        }
    }

    public final int getGuiID() {
        return this.getGUI().ordinal();
    }

    public abstract IIGuiList getGUI();

    public abstract float getProductionProgress(IIMultiblockProcess<R> var1, float var2);

    public static interface IIIMultiblockRecipe {
        public int getTotalProcessTime();

        public int getTotalProcessEnergy();

        public int getMultipleProcessTicks();

        public NBTTagCompound writeToNBT(NBTTagCompound var1);
    }

    public static class IIMultiblockProcess<R extends IIIMultiblockRecipe> {
        public R recipe;
        public float ticks;
        public int maxTicks;

        public IIMultiblockProcess(R recipe) {
            this.recipe = recipe;
            this.ticks = 0.0f;
            this.maxTicks = recipe.getTotalProcessTime();
        }
    }
}

