/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.util.multiblock.production;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import javax.annotation.Nullable;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.MultiblockStuctureBase;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.production.TileEntityMultiblockProductionBase;

public abstract class TileEntityMultiblockProductionSingle<T extends TileEntityMultiblockProductionSingle<T, R>, R extends TileEntityMultiblockProductionBase.IIIMultiblockRecipe>
extends TileEntityMultiblockProductionBase<T, R>
implements IEBlockInterfaces.IGuiTile {
    @Nullable
    public TileEntityMultiblockProductionBase.IIMultiblockProcess<R> currentProcess;

    public TileEntityMultiblockProductionSingle(MultiblockStuctureBase<T> multiblock) {
        super(multiblock);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void onUpdate() {
        TileEntityMultiblockProductionBase.IIMultiblockProcess<R> existingProcess = this.currentProcess;
        if (this.currentProcess != null) {
            if (this.currentProcess.ticks >= (float)this.currentProcess.maxTicks) {
                if (!this.attemptProductionOutput(this.currentProcess)) return;
                this.onProductionFinish(this.currentProcess);
                this.currentProcess = null;
            } else {
                float progress = this.getProductionStep(this.currentProcess, false);
                if (!(progress > 0.0f)) return;
                this.currentProcess.ticks += progress;
                return;
            }
        }
        this.currentProcess = this.findNewProductionProcess();
        if (this.currentProcess == existingProcess) return;
        this.forceTileUpdate();
    }

    @Override
    public float getMinProductionOffset() {
        return 1.0f;
    }

    @Override
    public int getMaxProductionQueue() {
        return 0;
    }

    @Override
    public float getProductionProgress(TileEntityMultiblockProductionBase.IIMultiblockProcess<R> process, float partialTicks) {
        if (process == this.currentProcess && process != null && process.maxTicks != 0) {
            return (process.ticks + this.getProductionStep(process, true) * partialTicks) / (float)process.maxTicks;
        }
        return 0.0f;
    }
}

