/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.util.raytracer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MultipleRayTracer
implements Iterable<RayTraceResult> {
    private static final AxisAlignedBB EMPTY_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private ArrayList<RayTraceResult> hits = new ArrayList();
    private BlockPos lastBLockHit;

    private MultipleRayTracer() {
    }

    public static MultipleRayTracer volumetricTrace(@Nonnull World world, @Nonnull Vec3d posStart, @Nonnull Vec3d posEnd, @Nonnull AxisAlignedBB aabb, List<BlockPos> blockFilter, boolean allowEntities, List<Entity> entityFilter, @Nullable Predicate<IBlockState> stopOn) {
        MultipleRayTracer rayTracer = new MultipleRayTracer();
        double precision = Math.abs(aabb.func_72320_b());
        aabb = aabb.func_186662_g(0.25).func_191194_a(posStart);
        Vector3d p = new Vector3d(posStart.field_72450_a, posStart.field_72448_b, posStart.field_72449_c);
        Vector3d pDiff = new Vector3d(posEnd.field_72450_a, posEnd.field_72448_b, posEnd.field_72449_c);
        pDiff.sub((Tuple3d)p);
        pDiff.normalize();
        pDiff.scale(precision);
        double dist = posStart.func_72438_d(posEnd);
        List<Entity> allEntities = allowEntities ? MultipleRayTracer.listAllEntities(world, posStart, posEnd, entityFilter) : null;
        for (double i = 0.0; i < dist; i += precision) {
            RayTraceResult traceResult;
            BlockPos pos;
            p.add((Tuple3d)pDiff);
            aabb = aabb.func_72317_d(pDiff.x, pDiff.y, pDiff.z);
            if (allowEntities) {
                MultipleRayTracer.traceEntities(rayTracer, aabb, allEntities);
            }
            if ((pos = new BlockPos(p.x, p.y, p.z)).equals((Object)rayTracer.lastBLockHit)) continue;
            rayTracer.lastBLockHit = pos;
            IBlockState state = world.func_180495_p(pos);
            if (state.func_185890_d((IBlockAccess)world, pos) == Block.field_185506_k) continue;
            if (stopOn != null && stopOn.test(world.func_180495_p(pos))) break;
            if (MultipleRayTracer.traceExcludedBlocks(pos, blockFilter) || (traceResult = state.func_185910_a(world, pos, new Vec3d(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c), new Vec3d(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f))) == null || traceResult.field_72313_a == RayTraceResult.Type.MISS) continue;
            rayTracer.addResultToList(traceResult);
        }
        return rayTracer;
    }

    private static List<Entity> listAllEntities(@Nonnull World world, @Nonnull Vec3d posStart, @Nonnull Vec3d posEnd, List<Entity> entityFilter) {
        List entities = world.func_175647_a(Entity.class, new AxisAlignedBB(posStart.field_72450_a, posStart.field_72448_b, posStart.field_72449_c, posEnd.field_72450_a, posEnd.field_72448_b, posEnd.field_72449_c), entity -> entity.func_70067_L() && !entity.field_70145_X);
        entities.removeAll(entityFilter);
        return entities;
    }

    private static void traceEntities(MultipleRayTracer t, AxisAlignedBB aabb, List<Entity> allEntities) {
        Iterator<Entity> it = allEntities.iterator();
        while (it.hasNext()) {
            Entity next = it.next();
            if (!next.func_174813_aQ().func_72326_a(aabb)) continue;
            t.addResultToList(new RayTraceResult(next));
            it.remove();
        }
    }

    static boolean traceExcludedBlocks(BlockPos current, List<BlockPos> blockFilter) {
        Iterator<BlockPos> it = blockFilter.iterator();
        while (it.hasNext()) {
            if (it.next() != current) continue;
            it.remove();
            return true;
        }
        return false;
    }

    private void addResultToList(@Nonnull RayTraceResult traceResult) {
        this.hits.add(traceResult);
    }

    public String toString() {
        return Arrays.toString(this.hits.toArray(new RayTraceResult[0]));
    }

    @Override
    public Iterator<RayTraceResult> iterator() {
        return this.hits.listIterator();
    }

    public List<RayTraceResult> getHits() {
        return this.hits;
    }

    public static class MultipleTracerBuilder {
        private final World world;
        private final Vec3d posStart;
        private final Vec3d posEnd;
        private AxisAlignedBB aabb;
        private boolean allowEntities = true;
        private List<Entity> entityFilter;
        private List<BlockPos> blockFilter;
        private Predicate<IBlockState> stopOn = null;

        private MultipleTracerBuilder(World world, Vec3d posStart, Vec3d posEnd) {
            this.world = world;
            this.posStart = posStart;
            this.posEnd = posEnd;
        }

        public static MultipleTracerBuilder setPos(World world, Vec3d posStart, Vec3d posEnd) {
            return new MultipleTracerBuilder(world, posStart, posEnd);
        }

        public MultipleTracerBuilder setAABB(AxisAlignedBB aabb) {
            this.aabb = aabb;
            return this;
        }

        public MultipleTracerBuilder setRules(boolean allowEntities, Predicate<IBlockState> stopOn) {
            this.allowEntities = allowEntities;
            this.stopOn = stopOn;
            return this;
        }

        public MultipleTracerBuilder setEntityFilter(List<Entity> entityFilter) {
            this.entityFilter = entityFilter;
            return this;
        }

        public MultipleTracerBuilder setBlockFilter(List<BlockPos> blockFilter) {
            this.blockFilter = blockFilter;
            return this;
        }

        public MultipleTracerBuilder setFilters(List<Entity> entityFilter, List<BlockPos> blockFilter) {
            this.entityFilter = entityFilter;
            this.blockFilter = blockFilter;
            return this;
        }

        public MultipleRayTracer volumetricTrace() {
            if (this.entityFilter == null) {
                this.entityFilter = new ArrayList<Entity>();
            }
            if (this.blockFilter == null) {
                this.blockFilter = new ArrayList<BlockPos>();
            }
            if (this.aabb == null) {
                this.aabb = EMPTY_AABB;
            }
            return MultipleRayTracer.volumetricTrace(this.world, this.posStart, this.posEnd, this.aabb, this.blockFilter, this.allowEntities, this.entityFilter, this.stopOn);
        }
    }
}

