/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.util.upgrade_system;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import pl.pabilo8.immersiveintelligence.api.utils.MachineUpgrade;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.IIUtils;

public class UpgradeStorage<T extends TileEntity> {
    private T tile;
    private ArrayList<MachineUpgrade> upgrades = new ArrayList();
    private MachineUpgrade currentlyInstalled = null;
    private int upgradeProgress = 0;
    private int clientUpgradeProgress = 0;

    public UpgradeStorage(T tile) {
        this.tile = tile;
    }

    public void update() {
        if (this.tile.func_145831_w().field_72995_K && (float)this.clientUpgradeProgress < this.getMaxClientProgress()) {
            this.clientUpgradeProgress = (int)Math.min((float)this.clientUpgradeProgress + (float)IIConfigHandler.IIConfig.Tools.wrenchUpgradeProgress / 2.0f, this.getMaxClientProgress());
        }
    }

    public NBTTagCompound saveUpgradesToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        for (MachineUpgrade upgrade : this.upgrades) {
            tag.func_74757_a(upgrade.getName(), true);
        }
        return tag;
    }

    public void getUpgradesFromNBT(NBTTagCompound tag) {
        this.upgrades.clear();
        this.upgrades.addAll(MachineUpgrade.getUpgradesFromNBT(tag));
    }

    public ArrayList<MachineUpgrade> getUpgrades() {
        return this.upgrades;
    }

    @Nullable
    public MachineUpgrade getCurrentlyInstalled() {
        return this.currentlyInstalled;
    }

    public int getInstallProgress() {
        return this.upgradeProgress;
    }

    public int getClientInstallProgress() {
        return this.clientUpgradeProgress;
    }

    float getMaxClientProgress() {
        if (this.getCurrentlyInstalled() != null) {
            return IIUtils.getMaxClientProgress(this.getInstallProgress(), this.getCurrentlyInstalled().getProgressRequired(), this.getCurrentlyInstalled().getSteps());
        }
        return this.getInstallProgress();
    }

    public boolean addUpgradeInstallProgress(int toAdd) {
        this.upgradeProgress += toAdd;
        return true;
    }

    public boolean resetInstallProgress() {
        this.currentlyInstalled = null;
        if (this.upgradeProgress > 0) {
            this.upgradeProgress = 0;
            this.clientUpgradeProgress = 0;
            return true;
        }
        return false;
    }

    public void startUpgrade(@Nonnull MachineUpgrade upgrade) {
        this.currentlyInstalled = upgrade;
        this.upgradeProgress = 0;
        this.clientUpgradeProgress = 0;
    }

    public void removeUpgrade(MachineUpgrade upgrade) {
        this.upgrades.remove(upgrade);
    }

    public boolean hasUpgrade(MachineUpgrade upgrade) {
        return this.upgrades.contains(upgrade);
    }

    public boolean addUpgrade(MachineUpgrade upgrade, boolean test) {
        if (!test && !this.hasUpgrade(upgrade)) {
            this.upgrades.add(upgrade);
            return true;
        }
        return false;
    }
}

