/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.world;

import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.block.simple.BlockIIRubberLog;

public class IIWorldGenRubberTree
extends WorldGenAbstractTree {
    private static final IBlockState TRUNK = IIContent.blockRubberLog.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y);
    private static final IBlockState TRUNK_REBBUR = IIContent.blockRubberLog.func_176223_P().func_177226_a((IProperty)IIContent.blockRubberLog.property, (Comparable)((Object)BlockIIRubberLog.RubberLogs.REBBUR)).func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y);
    private static final IBlockState LEAF = IIContent.blockRubberLeaves.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(true));

    public IIWorldGenRubberTree() {
        super(false);
    }

    protected void func_175921_a(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_177230_c() != Blocks.field_150346_d) {
            this.func_175903_a(worldIn, pos, Blocks.field_150346_d.func_176223_P());
        }
    }

    public boolean isReplaceable(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos) || state.func_177230_c().isWood((IBlockAccess)world, pos) || this.func_150523_a(state.func_177230_c()) || state.func_177230_c() == IIContent.blockRubberSapling;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int i = rand.nextInt(5) + 8;
        int j = i - rand.nextInt(2) - 3;
        int k = i - j;
        int l = 1 + rand.nextInt(k + 1);
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= 256) {
            boolean flag = true;
            for (int i1 = position.func_177956_o(); i1 <= position.func_177956_o() + 1 + i && flag; ++i1) {
                int j1 = i1 - position.func_177956_o() < j ? 0 : l;
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int k1 = position.func_177958_n() - j1; k1 <= position.func_177958_n() + j1 && flag; ++k1) {
                    for (int l1 = position.func_177952_p() - j1; l1 <= position.func_177952_p() + j1 && flag; ++l1) {
                        if (i1 >= 0 && i1 < 256) {
                            if (this.isReplaceable(worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(k1, i1, l1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            BlockPos down = position.func_177977_b();
            IBlockState state = worldIn.func_180495_p(down);
            boolean isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, down, EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
            if (isSoil && position.func_177956_o() < 256 - i - 1) {
                state.func_177230_c().onPlantGrow(state, worldIn, down, position);
                int k2 = 0;
                for (int l2 = position.func_177956_o() + i; l2 >= position.func_177956_o() + j; --l2) {
                    for (int j3 = position.func_177958_n() - k2; j3 <= position.func_177958_n() + k2; ++j3) {
                        int k3 = j3 - position.func_177958_n();
                        for (int i2 = position.func_177952_p() - k2; i2 <= position.func_177952_p() + k2; ++i2) {
                            BlockPos blockpos;
                            int j2 = i2 - position.func_177952_p();
                            if (Math.abs(k3) == k2 && Math.abs(j2) == k2 && k2 > 0 || !(state = worldIn.func_180495_p(blockpos = new BlockPos(j3, l2, i2))).func_177230_c().canBeReplacedByLeaves(state, (IBlockAccess)worldIn, blockpos)) continue;
                            this.func_175903_a(worldIn, blockpos, LEAF);
                        }
                    }
                    if (k2 >= 1 && l2 == position.func_177956_o() + j + 1) {
                        --k2;
                        continue;
                    }
                    if (k2 >= l) continue;
                    ++k2;
                }
                for (int i3 = 0; i3 < i - 1; ++i3) {
                    BlockPos upN = position.func_177981_b(i3);
                    state = worldIn.func_180495_p(upN);
                    if (!state.func_177230_c().isAir(state, (IBlockAccess)worldIn, upN) && !state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, upN)) continue;
                    this.func_175903_a(worldIn, position.func_177981_b(i3), i3 == 1 ? TRUNK_REBBUR : TRUNK);
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

