/*
 * Decompiled with CFR 0.152.
 */
package com.aang23.rsinfinitewireless;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class RSInfiniteWirelessConfig {
    private Configuration config;
    public int infiniteWirelessTransmitterUsage;
    public int infiniteWirelessTransmitterRange;
    private static final String INFINITE_WIRELESS_TRANSMITTER = "infiniteWirelessTransmitter";

    public RSInfiniteWirelessConfig(File configFile) {
        this.config = new Configuration(configFile);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.loadConfig();
    }

    public Configuration getConfig() {
        return this.config;
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("rsinfinitewireless")) {
            this.loadConfig();
        }
    }

    private void loadConfig() {
        this.infiniteWirelessTransmitterUsage = this.config.getInt("infiniteWirelessTransmitterUsage", INFINITE_WIRELESS_TRANSMITTER, 1000, 0, Integer.MAX_VALUE, "The energy used by the Infinite Wireless Transmitter");
        this.infiniteWirelessTransmitterRange = this.config.getInt("infiniteWirelessTransmitterRange", INFINITE_WIRELESS_TRANSMITTER, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, "The range of the Infinite Wireless Transmitter");
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        list.add((IConfigElement)new ConfigElement(this.config.getCategory(INFINITE_WIRELESS_TRANSMITTER)));
        return list;
    }
}

