/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit;

import dev.itsmeow.claimit.api.AdminManager;
import dev.itsmeow.claimit.api.claim.ClaimArea;
import dev.itsmeow.claimit.api.claim.ClaimManager;
import dev.itsmeow.claimit.api.userconfig.UserConfigManager;
import dev.itsmeow.claimit.api.userconfig.UserConfigTypeRegistry;
import dev.itsmeow.claimit.api.userconfig.UserConfigs;
import dev.itsmeow.claimit.api.util.objects.ClaimChunkUtil;
import dev.itsmeow.claimit.command.CommandClaimIt;
import dev.itsmeow.claimit.config.ClaimItConfig;
import dev.itsmeow.claimit.permission.ClaimItPermissions;
import dev.itsmeow.claimit.util.UserClaimBlocks;
import dev.itsmeow.claimit.util.command.ConfirmationManager;
import dev.itsmeow.claimit.util.text.ColorUtil;
import java.io.File;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.LogManager;

@Mod.EventBusSubscriber(modid="claimit")
@Mod(modid="claimit", name="ClaimIt", version="1.12.2-1.2.1", acceptedMinecraftVersions="[1.12,1.12.2]", acceptableRemoteVersions="*", dependencies="after-required:claimitapi@[1.12.2-1.2.1]")
public class ClaimIt {
    public static final String MOD_ID = "claimit";
    public static final String VERSION = "1.12.2-1.2.1";
    public static final String NAME = "ClaimIt";
    public static final String acceptedMCV = "[1.12,1.12.2]";
    @Mod.Instance(value="claimit")
    public static ClaimIt mod;
    public static Item claiming_item;
    private static HashMap<UUID, Integer> tickJoined;
    private static HashMap<UUID, BlockPos> lastMsPos;
    private static int lastIndex;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        UserConfigs.register();
        ClaimItPermissions.register();
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        AdminManager.clearAdmins();
        UserConfigManager.deserialize();
        ConfirmationManager.getManager().removeAllConfirms();
        UserClaimBlocks.deserialize();
        event.registerServerCommand((ICommand)new CommandClaimIt());
        claiming_item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(ClaimItConfig.claim_create_item));
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppingEvent event) {
        UserConfigManager.serialize();
        UserClaimBlocks.serialize();
    }

    @SubscribeEvent
    public static void onWorldSave(WorldEvent.Save e) {
        UserConfigManager.serialize();
        UserClaimBlocks.serialize();
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent e) {
        tickJoined.put(e.player.func_146103_bH().getId(), e.player.field_70170_p.func_73046_m().func_71259_af());
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent e) {
        tickJoined.remove(e.player.func_146103_bH().getId());
        lastMsPos.remove(e.player.func_146103_bH().getId());
        AdminManager.removeAdmin((EntityPlayer)e.player);
        ConfirmationManager.getManager().removeConfirm((ICommandSender)e.player);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent e) {
        if (!e.player.field_70170_p.field_72995_K) {
            int joinedTick;
            int curTick;
            if (ClaimItConfig.claim_blocks_accrual_period > 0 && (curTick = e.player.field_70170_p.func_73046_m().func_71259_af()) != (joinedTick = tickJoined.getOrDefault(e.player.func_146103_bH().getId(), 0).intValue()) && (curTick - joinedTick) % ClaimItConfig.claim_blocks_accrual_period == 0) {
                UUID uuid = e.player.func_146103_bH().getId();
                int oldAllowed = UserClaimBlocks.getClaimBlocksAllowed(uuid);
                int amount = ClaimItConfig.claim_blocks_accrual_amount;
                if (UserClaimBlocks.getClaimBlocksRemaining(uuid) + amount >= 0) {
                    UserClaimBlocks.setAllowedClaimBlocks(uuid, oldAllowed + amount);
                }
            }
            if (e.player.field_70173_aa % 5 == 0) {
                Boolean value;
                if (e.player.field_70173_aa % 2500 == 0) {
                    lastMsPos.clear();
                }
                if (lastMsPos.get(e.player.func_146103_bH().getId()) == null) {
                    lastMsPos.put(e.player.func_146103_bH().getId(), e.player.func_180425_c());
                }
                BlockPos pos = e.player.func_180425_c();
                ClaimArea lastMsClaim = ClaimManager.getManager().getClaimAtLocation(e.player.field_70170_p, lastMsPos.get(e.player.func_146103_bH().getId()));
                ClaimArea currClaim = ClaimManager.getManager().getClaimAtLocation(e.player.field_70170_p, pos);
                if (lastMsClaim != null) {
                    Boolean value2;
                    if (currClaim == null && ((value2 = (Boolean)UserConfigTypeRegistry.BOOLEAN.storage.getValueFor(UserConfigs.EXIT_MESSAGE, e.player.func_146103_bH().getId())) == null || value2.booleanValue())) {
                        e.player.func_146105_b((ITextComponent)new TextComponentString(ColorUtil.getFormattedClaimMessage(ClaimItConfig.claim_exit_message, lastMsClaim)), true);
                    }
                } else if (currClaim != null && ((value = (Boolean)UserConfigTypeRegistry.BOOLEAN.storage.getValueFor(UserConfigs.ENTRY_MESSAGE, e.player.func_146103_bH().getId())) == null || value.booleanValue())) {
                    e.player.func_146105_b((ITextComponent)new TextComponentString(ColorUtil.getFormattedClaimMessage(ClaimItConfig.claim_entry_message, currClaim)), true);
                }
                lastMsPos.put(e.player.func_146103_bH().getId(), pos);
            }
        }
    }

    @SubscribeEvent
    public static void worldTick(TickEvent.WorldTickEvent e) {
        WorldServer world;
        File regionData;
        if (lastIndex != -1 && ClaimItConfig.prune_unclaimed_chunks && e.world instanceof WorldServer && e.world.func_82737_E() % 20L == 0L && e.phase == TickEvent.Phase.END && (regionData = new File((world = (WorldServer)e.world).func_72860_G().func_75765_b().getAbsoluteFile() + "/region")).exists()) {
            String[] list = regionData.list((file, string) -> string.matches("r.(0|-?[1-9]([0-9]+)?).(0|-?[1-9]([0-9]+)?).mca"));
            if (list.length > lastIndex) {
                String region = list[lastIndex];
                String xStr = region.substring(region.indexOf(46) + 1, region.substring(0, region.lastIndexOf(46) - 1).lastIndexOf(46));
                String zStr = region.substring(region.substring(0, region.lastIndexOf(46) - 1).lastIndexOf(46) + 1, region.lastIndexOf(46));
                int x = Integer.parseInt(xStr);
                int z = Integer.parseInt(zStr);
                x *= 32;
                z *= 32;
                int nonDeleteableChunks = 0;
                for (int i = 0; i < 32; ++i) {
                    for (int j = 0; j < 32; ++j) {
                        int tX = x + i;
                        int tZ = z + j;
                        if (!world.func_190526_b(tX, tZ)) continue;
                        Chunk chunk = world.func_72964_e(tX, tZ);
                        if (chunk.func_177419_t() && ClaimManager.getManager().getClaimsInChunk(world.field_73011_w.getDimension(), new ClaimChunkUtil.ClaimChunk(tX, tZ)).size() == 0) {
                            world.func_72863_F().func_189549_a(chunk);
                            Chunk chunk2 = world.func_72863_F().field_186029_c.func_185932_a(tX, tZ);
                            chunk.func_177446_d(false);
                            chunk.func_76602_a(chunk2.func_76587_i());
                            chunk.func_76630_e();
                            LogManager.getLogger().info("Pruned chunk " + tX + ", " + tZ);
                            continue;
                        }
                        ++nonDeleteableChunks;
                    }
                }
                if (nonDeleteableChunks == 0) {
                    new File(regionData.getAbsolutePath() + "/" + region).delete();
                }
                ++lastIndex;
            } else {
                lastIndex = -1;
            }
        }
    }

    static {
        claiming_item = null;
        tickJoined = new HashMap();
        lastMsPos = new HashMap();
        lastIndex = 0;
    }
}

