/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.claim;

import dev.itsmeow.claimit.api.ClaimItAPI;
import dev.itsmeow.claimit.api.claim.ClaimArea;
import dev.itsmeow.claimit.api.claim.ClaimManager;
import dev.itsmeow.claimit.api.event.claim.ClaimAddedEvent;
import dev.itsmeow.claimit.api.event.claim.ClaimRemovedEvent;
import dev.itsmeow.claimit.api.event.claim.ClaimsClearedEvent;
import dev.itsmeow.claimit.permission.ClaimItPermissions;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.BlockPressurePlate;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockBreakAnim;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="claimit")
public class ClaimEventListener
implements IWorldEventListener {
    public static HashMap<World, ClaimEventListener> listeners = new HashMap();
    protected final MinecraftServer server;
    protected final World world;

    public ClaimEventListener(MinecraftServer server, World world) {
        this.server = server;
        this.world = world;
    }

    @SubscribeEvent
    public static void onClaimAdded(ClaimAddedEvent event) {
        World world = event.getClaim().getWorld();
        if (world != null) {
            ClaimEventListener listener = new ClaimEventListener(world.func_73046_m(), world);
            world.func_72954_a((IWorldEventListener)listener);
            listeners.put(world, listener);
        } else {
            ClaimItAPI.logger.warn("Attempted to add listener for " + event.getClaim().getTrueViewName() + " in dimension " + event.getClaim().getDimensionID() + ", but it was not loaded or did not exist!");
        }
    }

    @SubscribeEvent
    public static void onClaimRemoved(ClaimRemovedEvent event) {
        World world = event.getClaim().getWorld();
        if (world != null && listeners.containsKey(world)) {
            world.func_72848_b((IWorldEventListener)listeners.remove(world));
        } else {
            ClaimItAPI.logger.warn("Attempted to remove listener for " + event.getClaim().getTrueViewName() + " in dimension " + event.getClaim().getDimensionID() + ", but it was not loaded or did not exist!");
        }
    }

    @SubscribeEvent
    public static void onClaimsCleared(ClaimsClearedEvent.Pre event) {
        for (ClaimArea claim : ClaimManager.getManager().getClaimsList()) {
            ClaimEventListener.onClaimRemoved(new ClaimRemovedEvent(claim));
        }
    }

    public void func_184376_a(World world, BlockPos pos, IBlockState oldState, IBlockState newState, int flags) {
        if (oldState.func_177230_c() instanceof BlockPressurePlate && newState.func_177230_c() instanceof BlockPressurePlate) {
            ClaimArea claim;
            boolean oldPower = (Boolean)oldState.func_177229_b((IProperty)BlockPressurePlate.field_176580_a);
            boolean newPower = (Boolean)newState.func_177229_b((IProperty)BlockPressurePlate.field_176580_a);
            if (!oldPower && newPower && (claim = ClaimManager.getManager().getClaimAtLocation(world, pos)) != null) {
                AxisAlignedBB box = new AxisAlignedBB(pos.func_177982_a(-1, -1, -1), pos.func_177982_a(1, 2, 1));
                List players = world.func_72872_a(EntityPlayer.class, box);
                if (players != null && players.size() > 0) {
                    int amountWithPerms = (int)players.stream().filter(player -> claim.getMostSpecificClaim(pos).canUse(player)).count();
                    if (amountWithPerms < 1) {
                        world.func_175656_a(pos, oldState);
                    }
                } else if (!claim.getMostSpecificClaim(pos).isPermissionToggled(ClaimItPermissions.PRESSURE_PLATE)) {
                    world.func_175656_a(pos, oldState);
                }
            }
        }
        if (newState.func_177230_c() == Blocks.field_150480_ab) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                BlockPos posF = pos.func_177972_a(facing);
                ClaimArea claim = ClaimManager.getManager().getClaimAtLocation(world, posF);
                if (claim == null || claim.getMostSpecificClaim(pos).isPermissionToggled(ClaimItPermissions.FIRE_CREATE) || world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150343_Z && claim.getMostSpecificClaim(pos).isPermissionToggled(ClaimItPermissions.FIRE_CREATE_ON_OBSIDIAN)) continue;
                if (oldState.func_177230_c() != Blocks.field_150480_ab) {
                    world.func_175656_a(pos, oldState);
                    continue;
                }
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
        }
    }

    public void func_180441_b(int breakerId, BlockPos pos, int progress) {
        Entity breaker = this.world.func_73045_a(breakerId);
        if (breaker != null && breaker instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)breaker;
            ClaimArea claim = ClaimManager.getManager().getClaimAtLocation(this.world, pos);
            if (claim != null && !claim.canModify((EntityPlayer)player)) {
                for (EntityPlayerMP entityplayermp : this.server.func_184103_al().func_181057_v()) {
                    double d2;
                    double d1;
                    double d0;
                    if (entityplayermp == null || entityplayermp.field_70170_p != this.world || !((d0 = (double)pos.func_177958_n() - entityplayermp.field_70165_t) * d0 + (d1 = (double)pos.func_177956_o() - entityplayermp.field_70163_u) * d1 + (d2 = (double)pos.func_177952_p() - entityplayermp.field_70161_v) * d2 < 1024.0)) continue;
                    entityplayermp.field_71135_a.func_147359_a((Packet)new SPacketBlockBreakAnim(breakerId, pos, -1));
                }
            }
        }
    }

    public void func_174959_b(BlockPos pos) {
    }

    public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
    }

    public void func_184375_a(EntityPlayer player, SoundEvent soundIn, SoundCategory category, double x, double y, double z, float volume, float pitch) {
    }

    public void func_184377_a(SoundEvent soundIn, BlockPos pos) {
    }

    public void func_180442_a(int particleID, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
    }

    public void func_190570_a(int id, boolean ignoreRange, boolean minimiseParticleLevel, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
    }

    public void func_72703_a(Entity entityIn) {
    }

    public void func_72709_b(Entity entityIn) {
    }

    public void func_180440_a(int soundID, BlockPos pos, int data) {
    }

    public void func_180439_a(EntityPlayer player, int type, BlockPos blockPosIn, int data) {
    }
}

