/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.claim;

import dev.itsmeow.claimit.ClaimIt;
import dev.itsmeow.claimit.api.claim.ClaimArea;
import dev.itsmeow.claimit.api.claim.ClaimManager;
import dev.itsmeow.claimit.api.claim.SubClaimArea;
import dev.itsmeow.claimit.api.config.ClaimItAPIConfig;
import dev.itsmeow.claimit.api.event.claim.ClaimCheckPermissionEvent;
import dev.itsmeow.claimit.api.group.Group;
import dev.itsmeow.claimit.api.group.GroupManager;
import dev.itsmeow.claimit.api.permission.ClaimPermissions;
import dev.itsmeow.claimit.config.ClaimItConfig;
import dev.itsmeow.claimit.permission.ClaimItPermissions;
import dev.itsmeow.claimit.serialization.ClaimItGlobalDataSerializer;
import dev.itsmeow.claimit.util.command.CommandUtils;
import dev.itsmeow.claimit.util.text.ColorUtil;
import dev.itsmeow.claimit.util.text.FTC;
import java.util.HashSet;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="claimit")
public class ProtectionEventHandler {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onChat(ServerChatEvent event) {
        String groupName;
        Group group;
        UUID uuid;
        String uuidStr;
        NBTTagCompound tag;
        NBTTagCompound data = ClaimItGlobalDataSerializer.get().data;
        if (data.func_150297_b("PRIMARY_GROUPS", 10) && (tag = data.func_74775_l("PRIMARY_GROUPS")).func_150297_b(uuidStr = (uuid = event.getPlayer().func_146103_bH().getId()).toString(), 8) && (group = GroupManager.getGroup((String)(groupName = tag.func_74779_i(uuidStr)))) != null && (group.getMembers().keySet().contains((Object)uuid) || group.isOwner(uuid)) && group.getTag() != null && ColorUtil.removeColorFormattingCodes(group.getTag()).length() <= ClaimItConfig.max_tag_length && ColorUtil.removeColorFormattingCodes(group.getTag()).length() >= ClaimItConfig.min_tag_length) {
            ITextComponent comp = ColorUtil.getGroupTagComponent(group);
            comp.func_150253_a().add(event.getComponent());
            event.setComponent(comp);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onPermissionCheck(ClaimCheckPermissionEvent event) {
        EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(event.getUUID());
        if (player != null && CommandUtils.isAdminNoded((ICommandSender)player, "claimit.claim.manage.others")) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void onEquipChange(LivingEquipmentChangeEvent e) {
        ItemStack old = e.getTo();
        if (e.getEntityLiving() instanceof EntityPlayer && e.getFrom().func_77973_b() != ClaimIt.claiming_item && old.func_77973_b() == ClaimIt.claiming_item && (e.getSlot() == EntityEquipmentSlot.MAINHAND || e.getSlot() == EntityEquipmentSlot.OFFHAND)) {
            EntityPlayer player = (EntityPlayer)e.getEntityLiving();
            int slot = player.field_71071_by.func_194014_c(old);
            if (old.func_77942_o()) {
                if (old.func_77978_p().func_74764_b("Corner1")) {
                    old.func_77978_p().func_82580_o("Corner1");
                    player.func_174820_d(slot, old);
                    e.getEntity().func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Claiming item moved, canceling claim creation."));
                }
                if (old.func_77978_p().func_74764_b("SubCorner1")) {
                    old.func_77978_p().func_82580_o("SubCorner1");
                    player.func_174820_d(slot, old);
                    e.getEntity().func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Claiming item moved, canceling subclaim creation."));
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBlockRightClicked(PlayerInteractEvent.RightClickBlock e) {
        World world = e.getEntity().func_130014_f_();
        BlockPos pos = e.getPos();
        ClaimManager cm = ClaimManager.getManager();
        ClaimArea claim = cm.getClaimAtLocation(world, pos);
        if (claim != null) {
            EntityPlayer player = e.getEntityPlayer();
            e.setCanceled(!claim.getMostSpecificClaim(pos).canUse(player));
            if (!(claim instanceof SubClaimArea) && ClaimIt.claiming_item != null && e.getItemStack().func_77973_b() == ClaimIt.claiming_item && !world.field_72995_K && claim.hasPermission(e.getEntityPlayer(), ClaimPermissions.MANAGE_PERMS)) {
                if (ClaimItAPIConfig.enable_subclaims && CommandUtils.checkDefaultNode(player, 0, "claimit.subclaim.create")) {
                    EnumHand hand = e.getHand();
                    ItemStack stack = player.func_184586_b(hand);
                    NBTTagCompound data = stack.func_77978_p();
                    if (data == null) {
                        NBTTagCompound newTag;
                        data = newTag = new NBTTagCompound();
                        stack.func_77982_d(newTag);
                    }
                    data.func_82580_o("Corner1");
                    int[] posArray = new int[]{pos.func_177958_n(), pos.func_177952_p()};
                    if (data.func_74764_b("SubCorner1")) {
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.BLUE + "Added subclaim corner 2 at " + TextFormatting.AQUA + posArray[0] + TextFormatting.BLUE + ", " + TextFormatting.AQUA + posArray[1]));
                        int[] corner1 = data.func_74759_k("SubCorner1");
                        int[] corner2 = posArray;
                        BlockPos c1 = new BlockPos(corner1[0], 0, corner1[1]);
                        BlockPos c2 = new BlockPos(corner2[0], 0, corner2[1]);
                        BlockPos sideL = c2.func_177973_b((Vec3i)c1);
                        SubClaimArea newClaim = new SubClaimArea(claim, c1.func_177958_n(), c1.func_177952_p(), sideL.func_177958_n(), sideL.func_177952_p());
                        if (newClaim.getSideLengthX() >= 1 && newClaim.getSideLengthZ() >= 1) {
                            ClaimManager.ClaimAddResult result = claim.addSubClaim(newClaim);
                            if (result == ClaimManager.ClaimAddResult.ADDED) {
                                player.func_145747_a((ITextComponent)new FTC("Subclaim added successfully!", TextFormatting.GREEN));
                            } else if (result == ClaimManager.ClaimAddResult.OVERLAP) {
                                player.func_145747_a((ITextComponent)new FTC("This subclaim overlaps another subclaim!", TextFormatting.RED));
                            } else if (result == ClaimManager.ClaimAddResult.TOO_LARGE) {
                                player.func_145747_a((ITextComponent)new FTC("This subclaim fills the parent claim!", TextFormatting.RED));
                            } else if (result == ClaimManager.ClaimAddResult.ALREADY_EXISTS) {
                                player.func_145747_a((ITextComponent)new FTC("This subclaim already exists!", TextFormatting.RED));
                            } else if (result == ClaimManager.ClaimAddResult.OUT_OF_BOUNDS) {
                                player.func_145747_a((ITextComponent)new FTC("This subclaim extends outside of the parent claim!", TextFormatting.RED));
                            } else if (result == ClaimManager.ClaimAddResult.SAME_NAME) {
                                player.func_145747_a((ITextComponent)new FTC("This subclaim has the same name as another subclaim!", TextFormatting.RED));
                            } else {
                                player.func_145747_a((ITextComponent)new FTC("This subclaim could not be added!", TextFormatting.RED));
                            }
                        } else {
                            player.func_145747_a((ITextComponent)new FTC("Your subclaim must have a length of at least 2 in both directions!", TextFormatting.RED));
                        }
                        data.func_82580_o("SubCorner1");
                    } else {
                        data.func_74783_a("SubCorner1", posArray);
                        player.func_145747_a((ITextComponent)new FTC("Added subclaim corner 1 at " + TextFormatting.AQUA + posArray[0] + TextFormatting.BLUE + ", " + TextFormatting.AQUA + posArray[1], TextFormatting.BLUE));
                    }
                } else {
                    player.func_145747_a((ITextComponent)new FTC("You do not have permission to make subclaims!", TextFormatting.RED));
                }
            }
        } else if (claim == null && ClaimIt.claiming_item != null && e.getItemStack().func_77973_b() == ClaimIt.claiming_item && !world.field_72995_K) {
            EntityPlayer player = e.getEntityPlayer();
            if (CommandUtils.checkDefaultNode(player, 0, "claimit.claim.create")) {
                EnumHand hand = e.getHand();
                ItemStack stack = player.func_184586_b(hand);
                NBTTagCompound data = stack.func_77978_p();
                if (data == null) {
                    NBTTagCompound newTag;
                    data = newTag = new NBTTagCompound();
                    stack.func_77982_d(newTag);
                }
                data.func_82580_o("SubCorner1");
                boolean isInClaim = ClaimManager.getManager().isBlockInAnyClaim(world, pos);
                if (!isInClaim) {
                    int[] posArray = new int[]{pos.func_177958_n(), pos.func_177952_p()};
                    if (data.func_74764_b("Corner1")) {
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.BLUE + "Added corner 2 at " + TextFormatting.AQUA + posArray[0] + TextFormatting.BLUE + ", " + TextFormatting.AQUA + posArray[1]));
                        int[] corner1 = data.func_74759_k("Corner1");
                        int[] corner2 = posArray;
                        BlockPos c1 = new BlockPos(corner1[0], 0, corner1[1]);
                        BlockPos c2 = new BlockPos(corner2[0], 0, corner2[1]);
                        BlockPos sideL = c2.func_177973_b((Vec3i)c1);
                        ClaimArea newClaim = new ClaimArea(player.field_71093_bK, c1.func_177958_n(), c1.func_177952_p(), sideL.func_177958_n(), sideL.func_177952_p(), player);
                        if (newClaim.getSideLengthX() >= 1 && newClaim.getSideLengthZ() >= 1) {
                            ClaimManager.ClaimAddResult result = ClaimManager.getManager().addClaim(newClaim);
                            if (result == ClaimManager.ClaimAddResult.ADDED) {
                                player.func_145747_a((ITextComponent)new FTC("Claim added successfully!", TextFormatting.GREEN));
                            } else if (result == ClaimManager.ClaimAddResult.OVERLAP) {
                                player.func_145747_a((ITextComponent)new FTC("This claim overlaps another claim!", TextFormatting.RED));
                            } else if (result == ClaimManager.ClaimAddResult.TOO_LARGE) {
                                player.func_145747_a((ITextComponent)new FTC("This claim exceeds the maximum possible size!", TextFormatting.RED));
                            } else {
                                player.func_145747_a((ITextComponent)new FTC("This claim could not be added!", TextFormatting.RED));
                            }
                        } else {
                            player.func_145747_a((ITextComponent)new FTC("Your claim must have a length of at least 2 in both directions!", TextFormatting.RED));
                        }
                        data.func_82580_o("Corner1");
                    } else {
                        data.func_74783_a("Corner1", posArray);
                        player.func_145747_a((ITextComponent)new FTC("Added corner 1 at " + TextFormatting.AQUA + posArray[0] + TextFormatting.BLUE + ", " + TextFormatting.AQUA + posArray[1], TextFormatting.BLUE));
                    }
                } else {
                    data.func_82580_o("Corner1");
                    player.func_145747_a((ITextComponent)new FTC("You cannot set a corner inside an existing claim!", TextFormatting.RED));
                }
            } else {
                player.func_145747_a((ITextComponent)new FTC("You do not have permission to make claims!", TextFormatting.RED));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBlockBroken(BlockEvent.BreakEvent e) {
        World world = e.getWorld();
        BlockPos pos = e.getPos();
        ClaimManager cm = ClaimManager.getManager();
        ClaimArea claim = cm.getClaimAtLocation(world, pos);
        if (claim != null) {
            EntityPlayer player = e.getPlayer();
            e.setCanceled(!claim.getMostSpecificClaim(pos).canModify(player));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBlockPlaced(BlockEvent.PlaceEvent e) {
        World world = e.getWorld();
        BlockPos pos = e.getPos();
        ClaimManager cm = ClaimManager.getManager();
        ClaimArea claim = cm.getClaimAtLocation(world, pos);
        if (claim != null) {
            EntityPlayer player = e.getPlayer();
            if (!claim.getMostSpecificClaim(pos).canModify(player)) {
                e.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onFarmTrample(BlockEvent.FarmlandTrampleEvent e) {
        World world = e.getWorld();
        BlockPos pos = e.getPos();
        ClaimManager cm = ClaimManager.getManager();
        ClaimArea claim = cm.getClaimAtLocation(world, pos);
        if (claim != null) {
            Entity ent = e.getEntity();
            if (ent instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)ent;
                e.setCanceled(!claim.getMostSpecificClaim(pos).canModify(player));
            } else {
                e.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerAttackAnimal(AttackEntityEvent e) {
        ClaimArea claim2;
        World world = e.getEntityPlayer().func_130014_f_();
        BlockPos pos = e.getEntityPlayer().func_180425_c();
        ClaimManager cm = ClaimManager.getManager();
        ClaimArea claim = cm.getClaimAtLocation(world, pos);
        if (claim != null) {
            EntityPlayer player = e.getEntityPlayer();
            if (e.getTarget() instanceof EntityPlayer) {
                e.setCanceled(!claim.getMostSpecificClaim(pos).canPVP(player) || ClaimItConfig.forceNoPVPInClaim);
            } else {
                e.setCanceled(!claim.getMostSpecificClaim(pos).canEntity(player));
            }
        }
        if ((claim2 = cm.getClaimAtLocation(world, e.getTarget().func_180425_c())) != null) {
            if (e.getTarget() instanceof EntityPlayer) {
                e.setCanceled(!claim2.getMostSpecificClaim(pos).canPVP(e.getEntityPlayer()) || e.isCanceled() || ClaimItConfig.forceNoPVPInClaim);
            } else {
                e.setCanceled(!claim2.getMostSpecificClaim(pos).canEntity(e.getEntityPlayer()) || e.isCanceled());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityRightClicked(PlayerInteractEvent.EntityInteract e) {
        World world = e.getEntity().func_130014_f_();
        BlockPos pos = e.getEntity().func_180425_c();
        BlockPos pos2 = e.getPos();
        ClaimManager cm = ClaimManager.getManager();
        EntityPlayer player = e.getEntityPlayer();
        ClaimArea claim = cm.getClaimAtLocation(world, pos);
        ClaimArea claim2 = cm.getClaimAtLocation(world, pos2);
        if (claim != null) {
            e.setCanceled(!claim.getMostSpecificClaim(pos).canEntity(player) || !claim.getMostSpecificClaim(pos).canUse(player));
        }
        if (claim2 != null) {
            e.setCanceled(!claim2.getMostSpecificClaim(pos).canEntity(player) || !claim2.getMostSpecificClaim(pos).canUse(player) || e.isCanceled());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerUse(PlayerInteractEvent.RightClickEmpty e) {
        World world = e.getEntity().func_130014_f_();
        BlockPos pos = e.getPos();
        ClaimManager cm = ClaimManager.getManager();
        ClaimArea claim = cm.getClaimAtLocation(world, pos);
        if (claim != null) {
            EntityPlayer player = e.getEntityPlayer();
            e.setCanceled(!claim.getMostSpecificClaim(pos).canUse(player));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerUse(PlayerInteractEvent.RightClickItem e) {
        World world = e.getEntity().func_130014_f_();
        BlockPos pos = e.getPos();
        ClaimManager cm = ClaimManager.getManager();
        ClaimArea claim = cm.getClaimAtLocation(world, pos);
        if (claim != null) {
            EntityPlayer player = e.getEntityPlayer();
            e.setCanceled(!claim.getMostSpecificClaim(pos).canUse(player));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerUse(PlayerInteractEvent.LeftClickEmpty e) {
        World world = e.getEntity().func_130014_f_();
        BlockPos pos = e.getPos();
        ClaimManager cm = ClaimManager.getManager();
        ClaimArea claim = cm.getClaimAtLocation(world, pos);
        if (claim != null) {
            EntityPlayer player = e.getEntityPlayer();
            e.setCanceled(!claim.getMostSpecificClaim(pos).canUse(player));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onMobGrief(EntityMobGriefingEvent e) {
        if (e.getEntity() != null && e.getEntity().func_130014_f_() != null) {
            World world = e.getEntity().func_130014_f_();
            BlockPos pos = e.getEntity().func_180425_c();
            ClaimManager cm = ClaimManager.getManager();
            ClaimArea claim = cm.getClaimAtLocation(world, pos);
            if (claim != null) {
                claim = claim.getMostSpecificClaim(pos);
                if (e.getEntity() instanceof EntityVillager) {
                    e.setResult(claim.isPermissionToggled(ClaimItPermissions.MOB_GRIEF_VILLAGER) ? Event.Result.ALLOW : Event.Result.DENY);
                } else {
                    e.setResult(claim.isPermissionToggled(ClaimItPermissions.MOB_GRIEF) ? Event.Result.DEFAULT : Event.Result.DENY);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerAttack(AttackEntityEvent e) {
        World world = e.getEntity().func_130014_f_();
        BlockPos pos = e.getEntity().func_180425_c();
        ClaimManager cm = ClaimManager.getManager();
        ClaimArea claim = cm.getClaimAtLocation(world, pos);
        if (claim != null || cm.getClaimAtLocation(world, e.getEntityPlayer().func_180425_c()) != null) {
            EntityPlayer player = e.getEntityPlayer();
            if (e.getTarget() instanceof EntityPlayer) {
                e.setCanceled(!claim.getMostSpecificClaim(pos).canPVP(player) || ClaimItConfig.forceNoPVPInClaim);
            } else {
                e.setCanceled(!claim.getMostSpecificClaim(pos).canEntity(player));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onHurtEvent(LivingHurtEvent e) {
        EntityLivingBase entity = e.getEntityLiving();
        DamageSource source = e.getSource();
        if (entity != null && source != null) {
            if (source.func_76346_g() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)source.func_76346_g();
                ClaimArea claim = ClaimManager.getManager().getClaimAtLocation(entity.func_130014_f_(), player.func_180425_c());
                ClaimArea claim2 = ClaimManager.getManager().getClaimAtLocation(entity.func_130014_f_(), entity.func_180425_c());
                if (entity instanceof EntityPlayer) {
                    e.setCanceled(claim != null && !claim.getMostSpecificClaim(player.func_180425_c()).canPVP(player) || claim2 != null && !claim2.getMostSpecificClaim(entity.func_180425_c()).canPVP(player) || ClaimItConfig.forceNoPVPInClaim);
                } else {
                    e.setCanceled(claim != null && !claim.getMostSpecificClaim(player.func_180425_c()).canEntity(player) || claim2 != null && !claim2.getMostSpecificClaim(entity.func_180425_c()).canEntity(player));
                }
            }
            ClaimArea claim = ClaimManager.getManager().getClaimAtLocation(entity.func_130014_f_(), entity.func_180425_c());
            if (source == DamageSource.field_76376_m && claim != null) {
                e.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerPickupXp(PlayerPickupXpEvent e) {
        World world = e.getEntity().func_130014_f_();
        BlockPos pos = e.getEntity().func_180425_c();
        ClaimManager cm = ClaimManager.getManager();
        ClaimArea claim = cm.getClaimAtLocation(world, pos);
        if (claim != null) {
            EntityPlayer player = e.getEntityPlayer();
            e.setCanceled(!claim.getMostSpecificClaim(pos).canEntity(player));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onExplode(ExplosionEvent.Detonate e) {
        World world = e.getWorld();
        ClaimManager cm = ClaimManager.getManager();
        HashSet<BlockPos> removeList = new HashSet<BlockPos>();
        for (BlockPos pos : e.getAffectedBlocks()) {
            ClaimArea claim = cm.getClaimAtLocation(world, pos);
            if (claim == null || claim.getMostSpecificClaim(pos).isPermissionToggled(ClaimItPermissions.EXPLOSION)) continue;
            removeList.add(pos);
        }
        HashSet<Entity> removeListE = new HashSet<Entity>();
        for (Entity ent : e.getAffectedEntities()) {
            BlockPos pos = ent.func_180425_c();
            ClaimArea claim = cm.getClaimAtLocation(world, pos);
            if (claim == null || claim.getMostSpecificClaim(pos).isPermissionToggled(ClaimItPermissions.EXPLOSION)) continue;
            removeListE.add(ent);
        }
        for (BlockPos pos : removeList) {
            e.getAffectedBlocks().remove(pos);
        }
        for (Entity ent : removeListE) {
            e.getAffectedEntities().remove(ent);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBlockBrokenLiving(LivingDestroyBlockEvent e) {
        World world = e.getEntityLiving().func_130014_f_();
        BlockPos pos = e.getPos();
        ClaimManager cm = ClaimManager.getManager();
        ClaimArea claim = cm.getClaimAtLocation(world, pos);
        if (claim != null) {
            if (!(e.getEntityLiving() instanceof EntityPlayer)) {
                e.setCanceled(!claim.getMostSpecificClaim(pos).isPermissionToggled(ClaimItPermissions.LIVING_MODIFY));
            } else if (e.getEntityLiving() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)e.getEntityLiving();
                e.setCanceled(!claim.getMostSpecificClaim(pos).canModify(player));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityMount(EntityMountEvent e) {
        if (e.isMounting() && e.getEntityMounting() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e.getEntityMounting();
            ClaimArea claim = ClaimManager.getManager().getClaimAtLocation(e.getWorldObj(), e.getEntityBeingMounted().func_180425_c());
            if (claim != null) {
                e.setCanceled(!claim.getMostSpecificClaim(e.getEntityBeingMounted().func_180425_c()).canEntity(player));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onItemThrow(ItemTossEvent e) {
        World world = e.getPlayer().field_70170_p;
        EntityPlayer player = e.getPlayer();
        BlockPos pos = player.func_180425_c();
        ClaimArea claim = ClaimManager.getManager().getClaimAtLocation(world, pos);
        if (claim != null && !claim.isPermissionToggled(ClaimItPermissions.DROP_ITEM) && !claim.getMostSpecificClaim(pos).canUse(player)) {
            e.setCanceled(true);
            player.func_191521_c(e.getEntityItem().func_92059_d());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onItemPickup(EntityItemPickupEvent e) {
        World world = e.getEntityPlayer().field_70170_p;
        EntityPlayer player = e.getEntityPlayer();
        BlockPos pos = e.getItem().func_180425_c();
        ClaimArea claim = ClaimManager.getManager().getClaimAtLocation(world, pos);
        if (claim != null && !claim.getMostSpecificClaim(pos).isPermissionToggled(ClaimItPermissions.PICKUP_ITEM) && !claim.getMostSpecificClaim(pos).canUse(player)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBonemeal(BonemealEvent e) {
        if (e.getBlock() instanceof BlockGrass) {
            int nearby = 0;
            for (ClaimArea claimI : ClaimManager.getManager().getClaimsList()) {
                if (claimI.getDimensionID() != e.getWorld().field_73011_w.getDimension()) continue;
                int xDistance = Math.abs(claimI.getMainPosition().func_177958_n() - e.getPos().func_177958_n());
                int zDistance = Math.abs(claimI.getMainPosition().func_177952_p() - e.getPos().func_177952_p());
                if (xDistance >= 4 && zDistance >= 4) continue;
                ++nearby;
            }
            e.setCanceled(nearby > 0);
        }
        ClaimArea originalClaim = ClaimManager.getManager().getClaimAtLocation(e.getWorld(), e.getPos());
        if (e.isCanceled()) {
            Random rand = new Random();
            BlockPos blockpos = e.getPos().func_177984_a();
            block1: for (int i = 0; i < 128; ++i) {
                BlockPos blockpos1 = blockpos;
                int j = 0;
                while (true) {
                    if (j >= i / 16) {
                        ClaimArea claimAtLoc = ClaimManager.getManager().getClaimAtLocation(e.getWorld(), blockpos1);
                        if (!e.getWorld().func_175623_d(blockpos1) || claimAtLoc != null && (claimAtLoc != originalClaim || !claimAtLoc.getMostSpecificClaim(blockpos1).canModify(e.getEntityPlayer()))) continue block1;
                        if (rand.nextInt(8) == 0) {
                            e.getWorld().func_180494_b(blockpos1).plantFlower(e.getWorld(), rand, blockpos1);
                            continue block1;
                        }
                        IBlockState iblockstate1 = Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS);
                        if (!Blocks.field_150329_H.func_180671_f(e.getWorld(), blockpos1, iblockstate1)) continue block1;
                        e.getWorld().func_180501_a(blockpos1, iblockstate1, 3);
                        continue block1;
                    }
                    blockpos1 = blockpos1.func_177982_a(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1);
                    if (e.getWorld().func_180495_p(blockpos1.func_177977_b()).func_177230_c() != Blocks.field_150349_c || e.getWorld().func_180495_p(blockpos1).func_185915_l()) continue block1;
                    ++j;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onMultiPlace(BlockEvent.MultiPlaceEvent e) {
        World world = e.getWorld();
        EntityPlayer player = e.getPlayer();
        for (BlockSnapshot snap : e.getReplacedBlockSnapshots()) {
            BlockPos pos = snap.getPos();
            ClaimArea claim = ClaimManager.getManager().getClaimAtLocation(world, pos);
            if (claim == null) continue;
            e.setCanceled(!claim.getMostSpecificClaim(pos).canModify(player) || e.isCanceled());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBowUse(ArrowNockEvent e) {
        World world = e.getWorld();
        EntityPlayer player = e.getEntityPlayer();
        BlockPos pos = player.func_180425_c();
        ClaimArea claim = ClaimManager.getManager().getClaimAtLocation(world, pos);
        if (claim != null && (!claim.getMostSpecificClaim(pos).canUse(player) || ClaimItConfig.forceNoPVPInClaim)) {
            e.setAction(new ActionResult(EnumActionResult.FAIL, (Object)e.getBow()));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onProjectileImpact(ProjectileImpactEvent e) {
        Entity entity = e.getRayTraceResult().field_72308_g;
        if (entity instanceof EntityLiving) {
            EntityLiving el = (EntityLiving)entity;
            ClaimArea claim = ClaimManager.getManager().getClaimAtLocation(el.field_70170_p, el.func_180425_c());
            if (claim != null && !claim.getMostSpecificClaim(el.func_180425_c()).isPermissionToggled(ClaimItPermissions.ALLOW_PROJECTILES)) {
                e.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntitySpawn(LivingSpawnEvent.CheckSpawn e) {
        BlockPos pos = new BlockPos((double)e.getX(), (double)e.getY(), (double)e.getZ());
        ClaimArea claim = ClaimManager.getManager().getClaimAtLocation(e.getWorld(), pos);
        if (claim != null && !claim.getMostSpecificClaim(pos).isPermissionToggled(ClaimItPermissions.ENTITY_SPAWN)) {
            e.setResult(Event.Result.DENY);
        }
    }
}

