/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.command;

import dev.itsmeow.claimit.command.CommandCIBase;
import dev.itsmeow.claimit.util.command.CommandHelpRegistry;
import dev.itsmeow.claimit.util.text.AutoFillHelpChatStyle;
import dev.itsmeow.claimit.util.text.FTC;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.tuple.Pair;

public abstract class CommandCITreeBase
extends CommandCIBase {
    private final Map<String, CommandCIBase> commandMap = new HashMap<String, CommandCIBase>();
    private final Map<String, CommandCIBase> commandAliasMap = new HashMap<String, CommandCIBase>();

    public CommandCITreeBase(CommandCIBase ... subcommands) {
        for (CommandCIBase cmd : subcommands) {
            if (cmd == null) continue;
            this.addSubcommand(cmd);
        }
    }

    public void addSubcommand(CommandCIBase command) {
        this.commandMap.put(command.func_71517_b(), command);
        for (String alias : command.func_71514_a()) {
            this.commandAliasMap.put(alias, command);
        }
        CommandHelpRegistry.registerHelp(this.func_71517_b() + " " + command.func_71517_b(), command::getHelp);
        for (String alias : this.func_71514_a()) {
            CommandHelpRegistry.registerHelp(alias + " " + command.func_71517_b(), command::getHelp);
        }
    }

    public Collection<CommandCIBase> getSubCommands() {
        return this.commandMap.values();
    }

    @Nullable
    public CommandCIBase getSubCommand(String command) {
        CommandCIBase cmd = this.commandMap.get(command);
        if (cmd != null) {
            return cmd;
        }
        return this.commandAliasMap.get(command);
    }

    public Map<String, CommandCIBase> getCommandMap() {
        return Collections.unmodifiableMap(this.commandMap);
    }

    public List<CommandCIBase> getSortedCommandList() {
        ArrayList<CommandCIBase> list = new ArrayList<CommandCIBase>(this.getSubCommands());
        Collections.sort(list);
        return list;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            this.executeBaseCommand(server, sender, args);
        } else {
            CommandCIBase cmd = this.getSubCommand(args[0]);
            if (cmd == null) {
                this.executeBaseCommand(server, sender, args);
            } else {
                if (!cmd.func_184882_a(server, sender)) {
                    throw new CommandException("commands.generic.permission", new Object[0]);
                }
                cmd.func_184881_a(server, sender, CommandCITreeBase.shiftArgs(args));
            }
        }
    }

    public void displaySubCommands(MinecraftServer server, ICommandSender sender) throws CommandException {
        CommandCITreeBase.sendMessage(sender, TextFormatting.AQUA, FTC.Form.BOLD, "Subcommands: ");
        for (CommandCIBase subCmd : this.getSubCommands()) {
            String cmd = this.func_71518_a(sender).substring(0, this.func_71518_a(sender).indexOf(this.func_71517_b() + " ") + this.func_71517_b().length()) + " " + subCmd.func_71517_b();
            CommandCITreeBase.sendSMessage(sender, cmd, new AutoFillHelpChatStyle(cmd, subCmd, sender).func_150238_a(TextFormatting.YELLOW));
        }
    }

    protected void executeBaseCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        this.displaySubCommands(server, sender);
    }

    public static String[] shiftArgs(@Nullable String[] s) {
        if (s == null || s.length == 0) {
            return new String[0];
        }
        String[] s1 = new String[s.length - 1];
        System.arraycopy(s, 1, s1, 0, s1.length);
        return s1;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        Pair<CommandCIBase, String[]> pair = this.getLowestCommandInTree(args, false);
        CommandCIBase command = (CommandCIBase)pair.getLeft();
        if (command == this) {
            ArrayList<String> list = new ArrayList<String>();
            if (args.length == 1) {
                for (CommandCIBase subCommand : this.getSubCommands()) {
                    if (!subCommand.func_71517_b().startsWith(args[0])) continue;
                    list.add(subCommand.func_71517_b());
                }
            }
            if (list.isEmpty()) {
                for (CommandCIBase subCommand : this.getSubCommands()) {
                    list.add(subCommand.func_71517_b());
                }
            }
            return list;
        }
        return command.func_184883_a(server, sender, (String[])pair.getRight(), pos);
    }

    public Pair<CommandCIBase, String[]> getLowestCommandInTree(String[] args, boolean extraArgsNull) {
        CommandCIBase cmd = this;
        boolean endTree = false;
        while (!endTree) {
            if (cmd instanceof CommandCITreeBase) {
                if (args.length > 0) {
                    CommandCIBase newCmd = cmd.getSubCommand(args[0]);
                    if (newCmd != null) {
                        cmd = newCmd;
                        args = CommandCITreeBase.shiftArgs(args);
                        continue;
                    }
                    if (extraArgsNull) {
                        cmd = null;
                    }
                    endTree = true;
                    continue;
                }
                endTree = true;
                continue;
            }
            endTree = true;
        }
        return Pair.of((Object)cmd, (Object)args);
    }

    public boolean func_82358_a(String[] args, int index) {
        CommandCIBase cmd;
        if (index > 0 && args.length > 1 && (cmd = this.getSubCommand(args[0])) != null) {
            return cmd.func_82358_a(CommandCITreeBase.shiftArgs(args), index - 1);
        }
        return false;
    }
}

