/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.command;

import com.google.common.collect.Lists;
import dev.itsmeow.claimit.api.config.ClaimItAPIConfig;
import dev.itsmeow.claimit.command.CommandCIBase;
import dev.itsmeow.claimit.command.CommandCITreeBase;
import dev.itsmeow.claimit.command.claimit.CommandSubAdmin;
import dev.itsmeow.claimit.command.claimit.CommandSubCancel;
import dev.itsmeow.claimit.command.claimit.CommandSubClaim;
import dev.itsmeow.claimit.command.claimit.CommandSubClaimBlocks;
import dev.itsmeow.claimit.command.claimit.CommandSubConfig;
import dev.itsmeow.claimit.command.claimit.CommandSubConfirm;
import dev.itsmeow.claimit.command.claimit.CommandSubGroup;
import dev.itsmeow.claimit.command.claimit.CommandSubHelp;
import dev.itsmeow.claimit.command.claimit.CommandSubShowBorders;
import dev.itsmeow.claimit.command.claimit.CommandSubSubClaim;
import dev.itsmeow.claimit.command.claimit.CommandSubTrust;
import dev.itsmeow.claimit.config.ClaimItConfig;
import dev.itsmeow.claimit.util.command.CommandHelpRegistry;
import dev.itsmeow.claimit.util.text.AutoFillHelpChatStyle;
import dev.itsmeow.claimit.util.text.FTC;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Loader;

public class CommandClaimIt
extends CommandCITreeBase {
    public CommandClaimIt() {
        super(new CommandSubClaim(), new CommandSubGroup(), ClaimItAPIConfig.enable_subclaims ? new CommandSubSubClaim() : null, new CommandSubAdmin(), new CommandSubConfirm(), new CommandSubCancel(), new CommandSubConfig(), new CommandSubClaimBlocks(), new CommandSubShowBorders(), new CommandSubHelp(), new CommandSubTrust());
        CommandHelpRegistry.registerHelp(this.func_71517_b(), this::getHelp);
    }

    public String func_71517_b() {
        return "claimit";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/claimit [subcommand]";
    }

    @Override
    public String getHelp(ICommandSender sender) {
        return "Base command for all of ClaimIt. Click on subcommands/run them to do stuff. Provides version of mod as well.";
    }

    public List<String> func_71514_a() {
        return Arrays.asList("ci");
    }

    @Override
    public void executeBaseCommand(MinecraftServer server, ICommandSender sender, String[] args) {
        CommandClaimIt.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.GRAY, FTC.Form.BOLD, "ClaimIt"), new FTC(" Version ", TextFormatting.DARK_PURPLE, false), new FTC("1.12.2-1.2.1", TextFormatting.YELLOW, false), new FTC(" by ", TextFormatting.DARK_PURPLE, false), new FTC(TextFormatting.DARK_RED, FTC.Form.BOLD, "its_meow")});
        CommandClaimIt.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.GRAY, FTC.Form.BOLD, "ClaimIt API"), new FTC(" Version ", TextFormatting.DARK_PURPLE, false), new FTC("1.12.2-1.2.1", TextFormatting.YELLOW, false)});
        CommandClaimIt.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.BLUE, "Claiming item is "), new TextComponentString("" + TextFormatting.RESET + TextFormatting.GREEN + TextFormatting.ITALIC + ClaimItConfig.claim_create_item_display)});
        CommandClaimIt.sendMessage(sender, TextFormatting.AQUA, FTC.Form.BOLD, "Subcommands: ");
        ArrayList subCommands = Lists.newArrayList((Object[])new String[]{"claim", "group", "trust", "config", "claimblocks", "showborders", "admin", "help"});
        if (ClaimItAPIConfig.enable_subclaims) {
            subCommands.add("subclaim");
        }
        for (String cmdT : subCommands) {
            String cmd = "/claimit " + cmdT;
            CommandCIBase subCmd = this.getSubCommand(cmdT);
            CommandClaimIt.sendSMessage(sender, TextFormatting.YELLOW + cmd, new AutoFillHelpChatStyle(cmd, subCmd, sender));
        }
        CommandClaimIt.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.AQUA, "Alias(es): "), new FTC(TextFormatting.YELLOW, "/ci")});
    }

    @Override
    public String getPermissionString() {
        return "claimit";
    }

    @Override
    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender.func_70003_b(0, "claimit") || !Loader.isModLoaded((String)"sponge");
    }
}

