/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.command.claimit;

import dev.itsmeow.claimit.api.userconfig.UserConfigType;
import dev.itsmeow.claimit.api.userconfig.UserConfigTypeRegistry;
import dev.itsmeow.claimit.command.CommandCIBase;
import dev.itsmeow.claimit.util.text.FTC;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class CommandSubConfig
extends CommandCIBase {
    public String func_71517_b() {
        return "config";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/claimit config <config> <value>";
    }

    @Override
    public String getHelp(ICommandSender sender) {
        return "User configuration command. With no arguments, lists your configurations. Specify a configuration to view its value. Specify a configuration and a value as arguments to set the value.";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (sender instanceof EntityPlayer) {
            if (args.length > 2) {
                throw new WrongUsageException("Too many arguments!", new Object[0]);
            }
            EntityPlayer player = (EntityPlayer)sender;
            if (args.length == 0) {
                for (Class clazz : UserConfigTypeRegistry.getRegistries().keySet()) {
                    UserConfigType type = (UserConfigType)UserConfigTypeRegistry.getRegistries().get((Object)clazz);
                    for (UserConfigType.UserConfig config : type.getConfigs().values()) {
                        Object value = type.storage.getValueFor(config, player.func_146103_bH().getId());
                        if (value == null) {
                            value = config.defaultValue;
                        }
                        CommandSubConfig.sendMessage((ICommandSender)player, new ITextComponent[]{new FTC(TextFormatting.YELLOW, config.parsedName), new FTC(TextFormatting.BLUE, ": "), new FTC(TextFormatting.GREEN, value.toString())});
                    }
                }
            } else if (args.length == 1) {
                String parsedName = args[0];
                boolean hit = false;
                for (Class clazz : UserConfigTypeRegistry.getRegistries().keySet()) {
                    UserConfigType type = (UserConfigType)UserConfigTypeRegistry.getRegistries().get((Object)clazz);
                    UserConfigType.UserConfig config = type.getConfig(parsedName);
                    if (config == null) continue;
                    Object value = type.storage.getValueFor(config, player.func_146103_bH().getId());
                    if (value == null) {
                        value = config.defaultValue;
                    }
                    CommandSubConfig.sendMessage((ICommandSender)player, new ITextComponent[]{new FTC(TextFormatting.YELLOW, config.parsedName), new FTC(TextFormatting.BLUE, ": "), new FTC(TextFormatting.GREEN, value.toString())});
                    hit = true;
                }
                if (!hit) {
                    throw new CommandException("Invalid config name!", new Object[0]);
                }
            } else if (args.length == 2) {
                String parsedName = args[0];
                String valueStr = args[1];
                boolean hit = false;
                for (Class clazz : UserConfigTypeRegistry.getRegistries().keySet()) {
                    UserConfigType type = (UserConfigType)UserConfigTypeRegistry.getRegistries().get((Object)clazz);
                    UserConfigType.UserConfig config = type.getConfig(parsedName);
                    if (config == null) continue;
                    if (type.isValidValue(valueStr)) {
                        type.setValue(config, player.func_146103_bH().getId(), (Object)valueStr);
                        CommandSubConfig.sendMessage((ICommandSender)player, TextFormatting.GREEN, "Set " + parsedName + " to " + valueStr);
                        hit = true;
                        continue;
                    }
                    throw new CommandException("Invalid value for config " + parsedName + " of " + valueStr + "!", new Object[0]);
                }
                if (!hit) {
                    throw new CommandException("Invalid config name!", new Object[0]);
                }
            }
        } else {
            throw new CommandException("You must be a player to use this command!", new Object[0]);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1) {
            ArrayList configs = UserConfigTypeRegistry.getRegistries().values().stream().collect(ArrayList::new, (l, t) -> l.addAll(t.getConfigs().keySet()), (r, r1) -> r1.addAll(r));
            return CommandBase.func_175762_a((String[])args, (Collection)configs);
        }
        return new ArrayList<String>();
    }

    @Override
    public String getPermissionString() {
        return "claimit.config";
    }
}

