/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.command.claimit;

import com.google.common.collect.ImmutableSet;
import dev.itsmeow.claimit.api.claim.ClaimArea;
import dev.itsmeow.claimit.api.claim.ClaimManager;
import dev.itsmeow.claimit.api.claim.SubClaimArea;
import dev.itsmeow.claimit.api.util.objects.ClaimChunkUtil;
import dev.itsmeow.claimit.command.CommandCIBase;
import dev.itsmeow.claimit.config.ClaimItConfig;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketParticles;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="claimit")
public class CommandSubShowBorders
extends CommandCIBase {
    private static HashMap<UUID, Long> borderTime = new HashMap();

    @Override
    public String getHelp(ICommandSender sender) {
        return "Displays claim corners within a chunk area.";
    }

    public String func_71517_b() {
        return "showborders";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/claimit showborders";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            UUID uuid = player.func_146103_bH().getId();
            if (borderTime.containsKey(uuid)) {
                long oldtime = borderTime.get(uuid);
                long time = Math.abs((long)player.field_70173_aa - oldtime);
                if (time < (long)ClaimItConfig.max_show_borders_seconds * 20L) {
                    CommandSubShowBorders.sendMessage(sender, TextFormatting.RED, "You are already viewing claim borders.");
                } else if (time < (long)ClaimItConfig.show_borders_cooldown * 20L + (long)ClaimItConfig.max_show_borders_seconds * 20L) {
                    CommandSubShowBorders.sendMessage(sender, TextFormatting.RED, "You cannot view claim borders for the next " + ClaimItConfig.show_borders_cooldown + " seconds.");
                } else {
                    borderTime.put(uuid, Long.valueOf(player.field_70173_aa));
                    CommandSubShowBorders.sendMessage(sender, TextFormatting.GREEN, "Viewing claim borders for " + ClaimItConfig.max_show_borders_seconds + " seconds.");
                }
            } else {
                borderTime.put(uuid, Long.valueOf(player.field_70173_aa));
                CommandSubShowBorders.sendMessage(sender, TextFormatting.GREEN, "Viewing claim borders for " + ClaimItConfig.max_show_borders_seconds + " seconds.");
            }
        } else {
            throw new CommandException("You must be a player to use this command!", new Object[0]);
        }
    }

    @Override
    public String getPermissionString() {
        return "claimit.showborders";
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent e) {
        long oldtime;
        long time;
        if (borderTime.containsKey(e.player.func_146103_bH().getId()) && (time = Math.abs((long)e.player.field_70173_aa - (oldtime = borderTime.get(e.player.func_146103_bH().getId()).longValue()))) <= (long)ClaimItConfig.max_show_borders_seconds * 20L && e.player.isAddedToWorld() && e.player.func_130014_f_() instanceof WorldServer && e.player instanceof EntityPlayerMP && (long)e.player.field_70173_aa % 20L == 0L) {
            EntityPlayerMP player = (EntityPlayerMP)e.player;
            WorldServer world = (WorldServer)e.player.func_130014_f_();
            ClaimChunkUtil.ClaimChunk chunk = ClaimChunkUtil.getChunk((BlockPos)e.player.func_180425_c());
            CommandSubShowBorders.displayClaimsInChunk(player, world, chunk);
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                int xOff = facing.func_82601_c();
                int zOff = facing.func_82599_e();
                CommandSubShowBorders.displayClaimsInChunk(player, world, new ClaimChunkUtil.ClaimChunk(chunk.x + xOff, chunk.z + zOff));
                CommandSubShowBorders.displayClaimsInChunk(player, world, new ClaimChunkUtil.ClaimChunk(chunk.x + xOff * 2, chunk.z + zOff * 2));
            }
        }
    }

    public static void displayClaimsInChunk(EntityPlayerMP player, WorldServer world, ClaimChunkUtil.ClaimChunk chunk) {
        ImmutableSet claims = ClaimManager.getManager().getClaimsInChunk(world.field_73011_w.getDimension(), chunk);
        if (claims != null && claims.size() > 0) {
            for (ClaimArea claim : claims) {
                CommandSubShowBorders.spawnParticlesOnCorners(player, claim, world, EnumParticleTypes.VILLAGER_HAPPY);
                for (SubClaimArea subclaim : claim.getSubClaims()) {
                    CommandSubShowBorders.spawnParticlesOnCorners(player, (ClaimArea)subclaim, world, EnumParticleTypes.VILLAGER_ANGRY);
                }
            }
        }
    }

    public static void spawnParticlesOnCorners(EntityPlayerMP player, ClaimArea claim, WorldServer world, EnumParticleTypes type) {
        for (int i = 0; i < 4; ++i) {
            BlockPos pos = claim.getFourCorners()[i];
            if (i == 1) {
                pos = pos.func_177982_a(1, 0, 0);
            } else if (i == 2) {
                pos = pos.func_177982_a(0, 0, 1);
            } else if (i == 3) {
                pos = pos.func_177982_a(1, 0, 1);
            }
            CommandSubShowBorders.spawnPathBetween(player, world, new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p()), new BlockPos(pos.func_177958_n(), world.func_72940_L(), pos.func_177952_p()), type);
        }
    }

    public static void spawnPathBetween(EntityPlayerMP player, WorldServer world, BlockPos start, BlockPos dest, EnumParticleTypes type) {
        double stops = 3.0;
        double dirX = (double)(dest.func_177958_n() - start.func_177958_n()) / 3.0;
        double dirY = (double)(dest.func_177956_o() - start.func_177956_o()) / 3.0;
        double dirZ = (double)(dest.func_177952_p() - start.func_177952_p()) / 3.0;
        Vec3d dir = new Vec3d(dirX, dirY, dirZ);
        for (double i = 1.0; i <= 3.0; i += 1.0) {
            Vec3d posOff = dir.func_186678_a(i);
            Vec3d pos = posOff.func_72441_c((double)start.func_177958_n(), (double)start.func_177956_o(), (double)start.func_177952_p());
            player.field_71135_a.func_147359_a((Packet)new SPacketParticles(type, false, (float)pos.field_72450_a, (float)pos.field_72448_b, (float)pos.field_72449_c, 0.0f, 20.0f, 0.0f, 20.0f, 20, new int[0]));
        }
    }
}

