/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.command.claimit;

import dev.itsmeow.claimit.api.claim.ClaimArea;
import dev.itsmeow.claimit.api.permission.ClaimPermissionMember;
import dev.itsmeow.claimit.api.permission.ClaimPermissions;
import dev.itsmeow.claimit.command.CommandCIBase;
import dev.itsmeow.claimit.util.command.CommandUtils;
import dev.itsmeow.claimit.util.text.FTC;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class CommandSubTrust
extends CommandCIBase {
    public static final ClaimPermissionMember[] trustPerms = new ClaimPermissionMember[]{ClaimPermissions.MODIFY, ClaimPermissions.USE, ClaimPermissions.ENTITY, ClaimPermissions.PVP};

    @Override
    public String getHelp(ICommandSender sender) {
        return "A shortcut command to add a player to a claim with modify, use, entity, and pvp all at once. Supports player lists with commas.";
    }

    public String func_71517_b() {
        return "trust";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/claimit trust <username> [claimname]";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            throw new CommandException("Must specify a player or list of players seperated by commas! Usage: " + this.func_71518_a(sender), new Object[0]);
        }
        String username = args[0];
        String claimName = null;
        if (args.length == 2) {
            claimName = args[1];
        }
        ClaimArea claim = CommandUtils.getClaimWithNameOrLocation(claimName, sender);
        if (claimName == null && claim == null) {
            throw new CommandException("There is no claim here!", new Object[0]);
        }
        if (claim == null) {
            throw new CommandException("There is no claim with this name you own!", new Object[0]);
        }
        if (!CommandUtils.isAdminWithNodeOrManage(sender, claim, "claimit.command.claimit.claim.permission.others")) {
            throw new CommandException("You cannot modify members of this claim!", new Object[0]);
        }
        Set<UUID> ids = CommandUtils.getUUIDsForArgument(new HashSet<UUID>(), username, sender, server);
        for (UUID id : ids) {
            if (claim.isOwner(id)) continue;
            int addCount = 0;
            for (ClaimPermissionMember permission : trustPerms) {
                if (!claim.addMember(id, permission)) continue;
                ++addCount;
            }
            if (addCount > 0) {
                CommandSubTrust.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.GREEN, "Successfully added "), new FTC(TextFormatting.YELLOW, username), new FTC(TextFormatting.GREEN, " to claim "), new FTC(TextFormatting.DARK_GREEN, claim.getDisplayedViewName()), new FTC(TextFormatting.GREEN, " with permissions "), new FTC(TextFormatting.AQUA, "modify, use, entity, pvp")});
                continue;
            }
            CommandSubTrust.sendMessage(sender, TextFormatting.RED, "This player already has modify, use, entity, and pvp!");
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 1) {
            return CommandBase.func_175762_a((String[])args, CommandUtils.getPossiblePlayers(list, server, sender, args));
        }
        if (args.length == 2) {
            return CommandBase.func_175762_a((String[])args, CommandUtils.getOwnedClaimNames(list, sender));
        }
        return list;
    }

    @Override
    public String getPermissionString() {
        return "claimit.trust";
    }
}

