/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.command.claimit.claim;

import dev.itsmeow.claimit.api.claim.ClaimArea;
import dev.itsmeow.claimit.api.claim.ClaimManager;
import dev.itsmeow.claimit.command.CommandCIBase;
import dev.itsmeow.claimit.util.command.CommandUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class CommandSubClaimDelete
extends CommandCIBase {
    public String func_71517_b() {
        return "delete";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/claimit claim delete [claimname]";
    }

    @Override
    public String getHelp(ICommandSender sender) {
        return "Deletes a claim. With no arguments, attempts claim at your location. Specify a claim name as an argument to delete that claim. " + (CommandUtils.isAdmin(sender) ? "Admins must specify a true name if using arguments." : "");
    }

    @Override
    public String getPermissionString() {
        return "claimit.claim.delete";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String claimName = null;
        if (args.length == 1) {
            claimName = args[0];
        }
        ClaimArea claim = CommandUtils.getClaimWithNameOrLocation(claimName, sender);
        if (claimName == null && claim == null) {
            throw new CommandException("There is no claim here!", new Object[0]);
        }
        if (claim == null) {
            throw new CommandException("There is no claim with this name you own!", new Object[0]);
        }
        if (!CommandUtils.isAdminWithNodeOrOwner(sender, claim, "claimit.command.claimit.claim.delete.others")) {
            throw new CommandException("You do not have permission to delete this claim!", new Object[0]);
        }
        boolean success = ClaimManager.getManager().deleteClaim(claim);
        CommandSubClaimDelete.sendMessage(sender, TextFormatting.YELLOW, success ? "Claim deleted." : "Claim was not deleted, something canceled it.");
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1) {
            return CommandBase.func_175762_a((String[])args, CommandUtils.getOwnedClaimNames(null, sender));
        }
        return new ArrayList<String>();
    }
}

