/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.command.claimit.claim;

import com.google.common.collect.ImmutableSet;
import dev.itsmeow.claimit.api.claim.ClaimArea;
import dev.itsmeow.claimit.api.claim.ClaimManager;
import dev.itsmeow.claimit.command.CommandCIBase;
import dev.itsmeow.claimit.util.command.CommandUtils;
import dev.itsmeow.claimit.util.command.ConfirmationManager;
import dev.itsmeow.claimit.util.command.IConfirmable;
import dev.itsmeow.claimit.util.text.FTC;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class CommandSubClaimDeleteAll
extends CommandCIBase
implements IConfirmable {
    public String func_71517_b() {
        return "deleteall";
    }

    public String func_71518_a(ICommandSender sender) {
        return CommandUtils.isAdminNoded(sender, "claimit.command.claimit.claim.deleteall.others") ? "/claimit claim deleteall [username]" : "/claimit claim deleteall";
    }

    @Override
    public String getHelp(ICommandSender sender) {
        return CommandUtils.isAdminNoded(sender, "claimit.command.claimit.claim.deleteall.others") ? "Deletes all claims YOU personally (yes, you, admin user) own, or if a username is specified, all of their claims." : "Deletes all claims you own. Must be confirmed via '/claimit confirm'. Can be canceled via '/claimit cancel'";
    }

    @Override
    public String getPermissionString() {
        return "claimit.claim.deleteall";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0 && sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            ImmutableSet ownedClaims = ClaimManager.getManager().getClaimsOwnedByPlayer(player.func_146103_bH().getId());
            if (ownedClaims != null) {
                if (!ConfirmationManager.getManager().needsConfirm(sender)) {
                    ConfirmationManager.getManager().addConfirm(sender, this, new String[]{player.func_70005_c_()});
                    CommandSubClaimDeleteAll.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.DARK_RED, "This will delete ALL of your claims. Are you sure you want to do this? Run "), new FTC(TextFormatting.AQUA, "'/claimit confirm'"), new FTC(TextFormatting.DARK_RED, " to confirm. If you do not want to do this, run "), new FTC(TextFormatting.AQUA, "'/claimit cancel'"), new FTC(TextFormatting.DARK_RED, ".")});
                    return;
                } else {
                    CommandSubClaimDeleteAll.sendMessage(sender, TextFormatting.RED, "Canceling preexisting action. Run this command again to delete all claims.");
                    ConfirmationManager.getManager().removeConfirm(sender);
                }
                return;
            } else {
                CommandSubClaimDeleteAll.sendMessage(sender, TextFormatting.RED, "You don't own any claims!");
            }
            return;
        } else {
            if (args.length != 1 || !CommandUtils.isAdminNoded(sender, "claimit.command.claimit.claim.deleteall.others")) throw new CommandException("Invalid argument count! Usage: " + this.func_71518_a(sender), new Object[0]);
            String name = args[0];
            UUID uuid = CommandUtils.getUUIDForName(name, server);
            if (uuid == null) throw new PlayerNotFoundException("Player " + name + " does not exist!");
            ImmutableSet owned = ClaimManager.getManager().getClaimsOwnedByPlayer(uuid);
            if (owned == null) {
                throw new CommandException("No claims were found.", new Object[0]);
            }
            if (!ConfirmationManager.getManager().needsConfirm(sender)) {
                ConfirmationManager.getManager().addConfirm(sender, this, new String[]{name});
                CommandSubClaimDeleteAll.sendMessage(sender, new ITextComponent[]{new FTC(TextFormatting.DARK_RED, "This will delete ALL of " + name + "'s claims. Are you sure you want to do this? Run "), new FTC(TextFormatting.AQUA, "'/claimit confirm'"), new FTC(TextFormatting.DARK_RED, " to confirm. If you do not want to do this, run "), new FTC(TextFormatting.AQUA, "'/claimit cancel'"), new FTC(TextFormatting.DARK_RED, ".")});
                return;
            } else {
                CommandSubClaimDeleteAll.sendMessage(sender, TextFormatting.RED, "Canceling preexisting action. Run this command again to delete all claims.");
                ConfirmationManager.getManager().removeConfirm(sender);
            }
        }
    }

    @Override
    public String getConfirmName() {
        return "deleteall";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doAction(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length != 1) throw new RuntimeException("A deletion was confirmed, but no player was supplied! What did you do!?!?");
        String player = args[0];
        UUID uuid = CommandUtils.getUUIDForName(player, server);
        if (uuid == null) throw new RuntimeException("A deletion was confirmed, but the player supplied does not exist! What did you do !?!?");
        if (sender instanceof EntityPlayer && !uuid.equals(((EntityPlayer)sender).func_146103_bH().getId()) && !CommandUtils.isAdminNoded(sender, "claimit.command.claimit.claim.deleteall.others")) {
            throw new CommandException("You do not have permission to remove " + player + "'s claims.", new Object[0]);
        }
        ImmutableSet owned = ClaimManager.getManager().getClaimsOwnedByPlayer(uuid);
        if (owned == null) {
            throw new CommandException("No claims were found.", new Object[0]);
        }
        boolean failed = false;
        for (ClaimArea claim : owned) {
            boolean s = ClaimManager.getManager().deleteClaim(claim);
            if (s) continue;
            failed = true;
        }
        CommandSubClaimDeleteAll.sendBMessage(sender, "Removed " + player + "'s claims." + (failed ? " Something prevented some claims from being removed." : ""));
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (CommandUtils.isAdmin(sender)) {
            return CommandUtils.getPossiblePlayers(null, server, sender, args);
        }
        return new ArrayList<String>();
    }
}

